/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.pay;

import com.badlogic.gdx.pay.FreeTrialPeriod;
import javax.annotation.Nullable;

public final class Information {
    public static final Information UNAVAILABLE = new Information(null, null, null);
    private final String localName;
    private final String localDescription;
    private final String localPricing;
    @Deprecated
    private Integer priceInCents;
    private Double priceAsDouble;
    private String priceCurrencyCode;
    @Nullable
    private FreeTrialPeriod freeTrialPeriod;

    public Information(String localName, String localDescription, String localPricing) {
        this.localName = localName;
        this.localDescription = localDescription;
        this.localPricing = localPricing;
    }

    private Information(Builder builder) {
        this.localName = builder.localName;
        this.localDescription = builder.localDescription;
        this.localPricing = builder.localPricing;
        this.priceInCents = builder.priceInCents;
        this.priceAsDouble = builder.priceAsDouble;
        this.priceCurrencyCode = builder.priceCurrencyCode;
        this.freeTrialPeriod = builder.freeTrialPeriod;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Deprecated
    @Nullable
    public Integer getPriceInCents() {
        return this.priceInCents;
    }

    @Nullable
    public FreeTrialPeriod getFreeTrialPeriod() {
        return this.freeTrialPeriod;
    }

    @Nullable
    public Double getPriceAsDouble() {
        return this.priceAsDouble;
    }

    public String getPriceCurrencyCode() {
        return this.priceCurrencyCode;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getLocalDescription() {
        return this.localDescription;
    }

    public String getLocalPricing() {
        return this.localPricing;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Information that = (Information)o;
        if (this.localName != null ? !this.localName.equals(that.localName) : that.localName != null) {
            return false;
        }
        if (this.localDescription != null ? !this.localDescription.equals(that.localDescription) : that.localDescription != null) {
            return false;
        }
        return !(this.localPricing == null ? that.localPricing != null : !this.localPricing.equals(that.localPricing));
    }

    public int hashCode() {
        int result = this.localName != null ? this.localName.hashCode() : 0;
        result = 31 * result + (this.localDescription != null ? this.localDescription.hashCode() : 0);
        result = 31 * result + (this.localPricing != null ? this.localPricing.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Information{localName='" + this.localName + '\'' + ", localDescription='" + this.localDescription + '\'' + ", localPricing='" + this.localPricing + '\'' + '}';
    }

    public static final class Builder {
        private String localName;
        private String localDescription;
        private String localPricing;
        @Deprecated
        private Integer priceInCents;
        private Double priceAsDouble;
        private String priceCurrencyCode;
        private FreeTrialPeriod freeTrialPeriod;

        private Builder() {
        }

        public Builder localName(String val) {
            this.localName = val;
            return this;
        }

        public Builder localDescription(String val) {
            this.localDescription = val;
            return this;
        }

        public Builder freeTrialPeriod(FreeTrialPeriod val) {
            this.freeTrialPeriod = val;
            return this;
        }

        public Builder localPricing(String val) {
            this.localPricing = val;
            return this;
        }

        @Deprecated
        public Builder priceInCents(Integer val) {
            this.priceInCents = val;
            return this;
        }

        public Builder priceAsDouble(Double val) {
            this.priceAsDouble = val;
            return this;
        }

        public Builder priceCurrencyCode(String val) {
            this.priceCurrencyCode = val;
            return this;
        }

        public Information build() {
            return new Information(this);
        }
    }
}

