/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tiledmappacker;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.AbsoluteFileHandleResolver;
import com.badlogic.gdx.backends.lwjgl.LwjglApplication;
import com.badlogic.gdx.backends.lwjgl.LwjglApplicationConfiguration;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.maps.ImageResolver;
import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.maps.tiled.BaseTiledMapLoader;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.TiledMapTileSet;
import com.badlogic.gdx.maps.tiled.TmjMapLoader;
import com.badlogic.gdx.maps.tiled.TmxMapLoader;
import com.badlogic.gdx.maps.tiled.tiles.AnimatedTiledMapTile;
import com.badlogic.gdx.maps.tiled.tiles.StaticTiledMapTile;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.tiledmappacker.TileSetLayout;
import com.badlogic.gdx.tools.texturepacker.TexturePacker;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.JsonWriter;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.XmlReader;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TiledMapPacker {
    private TexturePacker packer;
    private TiledMap map;
    private PackerTmxMapLoader mapLoader = new PackerTmxMapLoader(new AbsoluteFileHandleResolver());
    private PackerTmjMapLoader tmjMapLoader = new PackerTmjMapLoader(new AbsoluteFileHandleResolver());
    private BaseTiledMapLoader.Parameters tmxLoaderParams = new BaseTiledMapLoader.Parameters();
    private BaseTiledMapLoader.Parameters tmjLoaderParams = new BaseTiledMapLoader.Parameters();
    private TiledMapPackerSettings settings;
    private static final String TilesetsOutputDir = "tileset";
    private static String AtlasOutputName = "packed";
    private HashMap<String, IntArray> tilesetUsedIds = new HashMap();
    private ObjectMap<String, TiledMapTileSet> tilesetsToPack;
    private ObjectMap<String, Array<String>> imagesLayersToPack;
    private ObjectMap<String, String> imageLayerSourceFiles;
    public static File inputDir;
    public static File outputDir;
    public static String projectFilePath;
    private static long uniqueIdCounter;
    private FileHandle currentDir;

    public TiledMapPacker() {
        this(new TiledMapPackerSettings());
    }

    public TiledMapPacker(TiledMapPackerSettings settings) {
        this.settings = settings;
    }

    public void processInputDir(TexturePacker.Settings texturePackerSettings) throws IOException {
        FileHandle inputDirHandle = new FileHandle(inputDir.getCanonicalPath());
        File[] mapFilesInCurrentDir = inputDir.listFiles(new MapFileFilter());
        this.tilesetsToPack = new ObjectMap();
        this.imagesLayersToPack = new ObjectMap();
        this.imageLayerSourceFiles = new ObjectMap();
        for (File mapFile : mapFilesInCurrentDir) {
            this.processSingleMap(mapFile, inputDirHandle, texturePackerSettings);
        }
        this.processSubdirectories(inputDirHandle, texturePackerSettings);
        boolean combineTilesets = this.settings.combineTilesets;
        if (combineTilesets) {
            this.packTilesets(inputDirHandle, texturePackerSettings);
            this.packImageLayerImages(inputDirHandle);
            this.savePacker();
        }
    }

    public void processInputDir(TexturePacker.Settings texturePackerSettings, String inputDirPath, String outputDirPath, @Null String prjtFilePath) throws IOException {
        if (inputDirPath == null || inputDirPath.trim().isEmpty()) {
            throw new IllegalArgumentException("Input directory path must not be empty.");
        }
        inputDir = new File(inputDirPath);
        outputDir = outputDirPath != null && !outputDirPath.trim().isEmpty() ? new File(outputDirPath) : new File(inputDir, "../output/");
        projectFilePath = prjtFilePath != null && !prjtFilePath.trim().isEmpty() ? prjtFilePath : "";
        FileHandle inputDirHandle = new FileHandle(inputDir.getCanonicalPath());
        File[] mapFilesInCurrentDir = inputDir.listFiles(new MapFileFilter());
        this.tilesetsToPack = new ObjectMap();
        this.imagesLayersToPack = new ObjectMap();
        this.imageLayerSourceFiles = new ObjectMap();
        for (File mapFile : mapFilesInCurrentDir) {
            this.processSingleMap(mapFile, inputDirHandle, texturePackerSettings);
        }
        this.processSubdirectories(inputDirHandle, texturePackerSettings);
        boolean combineTilesets = this.settings.combineTilesets;
        if (combineTilesets) {
            this.packTilesets(inputDirHandle, texturePackerSettings);
            this.packImageLayerImages(inputDirHandle);
            this.savePacker();
        }
    }

    private void processSubdirectories(FileHandle currentDir, TexturePacker.Settings texturePackerSettings) throws IOException {
        File[] directories;
        File parentPath = new File(currentDir.path());
        for (File directory : directories = parentPath.listFiles(new DirFilter())) {
            File[] mapFilesInCurrentDir;
            currentDir = new FileHandle(directory.getCanonicalPath());
            for (File mapFile : mapFilesInCurrentDir = directory.listFiles(new MapFileFilter())) {
                this.processSingleMap(mapFile, currentDir, texturePackerSettings);
            }
            this.processSubdirectories(currentDir, texturePackerSettings);
        }
    }

    private void processSingleMap(File mapFile, FileHandle dirHandle, TexturePacker.Settings texturePackerSettings) throws IOException {
        boolean combineTilesets = this.settings.combineTilesets;
        if (!combineTilesets) {
            this.tilesetUsedIds = new HashMap();
            this.tilesetsToPack = new ObjectMap();
            this.imagesLayersToPack = new ObjectMap();
            this.imageLayerSourceFiles = new ObjectMap();
        }
        if (mapFile.getName().endsWith(".tmx")) {
            try {
                if (projectFilePath.isEmpty()) {
                    this.map = this.mapLoader.load(mapFile.getCanonicalPath());
                } else {
                    this.tmxLoaderParams.projectFilePath = projectFilePath;
                    this.map = this.mapLoader.load(mapFile.getCanonicalPath(), this.tmxLoaderParams);
                }
            }
            catch (GdxRuntimeException e) {
                if (e.getMessage() != null && e.getMessage().contains("No class information available.")) {
                    System.out.println("SKIPPING map " + mapFile.getName() + " because it needs a Tiled project file parameter [PROJECTFILEPATH] passed in.\nMessage: " + e.getMessage());
                    return;
                }
                throw e;
            }
            boolean stripUnusedTiles = this.settings.stripUnusedTiles;
            if (stripUnusedTiles) {
                this.stripUnusedTiles();
            } else {
                for (TiledMapTileSet tileset : this.map.getTileSets()) {
                    String tilesetName = tileset.getName();
                    if (this.tilesetsToPack.containsKey(tilesetName)) continue;
                    this.tilesetsToPack.put(tilesetName, tileset);
                }
            }
            if (!combineTilesets) {
                FileHandle tmpHandle = new FileHandle(mapFile.getName());
                this.settings.atlasOutputName = tmpHandle.nameWithoutExtension();
                this.packTilesets(dirHandle, texturePackerSettings);
            }
            FileHandle tmxFile = new FileHandle(mapFile.getCanonicalPath());
            this.writeUpdatedTMX(tmxFile);
            if (!combineTilesets) {
                this.packImageLayerImages(dirHandle);
                this.savePacker();
            }
        } else if (mapFile.getName().endsWith(".tmj")) {
            try {
                if (projectFilePath.isEmpty()) {
                    this.map = this.tmjMapLoader.load(mapFile.getCanonicalPath());
                } else {
                    this.tmjLoaderParams.projectFilePath = projectFilePath;
                    this.map = this.tmjMapLoader.load(mapFile.getCanonicalPath(), this.tmjLoaderParams);
                }
            }
            catch (GdxRuntimeException e) {
                if (e.getMessage() != null && e.getMessage().contains("No class information available.")) {
                    System.out.println("SKIPPING map " + mapFile.getName() + " because it needs a Tiled project file parameter [PROJECTFILEPATH] passed in.\nMessage: " + e.getMessage());
                    return;
                }
                throw e;
            }
            boolean stripUnusedTiles = this.settings.stripUnusedTiles;
            if (stripUnusedTiles) {
                this.stripUnusedTiles();
            } else {
                for (TiledMapTileSet tileset : this.map.getTileSets()) {
                    String tilesetName = tileset.getName();
                    if (this.tilesetsToPack.containsKey(tilesetName)) continue;
                    this.tilesetsToPack.put(tilesetName, tileset);
                }
            }
            if (!combineTilesets) {
                FileHandle tmpHandle = new FileHandle(mapFile.getName());
                this.settings.atlasOutputName = tmpHandle.nameWithoutExtension();
                this.packTilesets(dirHandle, texturePackerSettings);
            }
            FileHandle tmjFile = new FileHandle(mapFile.getCanonicalPath());
            this.writeUpdatedTMJ(tmjFile);
            if (!combineTilesets) {
                this.packImageLayerImages(dirHandle);
                this.savePacker();
            }
        }
    }

    private void savePacker() throws IOException {
        String tilesetOutputDir = outputDir.toString() + "/" + this.settings.tilesetOutputDirectory;
        File relativeTilesetOutputDir = new File(tilesetOutputDir);
        File outputDirTilesets = new File(relativeTilesetOutputDir.getCanonicalPath());
        outputDirTilesets.mkdirs();
        this.packer.pack(outputDirTilesets, this.settings.atlasOutputName + ".atlas");
    }

    private void stripUnusedTiles() {
        int mapWidth = this.map.getProperties().get("width", Integer.class);
        int mapHeight = this.map.getProperties().get("height", Integer.class);
        int numlayers = this.map.getLayers().getCount();
        int bucketSize = mapWidth * mapHeight * numlayers;
        for (MapLayer layer : this.map.getLayers()) {
            if (!(layer instanceof TiledMapTileLayer)) continue;
            TiledMapTileLayer tlayer = (TiledMapTileLayer)layer;
            for (int y = 0; y < mapHeight; ++y) {
                for (int x = 0; x < mapWidth; ++x) {
                    if (tlayer.getCell(x, y) == null) continue;
                    TiledMapTile tile = tlayer.getCell(x, y).getTile();
                    if (tile instanceof AnimatedTiledMapTile) {
                        AnimatedTiledMapTile aTile = (AnimatedTiledMapTile)tile;
                        for (StaticTiledMapTile t : aTile.getFrameTiles()) {
                            this.addTile(t, bucketSize);
                        }
                    }
                    this.addTile(tile, bucketSize);
                }
            }
        }
    }

    private void addTile(TiledMapTile tile, int bucketSize) {
        int tileid = tile.getId() & 0x1FFFFFFF;
        String tilesetName = this.tilesetNameFromTileId(this.map, tileid);
        IntArray usedIds = this.getUsedIdsBucket(tilesetName, bucketSize);
        usedIds.add(tileid);
        if (!this.tilesetsToPack.containsKey(tilesetName)) {
            this.tilesetsToPack.put(tilesetName, this.map.getTileSets().getTileSet(tilesetName));
        }
    }

    private String tilesetNameFromTileId(TiledMap map, int tileid) {
        String name = "";
        if (tileid == 0) {
            return "";
        }
        for (TiledMapTileSet tileset : map.getTileSets()) {
            int firstgid = tileset.getProperties().get("firstgid", -1, Integer.class);
            if (firstgid == -1) continue;
            if (tileid >= firstgid) {
                name = tileset.getName();
                continue;
            }
            return name;
        }
        return name;
    }

    private IntArray getUsedIdsBucket(String tilesetName, int size) {
        if (this.tilesetUsedIds.containsKey(tilesetName)) {
            return this.tilesetUsedIds.get(tilesetName);
        }
        if (size <= 0) {
            return null;
        }
        IntArray bucket = new IntArray(size);
        this.tilesetUsedIds.put(tilesetName, bucket);
        return bucket;
    }

    private void packImageLayerImages(FileHandle inputDirHandle) throws IOException {
        for (String imageLayerName : this.imagesLayersToPack.keys()) {
            Array<String> uniqueImageNames = this.imagesLayersToPack.get(imageLayerName);
            for (String uniqueImageName : uniqueImageNames) {
                boolean verbose = this.settings.verbose;
                System.out.println("Processing image in layer " + imageLayerName + " with unique name " + uniqueImageName);
                String imageSourcePath = this.imageLayerSourceFiles.get(uniqueImageName);
                FileHandle imageFileHandle = inputDirHandle.child(imageSourcePath);
                BufferedImage image = ImageIO.read(imageFileHandle.file());
                if (verbose) {
                    System.out.println("Adding image " + imageSourcePath + " from imagelayer '" + imageLayerName + "' to atlas as region '" + uniqueImageName + "'.");
                }
                this.packer.addImage(image, uniqueImageName);
            }
        }
    }

    private void packTilesets(FileHandle inputDirHandle, TexturePacker.Settings texturePackerSettings) throws IOException {
        this.packer = new TexturePacker(texturePackerSettings);
        for (TiledMapTileSet set : this.tilesetsToPack.values()) {
            String imageSource = set.getProperties().get("imagesource", String.class);
            if (imageSource != null) {
                this.packSingleImageTileset(set, inputDirHandle);
                continue;
            }
            System.out.println("Image source on tileset is null, tileset is now assumed to be a 'Collection of Images'");
            if (!this.settings.ignoreCollectionOfImages) {
                this.packCollectionOfImagesTileset(set, inputDirHandle);
                continue;
            }
            System.out.println("--ignore-coi flag is set, Skipping...");
        }
    }

    private void packSingleImageTileset(TiledMapTileSet set, FileHandle inputDirHandle) throws IOException {
        String tilesetName = set.getName();
        System.out.println("Processing tileset " + tilesetName);
        IntArray usedIds = this.settings.stripUnusedTiles ? this.getUsedIdsBucket(tilesetName, -1) : null;
        int tileWidth = set.getProperties().get("tilewidth", Integer.class);
        int tileHeight = set.getProperties().get("tileheight", Integer.class);
        int firstgid = set.getProperties().get("firstgid", Integer.class);
        String imageName = set.getProperties().get("imagesource", String.class);
        TileSetLayout layout = new TileSetLayout(firstgid, set, inputDirHandle);
        int gid = layout.firstgid;
        for (int i = 0; i < layout.numTiles; ++i) {
            boolean verbose = this.settings.verbose;
            if (usedIds != null && !usedIds.contains(gid)) {
                if (verbose) {
                    System.out.println("Stripped id #" + gid + " from tileset \"" + tilesetName + "\"");
                }
            } else {
                Vector2 tileLocation = layout.getLocation(gid);
                BufferedImage tile = new BufferedImage(tileWidth, tileHeight, 6);
                Graphics2D g = tile.createGraphics();
                g.drawImage(layout.image, 0, 0, tileWidth, tileHeight, (int)tileLocation.x, (int)tileLocation.y, (int)tileLocation.x + tileWidth, (int)tileLocation.y + tileHeight, null);
                if (verbose) {
                    System.out.println("Adding " + tileWidth + "x" + tileHeight + " (" + (int)tileLocation.x + ", " + (int)tileLocation.y + ")");
                }
                int adjustedGid = gid - layout.firstgid;
                String separator = "_";
                String regionName = tilesetName + "_" + adjustedGid;
                this.packer.addImage(tile, regionName);
            }
            ++gid;
        }
    }

    private void packCollectionOfImagesTileset(TiledMapTileSet set, FileHandle inputDirHandle) throws IOException {
        String tilesetName = set.getName();
        System.out.println("Processing 'Collection of Images' tileset: " + tilesetName);
        IntArray usedIds = this.settings.stripUnusedTiles ? this.getUsedIdsBucket(tilesetName, -1) : null;
        for (TiledMapTile tile : set) {
            if (tile == null) continue;
            int rawGid = tile.getId();
            if (usedIds != null && !usedIds.contains(rawGid)) continue;
            String tileImageSource = tile.getProperties().get("imagesource", String.class);
            if (tileImageSource == null) {
                if (!this.settings.verbose) continue;
                System.out.println("Tile #" + rawGid + " is missing imagesource, skipping...");
                continue;
            }
            FileHandle tileFile = inputDirHandle.child(tileImageSource);
            BufferedImage tileImage = ImageIO.read(tileFile.file());
            if (tileImage == null) {
                if (!this.settings.verbose) continue;
                System.out.println("Unable to read tile image from: " + tileFile.path());
                continue;
            }
            String regionName = this.removeExtensionIfPresent(tileImageSource);
            this.packer.addImage(tileImage, regionName);
        }
    }

    private String removeExtensionIfPresent(String path) {
        String lowerPath = path.toLowerCase();
        if (lowerPath.endsWith(".png")) {
            return path.substring(0, path.length() - 4);
        }
        if (lowerPath.endsWith(".jpg")) {
            return path.substring(0, path.length() - 4);
        }
        if (lowerPath.endsWith(".jpeg")) {
            return path.substring(0, path.length() - 5);
        }
        return path;
    }

    private String generateUniqueImageName(String imageSource) {
        String baseName = new FileHandle(imageSource).nameWithoutExtension();
        long id = uniqueIdCounter++;
        return "atlas_imagelayer_" + baseName + "_" + id + "x";
    }

    private void processImageLayerNames(Node imagelayerNode) {
        Node imageNode;
        Node nameAttr = imagelayerNode.getAttributes().getNamedItem("name");
        String imageLayerName = nameAttr != null ? nameAttr.getNodeValue() : "";
        for (imageNode = imagelayerNode.getFirstChild(); !(imageNode == null || imageNode.getNodeType() == 1 && imageNode.getNodeName().equals("image")); imageNode = imageNode.getNextSibling()) {
        }
        if (imageNode != null) {
            Node sourceAttr = imageNode.getAttributes().getNamedItem("source");
            String originalImageSource = sourceAttr.getNodeValue();
            String uniqueImageName = this.generateUniqueImageName(originalImageSource);
            sourceAttr.setNodeValue(uniqueImageName);
            if (!this.imagesLayersToPack.containsKey(imageLayerName)) {
                this.imagesLayersToPack.put(imageLayerName, new Array());
            }
            this.imagesLayersToPack.get(imageLayerName).add(uniqueImageName);
            this.imageLayerSourceFiles.put(uniqueImageName, originalImageSource);
            if (this.settings.verbose) {
                System.out.println("Updated image layer '" + imageLayerName + "' source to '" + uniqueImageName + "'.");
            }
        } else {
            System.out.println("No <image> node found in imagelayer: " + imageLayerName);
        }
    }

    private void processTmxImageLayersRecursively(Node parent) {
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            String nodeName = node.getNodeName();
            if (nodeName.equals("imagelayer")) {
                this.processImageLayerNames(node);
                continue;
            }
            if (!nodeName.equals("group")) continue;
            this.processTmxImageLayersRecursively(node);
        }
    }

    private void writeUpdatedTMX(FileHandle tmxFileHandle) throws IOException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(tmxFileHandle.read());
            Node map = doc.getFirstChild();
            while (map.getNodeType() != 1 || map.getNodeName() != "map") {
                if ((map = map.getNextSibling()) != null) continue;
                throw new GdxRuntimeException("Couldn't find map node!");
            }
            TiledMapPacker.setProperty(doc, map, "atlas", this.settings.tilesetOutputDirectory + "/" + this.settings.atlasOutputName + ".atlas");
            this.processTmxImageLayersRecursively(map);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            outputDir.mkdirs();
            StreamResult result = new StreamResult(new File(outputDir, tmxFileHandle.name()));
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("ParserConfigurationException: " + e.getMessage());
        }
        catch (SAXException e) {
            throw new RuntimeException("SAXException: " + e.getMessage());
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("TransformerConfigurationException: " + e.getMessage());
        }
        catch (TransformerException e) {
            throw new RuntimeException("TransformerException: " + e.getMessage());
        }
    }

    private static void setProperty(Document doc, Node parent, String name, String value) {
        Node properties = TiledMapPacker.getFirstChildNodeByName(parent, "properties");
        Node property = TiledMapPacker.getFirstChildByNameAttrValue(properties, "property", "name", name);
        NamedNodeMap attributes = property.getAttributes();
        Node valueNode = attributes.getNamedItem("value");
        if (valueNode == null) {
            valueNode = doc.createAttribute("value");
            valueNode.setNodeValue(value);
            attributes.setNamedItem(valueNode);
        } else {
            valueNode.setNodeValue(value);
        }
    }

    private static Node getFirstChildNodeByName(Node parent, String child) {
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (!childNodes.item(i).getNodeName().equals(child)) continue;
            return childNodes.item(i);
        }
        Element newNode = parent.getOwnerDocument().createElement(child);
        if (childNodes.item(0) != null) {
            return parent.insertBefore(newNode, childNodes.item(0));
        }
        return parent.appendChild(newNode);
    }

    private static Node getFirstChildByNameAttrValue(Node node, String childName, String attr, String value) {
        NamedNodeMap attributes;
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node attribute;
            if (!childNodes.item(i).getNodeName().equals(childName) || !(attribute = (attributes = childNodes.item(i).getAttributes()).getNamedItem(attr)).getNodeValue().equals(value)) continue;
            return childNodes.item(i);
        }
        Element newNode = node.getOwnerDocument().createElement(childName);
        attributes = newNode.getAttributes();
        Attr nodeAttr = node.getOwnerDocument().createAttribute(attr);
        nodeAttr.setNodeValue(value);
        attributes.setNamedItem(nodeAttr);
        if (childNodes.item(0) != null) {
            return node.insertBefore(newNode, childNodes.item(0));
        }
        return node.appendChild(newNode);
    }

    private void writeUpdatedTMJ(FileHandle tmjFileHandle) throws IOException {
        JsonReader jsonReader = new JsonReader();
        JsonValue root = jsonReader.parse(tmjFileHandle);
        this.setProperty(root, "atlas", this.settings.tilesetOutputDirectory + "/" + this.settings.atlasOutputName + ".atlas");
        this.processTmjImageLayersRecursively(root);
        outputDir.mkdirs();
        FileHandle outputFile = new FileHandle(new File(outputDir, tmjFileHandle.name()));
        String jsonOutput = root.prettyPrint(JsonWriter.OutputType.json, 4);
        outputFile.writeString(jsonOutput, false);
    }

    private void setProperty(JsonValue root, String name, String value) {
        JsonValue properties = root.get("properties");
        if (properties == null) {
            properties = new JsonValue(JsonValue.ValueType.array);
            root.addChild("properties", properties);
        }
        JsonValue property = null;
        JsonValue prop = properties.child;
        while (prop != null) {
            if (name.equals(prop.getString("name", ""))) {
                property = prop;
                break;
            }
            prop = prop.next;
        }
        if (property == null) {
            property = new JsonValue(JsonValue.ValueType.object);
            property.addChild("name", new JsonValue(name));
            property.addChild("type", new JsonValue("string"));
            properties.addChild(property);
        }
        property.remove("value");
        property.addChild("value", new JsonValue(value));
    }

    private void processLayerNode(JsonValue layerNode) {
        JsonValue childLayers;
        String layerType = layerNode.getString("type", "");
        if ("imagelayer".equals(layerType)) {
            this.processImageLayerNames(layerNode);
        } else if ("group".equals(layerType) && (childLayers = layerNode.get("layers")) != null) {
            JsonValue child = childLayers.child;
            while (child != null) {
                this.processLayerNode(child);
                child = child.next;
            }
        }
    }

    private void processTmjImageLayersRecursively(JsonValue root) {
        JsonValue topLevelLayers = root.get("layers");
        if (topLevelLayers == null) {
            return;
        }
        for (JsonValue layer : topLevelLayers) {
            this.processLayerNode(layer);
        }
    }

    private void processImageLayerNames(JsonValue imageLayer) {
        String imageLayerName = imageLayer.getString("name", "");
        JsonValue imageElement = imageLayer.get("image");
        if (imageElement != null) {
            String originalImageSource = imageElement.asString();
            String uniqueImageName = this.generateUniqueImageName(originalImageSource);
            imageElement.set(uniqueImageName);
            if (!this.imagesLayersToPack.containsKey(imageLayerName)) {
                this.imagesLayersToPack.put(imageLayerName, new Array());
            }
            this.imagesLayersToPack.get(imageLayerName).add(uniqueImageName);
            this.imageLayerSourceFiles.put(uniqueImageName, originalImageSource);
            if (this.settings.verbose) {
                System.out.println("Updated image layer '" + imageLayerName + "' source to '" + uniqueImageName + "'.");
            }
        } else {
            System.out.println("No image node found in image layer: " + imageLayerName);
        }
    }

    public static void main(String[] args) {
        final TexturePacker.Settings texturePackerSettings = new TexturePacker.Settings();
        texturePackerSettings.paddingX = 2;
        texturePackerSettings.paddingY = 2;
        texturePackerSettings.edgePadding = true;
        texturePackerSettings.duplicatePadding = true;
        texturePackerSettings.bleed = true;
        texturePackerSettings.alias = true;
        texturePackerSettings.useIndexes = true;
        final TiledMapPackerSettings packerSettings = new TiledMapPackerSettings();
        ArrayList<String> positionalArgs = new ArrayList<String>();
        for (String arg : args) {
            if (arg.equals("--strip-unused")) {
                packerSettings.stripUnusedTiles = true;
                continue;
            }
            if (arg.equals("--combine-tilesets")) {
                packerSettings.combineTilesets = true;
                continue;
            }
            if (arg.equals("--ignore-coi")) {
                packerSettings.ignoreCollectionOfImages = true;
                continue;
            }
            if (arg.equals("-v")) {
                packerSettings.verbose = true;
                continue;
            }
            if (arg.startsWith("-")) {
                System.out.println("\nOption \"" + arg + "\" not recognized.\n");
                TiledMapPacker.printUsage();
                System.exit(0);
                continue;
            }
            positionalArgs.add(arg);
        }
        if (positionalArgs.isEmpty()) {
            System.out.println("Error: Missing required INPUTDIR argument.");
            TiledMapPacker.printUsage();
            System.exit(0);
        }
        if (positionalArgs.size() > 3) {
            System.out.println("Error: Too many positional arguments. Expected up to 3.");
            TiledMapPacker.printUsage();
            System.exit(0);
        }
        inputDir = new File((String)positionalArgs.get(0));
        outputDir = positionalArgs.size() >= 2 ? new File((String)positionalArgs.get(1)) : new File(inputDir, "../output/");
        if (positionalArgs.size() == 3) {
            projectFilePath = (String)positionalArgs.get(2);
        }
        TiledMapPacker packer = new TiledMapPacker(packerSettings);
        LwjglApplicationConfiguration config = new LwjglApplicationConfiguration();
        config.forceExit = false;
        config.width = 100;
        config.height = 50;
        config.title = "TiledMapPacker";
        new LwjglApplication(new ApplicationListener(){

            @Override
            public void resume() {
            }

            @Override
            public void resize(int width, int height) {
            }

            @Override
            public void render() {
            }

            @Override
            public void pause() {
            }

            @Override
            public void dispose() {
            }

            @Override
            public void create() {
                TiledMapPacker packer = new TiledMapPacker(packerSettings);
                if (!inputDir.exists()) {
                    System.out.println(inputDir.getAbsolutePath());
                    throw new RuntimeException("Input directory does not exist: " + inputDir);
                }
                try {
                    packer.processInputDir(texturePackerSettings);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error processing map: " + e.getMessage());
                }
                System.out.println("Finished processing.");
                Gdx.app.exit();
            }
        }, config);
    }

    private static void printUsage() {
        System.out.println("Usage: INPUTDIR [OUTPUTDIR] [PROJECTFILEPATH] [--strip-unused] [--combine-tilesets] [-v]");
        System.out.println("Processes a directory of Tiled .tmx or .tmj maps. Unable to process maps with XML");
        System.out.println("tile layer format.");
        System.out.println("Positional arguments:");
        System.out.println("  INPUTDIR                  path to the input folder containing Tiled maps");
        System.out.println("  OUTPUTDIR                 (optional) path to write processed output");
        System.out.println("  PROJECTFILEPATH           (optional) path to Tiled map project file");
        System.out.println("                            (requires OUTPUTDIR to be provided)");
        System.out.println();
        System.out.println("Flags:");
        System.out.println("  --strip-unused             omits all tiles that are not used. Speeds up");
        System.out.println("                             the processing. Smaller tilesets.");
        System.out.println("  --combine-tilesets         instead of creating a tileset for each map,");
        System.out.println("                             this combines the tilesets into some kind");
        System.out.println("                             of monster tileset. Has problems with tileset");
        System.out.println("                             location. Has problems with nested folders.");
        System.out.println("                             Not recommended.");
        System.out.println("  --ignore-coi               ignores any tilesets made from a collection of images");
        System.out.println("  -v                         outputs which tiles are stripped and included");
        System.out.println();
        System.out.println("Examples:");
        System.out.println("  java -jar TiledMapPacker.jar ./MyMaps");
        System.out.println("  java -jar TiledMapPacker.jar ./MyMaps ./Output --strip-unused -v");
        System.out.println();
    }

    static /* synthetic */ String access$000() {
        return AtlasOutputName;
    }

    static {
        projectFilePath = "";
        uniqueIdCounter = System.nanoTime();
    }

    public static class TiledMapPackerSettings {
        public boolean stripUnusedTiles = false;
        public boolean combineTilesets = false;
        public boolean ignoreCollectionOfImages = false;
        public boolean verbose = false;
        public String tilesetOutputDirectory = "tileset";
        public String atlasOutputName = TiledMapPacker.access$000();
    }

    private static class PackerTmxMapLoader
    extends TmxMapLoader {
        public PackerTmxMapLoader(FileHandleResolver resolver) {
            super(resolver);
        }

        @Override
        protected void addStaticTiles(FileHandle tmxFile, ImageResolver imageResolver, TiledMapTileSet tileSet, XmlReader.Element element, Array<XmlReader.Element> tileElements, String name, int firstgid, int tilewidth, int tileheight, int spacing, int margin, String source, int offsetX, int offsetY, String imageSource, int imageWidth, int imageHeight, FileHandle image) {
            super.addStaticTiles(tmxFile, imageResolver, tileSet, element, tileElements, name, firstgid, tilewidth, tileheight, spacing, margin, source, offsetX, offsetY, imageSource, imageWidth, imageHeight, image);
            if (image == null && tileElements != null) {
                for (XmlReader.Element tileElement : tileElements) {
                    XmlReader.Element imageElement = tileElement.getChildByName("image");
                    if (imageElement == null) continue;
                    String perTilePath = imageElement.getAttribute("source");
                    int localId = tileElement.getIntAttribute("id", 0);
                    int tileId = firstgid + localId;
                    TiledMapTile tile = tileSet.getTile(tileId);
                    if (tile == null || perTilePath == null) continue;
                    tile.getProperties().put("imagesource", perTilePath);
                }
            }
        }

        @Override
        protected AnimatedTiledMapTile createAnimatedTile(TiledMapTileSet tileSet, TiledMapTile originalTile, XmlReader.Element tileElement, int firstgid) {
            AnimatedTiledMapTile animatedTile = super.createAnimatedTile(tileSet, originalTile, tileElement, firstgid);
            if (animatedTile != null) {
                animatedTile.getProperties().putAll(originalTile.getProperties());
            }
            return animatedTile;
        }
    }

    private static class PackerTmjMapLoader
    extends TmjMapLoader {
        public PackerTmjMapLoader(FileHandleResolver resolver) {
            super(resolver);
        }

        @Override
        protected void addStaticTiles(FileHandle tmjFile, ImageResolver imageResolver, TiledMapTileSet tileSet, JsonValue element, JsonValue tiles, String name, int firstgid, int tilewidth, int tileheight, int spacing, int margin, String source, int offsetX, int offsetY, String imageSource, int imageWidth, int imageHeight, FileHandle image) {
            super.addStaticTiles(tmjFile, imageResolver, tileSet, element, tiles, name, firstgid, tilewidth, tileheight, spacing, margin, source, offsetX, offsetY, imageSource, imageWidth, imageHeight, image);
            if (image == null && tiles != null) {
                JsonValue tileEntry = tiles.child;
                while (tileEntry != null) {
                    if (tileEntry.has("image")) {
                        String perTilePath = tileEntry.getString("image");
                        int localId = tileEntry.getInt("id", 0);
                        int tileId = firstgid + localId;
                        TiledMapTile tile = tileSet.getTile(tileId);
                        if (tile != null && perTilePath != null) {
                            tile.getProperties().put("imagesource", perTilePath);
                        }
                    }
                    tileEntry = tileEntry.next;
                }
            }
        }

        @Override
        protected AnimatedTiledMapTile createAnimatedTile(TiledMapTileSet tileSet, TiledMapTile originalTile, JsonValue tileDefinition, int firstgid) {
            AnimatedTiledMapTile animatedTile = super.createAnimatedTile(tileSet, originalTile, tileDefinition, firstgid);
            if (animatedTile != null) {
                animatedTile.getProperties().putAll(originalTile.getProperties());
            }
            return animatedTile;
        }
    }

    private static class MapFileFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".tmx") || name.endsWith(".tmj");
        }
    }

    private static class DirFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File f, String s) {
            return new File(f, s).isDirectory();
        }
    }
}

