/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.attachments;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.esotericsoftware.spine.attachments.VertexAttachment;

public class MeshAttachment
extends VertexAttachment {
    private TextureRegion region;
    private String path;
    private float[] regionUVs;
    private float[] uvs;
    private short[] triangles;
    private final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private int hullLength;
    private MeshAttachment parentMesh;
    private boolean inheritDeform;
    private short[] edges;
    private float width;
    private float height;

    public MeshAttachment(String name) {
        super(name);
    }

    public void setRegion(TextureRegion region) {
        if (region == null) {
            throw new IllegalArgumentException("region cannot be null.");
        }
        this.region = region;
    }

    public TextureRegion getRegion() {
        if (this.region == null) {
            throw new IllegalStateException("Region has not been set: " + this);
        }
        return this.region;
    }

    public void updateUVs() {
        float width;
        float height;
        float u;
        float v;
        if (this.region == null) {
            v = 0.0f;
            u = 0.0f;
            height = 1.0f;
            width = 1.0f;
        } else {
            u = this.region.getU();
            v = this.region.getV();
            width = this.region.getU2() - u;
            height = this.region.getV2() - v;
        }
        float[] regionUVs = this.regionUVs;
        if (this.uvs == null || this.uvs.length != regionUVs.length) {
            this.uvs = new float[regionUVs.length];
        }
        float[] uvs = this.uvs;
        if (this.region instanceof TextureAtlas.AtlasRegion && ((TextureAtlas.AtlasRegion)this.region).rotate) {
            int n = uvs.length;
            for (int i = 0; i < n; i += 2) {
                uvs[i] = u + regionUVs[i + 1] * width;
                uvs[i + 1] = v + height - regionUVs[i] * height;
            }
        } else {
            int n = uvs.length;
            for (int i = 0; i < n; i += 2) {
                uvs[i] = u + regionUVs[i] * width;
                uvs[i + 1] = v + regionUVs[i + 1] * height;
            }
        }
    }

    @Override
    public boolean applyDeform(VertexAttachment sourceAttachment) {
        return this == sourceAttachment || this.inheritDeform && this.parentMesh == sourceAttachment;
    }

    public short[] getTriangles() {
        return this.triangles;
    }

    public void setTriangles(short[] triangles) {
        this.triangles = triangles;
    }

    public float[] getRegionUVs() {
        return this.regionUVs;
    }

    public void setRegionUVs(float[] regionUVs) {
        this.regionUVs = regionUVs;
    }

    public float[] getUVs() {
        return this.uvs;
    }

    public void setUVs(float[] uvs) {
        this.uvs = uvs;
    }

    public Color getColor() {
        return this.color;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getHullLength() {
        return this.hullLength;
    }

    public void setHullLength(int hullLength) {
        this.hullLength = hullLength;
    }

    public void setEdges(short[] edges) {
        this.edges = edges;
    }

    public short[] getEdges() {
        return this.edges;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public MeshAttachment getParentMesh() {
        return this.parentMesh;
    }

    public void setParentMesh(MeshAttachment parentMesh) {
        this.parentMesh = parentMesh;
        if (parentMesh != null) {
            this.bones = parentMesh.bones;
            this.vertices = parentMesh.vertices;
            this.regionUVs = parentMesh.regionUVs;
            this.triangles = parentMesh.triangles;
            this.hullLength = parentMesh.hullLength;
            this.worldVerticesLength = parentMesh.worldVerticesLength;
            this.edges = parentMesh.edges;
            this.width = parentMesh.width;
            this.height = parentMesh.height;
        }
    }

    public boolean getInheritDeform() {
        return this.inheritDeform;
    }

    public void setInheritDeform(boolean inheritDeform) {
        this.inheritDeform = inheritDeform;
    }
}

