/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar;

import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Timer;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.domain.Model;
import com.tpwar.game.managers.AccountManager;
import com.tpwar.game.managers.PunishmentManager;
import com.tpwar.game.screens.BattleScreen;
import com.tpwar.game.screens.LoadingScreen;
import com.tpwar.game.screens.LoginScreen;
import com.tpwar.game.screens.MainMenuScreen;
import com.tpwar.game.screens.MapScreen;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.LocalSettings;
import com.tpwar.game.utils.ScaleScreen;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.bank.BankRewardWindow;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import com.tpwar.net.Commander;
import com.tpwar.net.Connection;
import com.tpwar.net.PushService;
import com.tpwar.payment.Billing;
import com.tpwar.payment.PlayerTransaction;
import com.tpwar.platform.ApplicationContext;
import java.util.Observable;
import java.util.Observer;
import java.util.TimeZone;
import packet.Base;
import packet.Payment;
import packet.Punishment;
import packet.Transport;

public class Teleports
extends Game
implements MessageListener,
Observer {
    public SpriteBatch batch;
    public Model model;
    public Connection connection;
    public ApplicationContext context;
    public Billing billing;
    public Commander commander;
    public WindowManager windowManager;
    private Timer.Task pingTask;
    private boolean reconnect;
    private boolean needResetSession;
    private LocalSettings settings;

    public Teleports(ApplicationContext context) {
        this.context = context;
        TimeZone.setDefault(TimeZone.getTimeZone("Europe/Moscow"));
    }

    @Override
    public void create() {
        Gdx.input.setCatchKey(4, true);
        this.batch = new SpriteBatch();
        this.model = Model.getInstance();
        this.billing = Billing.getInstance();
        this.connection = Connection.getInstance();
        this.connection.addObserver(this.model);
        this.connection.addObserver(this);
        if (this.context.getCredentials().isValid()) {
            this.setScreen(new LoadingScreen(this));
        } else {
            this.setScreen(new LoginScreen(this));
        }
        this.context.getPushService().setChangeListener(new PushService.ChangeListener(){

            @Override
            public void changed() {
                if (Teleports.this.connection.isConnected() && LocalSettings.getInstance().get("player_notifications", true)) {
                    Teleports.this.commander.PlayerUpdateToken(Teleports.this.context.getPushService().getToken());
                }
            }
        });
        this.commander = Commander.getInstance();
        this.windowManager = WindowManager.getInstance();
        this.settings = LocalSettings.getInstance();
        this.model.addListeners((MessageListener)this, Cmd.ZoneData.getCode(), Cmd.BattleData.getCode(), Cmd.SessionClosed.getCode(), Cmd.LoginResp.getCode(), Cmd.PunishmentData.getCode(), Cmd.PaymentReward.getCode(), Cmd.Error.getCode());
    }

    @Override
    public void update(Observable o, final Object arg) {
        Gdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                if (arg instanceof Connection.ConnectionLostEvent && !Teleports.this.reconnect) {
                    Teleports.this.reconnect = true;
                    if (Teleports.this.pingTask != null) {
                        Teleports.this.pingTask.cancel();
                    }
                    Teleports.this.connection.connect("game.tpwar.ru", 8888);
                    Teleports.this.windowManager.open(new WarningWindow(WarningWindow.Type.ERROR, "Error", "Connection lost, reconnecting...", "Ok"), true);
                } else if (arg instanceof Connection.ConnectionEvent && Teleports.this.reconnect) {
                    Gdx.app.log(this.getClass().getSimpleName(), "Login after reconnect");
                    AccountManager.login(Teleports.this.context.getCredentials());
                } else if (arg instanceof Connection.NotConnectedEvent && Teleports.this.reconnect) {
                    Timer.schedule(new Timer.Task(){

                        @Override
                        public void run() {
                            Teleports.this.connection.connect("game.tpwar.ru", 8888);
                        }
                    }, 2.0f);
                }
            }
        });
    }

    @Override
    public void handleMessage(int code, Object data, Transport.Packet msg) throws InvalidProtocolBufferException {
        Cmd cmd = Cmd.Enums.byInt(code);
        switch (cmd) {
            case ZoneData: {
                if (this.screen instanceof MapScreen) break;
                this.setScreen(new MapScreen(this));
                break;
            }
            case BattleData: {
                this.setScreen(new BattleScreen(this));
                break;
            }
            case SessionClosed: {
                if (this.screen instanceof MainMenuScreen) break;
                this.setScreen(new MainMenuScreen(this));
                break;
            }
            case PunishmentData: {
                this.showPunishment(Punishment.PunishmentDto.parseFrom(msg.getData()));
                break;
            }
            case PaymentReward: {
                this.eventPaymentReward(Payment.PaymentDto.parseFrom(msg.getData()));
                break;
            }
            case LoginResp: {
                this.reconnect = false;
                this.pingTask = Timer.schedule(new Timer.Task(){

                    @Override
                    public void run() {
                        Gdx.app.log(this.getClass().getSimpleName(), "PING");
                        Teleports.this.commander.Ping();
                    }
                }, 300.0f, 300.0f);
                if (this.model.player.selectedAvatar == null) break;
                Gdx.app.log(this.getClass().getSimpleName(), "Select avatar");
                this.model.player.selectedAvatar.needOpenChat = true;
                this.needResetSession = true;
                this.commander.SelectAvatar(this.model.player.selectedAvatar.id);
                break;
            }
            case Error: {
                Base.ErrorMsg errorMsg = Base.ErrorMsg.parseFrom(msg.getData());
                if (errorMsg.getCode() != 123 || this.model.player.selectedAvatar == null || !this.needResetSession) break;
                Gdx.app.log(this.getClass().getSimpleName(), "Reset session");
                this.commander.ResetAvatarSession(this.model.player.selectedAvatar.id);
                this.commander.SelectAvatar(this.model.player.selectedAvatar.id);
                this.needResetSession = false;
                break;
            }
        }
    }

    public void checkTransactions() {
        ObjectMap<String, PlayerTransaction> transactions = this.settings.transactions();
        if (transactions == null) {
            return;
        }
        for (PlayerTransaction pt : transactions.values()) {
            if (pt.processed.booleanValue()) continue;
            this.commander.sendTransaction(pt.transaction);
        }
    }

    private void eventPaymentReward(Payment.PaymentDto paymentDto) {
        this.settings.transactionProcessed(paymentDto);
        this.windowManager.open(new BankRewardWindow(paymentDto), true);
    }

    private void showPunishment(Punishment.PunishmentDto punishmentDto) {
        boolean isBan = punishmentDto.getCode() == 1;
        this.windowManager.closeAll();
        if (isBan) {
            this.windowManager.open(PunishmentManager.createWindow(punishmentDto));
        } else {
            this.model.player.punishment = punishmentDto;
        }
    }

    @Override
    public void render() {
        super.render();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.windowManager.clearListeners();
        this.model.removeListeners(this);
        this.connection.deleteObservers();
        this.connection.close();
        this.batch.dispose();
        Assets.getInstance().clear();
    }

    @Override
    public void resize(int width, int height) {
        ScaleScreen.update(width, height);
        super.resize(width, height);
        this.windowManager.resize(width, height);
    }
}

