/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.domain;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.I18NBundle;
import com.badlogic.gdx.utils.TimeUtils;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.domain.avatar.ZoneData;
import com.tpwar.domain.battle.BattleData;
import com.tpwar.domain.player.PlayerData;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.messages.MessageDispatcher;
import com.tpwar.net.Cmd;
import com.tpwar.net.ErrorMessage;
import java.util.Calendar;
import java.util.Observable;
import java.util.Observer;
import packet.Artefact;
import packet.Avatars;
import packet.Base;
import packet.Battle;
import packet.Building;
import packet.Chat;
import packet.Clan;
import packet.Fraction;
import packet.Gifts;
import packet.Guild;
import packet.Items;
import packet.Message;
import packet.Player;
import packet.Quest;
import packet.Shield;
import packet.Static;
import packet.TimeWarp;
import packet.Transport;
import packet.Treasure;
import packet.Tutorial;
import packet.Unit;
import packet.Zone;

public class Model
extends MessageDispatcher
implements Observer {
    private final String TAG = Model.class.getSimpleName();
    private static final Model INSTANCE = new Model();
    private final WindowManager windowManager = WindowManager.getInstance();
    public final PlayerData player = new PlayerData();
    public final ZoneData zone = new ZoneData();
    public final BattleData battle = new BattleData();
    public Static.StaticContent content;
    public I18NBundle lang;
    private long serverTime = 0L;
    private long lastTimeUpdate = 0L;

    public Model() {
        if (INSTANCE != null) {
            throw new Error("");
        }
    }

    @Override
    public void update(Observable o, final Object arg) {
        if (!(arg instanceof Transport.Packet)) {
            return;
        }
        Gdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                Model.this.handleCommand((Transport.Packet)arg);
            }
        });
    }

    private void handleCommand(Transport.Packet msg) {
        this.lastTimeUpdate = TimeUtils.millis();
        this.serverTime = msg.getTime();
        Cmd cmd = Cmd.Enums.byInt(msg.getCmd());
        try {
            switch (cmd) {
                case LoginResp: 
                case PlayerUpdate: 
                case AvatarSlotPurchased: 
                case SignupResp: {
                    this.player.onLogin(Player.PlayerDto.parseFrom(msg.getData()));
                    break;
                }
                case AvatarList: {
                    this.player.onAvatarList(Avatars.AvatarList.parseFrom(msg.getData()));
                    break;
                }
                case AvatarDto: {
                    this.player.onCreateAvatar(Avatars.AvatarSlotDto.parseFrom(msg.getData()));
                    break;
                }
                case StaticContent: {
                    this.content = Static.StaticContent.parseFrom(msg.getData());
                    break;
                }
                case AvatarSelected: {
                    this.player.onAvatarSelected(Avatars.AvatarDto.parseFrom(msg.getData()));
                    break;
                }
                case AvatarUpdate: {
                    this.player.onAvatarUpdate(Avatars.AvatarDto.parseFrom(msg.getData()));
                    break;
                }
                case UnitTechUpdate: {
                    this.player.onTechUpdate(Unit.UnitTechList.parseFrom(msg.getData()));
                    break;
                }
                case UnitTechPurchased: {
                    this.player.onTechPurchased(Unit.UnitTechDto.parseFrom(msg.getData()));
                    break;
                }
                case AvatarTaskList: {
                    this.player.onAvatarTaskList(Guild.AvatarTaskList.parseFrom(msg.getData()));
                    break;
                }
                case UnitUpgradeList: {
                    this.player.onUnitUpgradeList(Unit.UnitUpgradeList.parseFrom(msg.getData()));
                    break;
                }
                case UpdateUnits: {
                    this.player.onUnitsUpdate(Unit.UnitList.parseFrom(msg.getData()));
                    break;
                }
                case TreasureInfo: {
                    this.player.onTreasure(Treasure.TreasureDto.parseFrom(msg.getData()));
                    break;
                }
                case AvatarLevelUp: {
                    this.player.onLevelUp(Avatars.LevelUp.parseFrom(msg.getData()));
                    break;
                }
                case ArtefactUpdate: {
                    this.player.onArtefactsUpdate(Artefact.ArtefactList.parseFrom(msg.getData()));
                    break;
                }
                case ArtefactPurchased: {
                    this.player.onArtefactPurchased(Artefact.ArtefactDto.parseFrom(msg.getData()));
                    break;
                }
                case TreasureStatus: {
                    this.player.onTreasureStatus(Treasure.TreasureStatusDto.parseFrom(msg.getData()));
                    break;
                }
                case TreasureReward: {
                    this.player.onTreasureReward();
                    break;
                }
                case GiftList: {
                    this.player.onGiftList(Gifts.GiftList.parseFrom(msg.getData()));
                    break;
                }
                case ListActivatedGifts: {
                    this.player.onListActivatedGifts(Gifts.GiftList.parseFrom(msg.getData()));
                    break;
                }
                case WorldStatus: {
                    this.player.onWorldStatus(Fraction.WorldStatus.parseFrom(msg.getData()));
                    break;
                }
                case OccupationStatus: {
                    this.player.onOccupationStatus(Fraction.OccupationStatusDto.parseFrom(msg.getData()));
                    break;
                }
                case AvatarTutorialData: {
                    this.player.onAvatarTutorial(Tutorial.AvatarTutorials.parseFrom(msg.getData()));
                    break;
                }
                case FractionReward: {
                    this.player.onFractionReward(Fraction.FractionRewardDto.parseFrom(msg.getData()));
                    break;
                }
                case SessionClosed: {
                    this.player.onSessionClosed();
                    break;
                }
                case TimeWarpList: {
                    this.player.onTimeWarpList(TimeWarp.TimeWarpList.parseFrom(msg.getData()));
                    break;
                }
                case AvatarMessage: {
                    this.player.onMessage(Message.MessageDto.parseFrom(msg.getData()));
                    break;
                }
                case MessageList: {
                    this.player.onMessageList(Message.MessageList.parseFrom(msg.getData()));
                    break;
                }
                case QuestUpdate: {
                    this.player.onQuestUpdate(Quest.QuestList.parseFrom(msg.getData()));
                    break;
                }
                case BattleChronicles: {
                    this.player.onBattleChronicles(Battle.BattleChronicles.parseFrom(msg.getData()));
                    break;
                }
                case Shield: 
                case ShieldPurchased: {
                    this.player.onShieldData(Shield.ShieldDto.parseFrom(msg.getData()));
                    break;
                }
                case ItemPurchased: {
                    this.player.onItem(Items.ItemDto.parseFrom(msg.getData()));
                    break;
                }
                case ItemList: {
                    this.player.onItem(Items.ItemList.parseFrom(msg.getData()));
                    break;
                }
                case ChatJoined: {
                    this.player.onJoinedChat(Chat.ChatJoined.parseFrom(msg.getData()));
                    break;
                }
                case ChatMessage: {
                    this.player.onChatMessage(Chat.ChatMessageDto.parseFrom(msg.getData()));
                    break;
                }
                case ChatLeft: {
                    this.player.onLeftChat();
                    break;
                }
                case ClanEventInvite: {
                    this.player.onClanInvitation(Clan.ClanInvitationDto.parseFrom(msg.getData()));
                    break;
                }
                case ClanEventApplication: {
                    this.player.onClanApplication(Clan.ClanApplicationDto.parseFrom(msg.getData()));
                    break;
                }
                case ZoneData: {
                    this.zone.joinZone(this.player.selectedAvatar, Zone.ZoneDto.parseFrom(msg.getData()));
                    break;
                }
                case ZoneEventBattle: {
                    this.zone.zoneEventBattle(Zone.BattleMarkDto.parseFrom(msg.getData()));
                    break;
                }
                case ZoneEventBattleRemove: {
                    this.zone.zoneRemoveBattle(Zone.ZoneEventBattleRemove.parseFrom(msg.getData()));
                    break;
                }
                case BuildingUpdate: {
                    this.zone.buildingUpdate(Building.BuildingDto.parseFrom(msg.getData()));
                    break;
                }
                case BuildingStatus: {
                    this.player.onBuildingStatus(Building.BuildingStatus.parseFrom(msg.getData()));
                    break;
                }
                case BuildingInfoUpdate: {
                    this.player.onBuildingInfo(Building.BuildingInfoList.parseFrom(msg.getData()));
                    break;
                }
                case PlanetStatus: {
                    this.player.onFractionPlanetStatus(Fraction.PlanetStatus.parseFrom(msg.getData()));
                    break;
                }
                case BattleData: {
                    this.battle.onBattle(Battle.BattleDto.parseFrom(msg.getData()));
                    break;
                }
                case BattleEventReady: {
                    this.battle.battleReady(Battle.BattleEventReady.parseFrom(msg.getData()));
                    break;
                }
                case BattleEventRound: {
                    this.battle.battleRound(Battle.BattleRoundDto.parseFrom(msg.getData()));
                    break;
                }
                case BattleEventResult: {
                    this.battle.battleEnd(Battle.BattleResultDto.parseFrom(msg.getData()));
                    break;
                }
                case Error: {
                    this.handleError(Base.ErrorMsg.parseFrom(msg.getData()));
                    break;
                }
            }
            this.dispatchMessage(cmd.getCode(), this, msg);
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
    }

    private void handleError(Base.ErrorMsg parseFrom) {
        if (!ErrorMessage.NON_DISPLAYED.contains(parseFrom.getCode()) && Assets.getInstance().getDefaultSkin() != null) {
            WarningWindow wnd = new WarningWindow(WarningWindow.Type.ERROR, "\u041e\u0448\u0438\u0431\u043a\u0430", parseFrom.getDescription(), "\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
            this.windowManager.open(wnd, true);
        }
        Gdx.app.error(this.TAG, parseFrom.getDescription());
    }

    public long getServerTime() {
        long elapsedTime = TimeUtils.timeSinceMillis(this.lastTimeUpdate);
        return this.serverTime + elapsedTime;
    }

    public boolean isItAprilFoolsDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.getServerTime());
        return calendar.get(2) == 3 && calendar.get(5) == 1;
    }

    public static Model getInstance() {
        return INSTANCE;
    }
}

