/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.domain.avatar;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Sort;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.ArtefactData;
import com.tpwar.domain.avatar.AvatarItem;
import com.tpwar.domain.avatar.AvatarQuest;
import com.tpwar.domain.avatar.AvatarQuestGoal;
import com.tpwar.domain.avatar.AvatarTutorialData;
import com.tpwar.domain.avatar.BuildingInfoData;
import com.tpwar.domain.avatar.BuildingStatusData;
import com.tpwar.domain.avatar.ChatData;
import com.tpwar.domain.avatar.FractionStatusData;
import com.tpwar.domain.avatar.HomePlanetStatusData;
import com.tpwar.domain.avatar.MessageData;
import com.tpwar.domain.avatar.ShieldData;
import com.tpwar.domain.avatar.TimeWarpData;
import com.tpwar.domain.avatar.TreasureData;
import com.tpwar.domain.avatar.TreasureStatusData;
import com.tpwar.domain.avatar.UnitData;
import com.tpwar.domain.avatar.UnitTechData;
import com.tpwar.domain.avatar.UnitUpgradeData;
import com.tpwar.domain.avatar.WorldStatusData;
import com.tpwar.storage.Storage;
import com.tpwar.storage.guild.TaskTypeData;
import com.tpwar.storage.planet.PlanetData;
import com.tpwar.storage.planet.PlanetStorage;
import com.tpwar.storage.unit.UnitTypeData;
import io.netty.util.internal.StringUtil;
import java.util.Calendar;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import packet.Avatars;
import packet.Battle;
import packet.Clan;
import packet.Fraction;
import packet.Guild;
import packet.Static;

public class AvatarData
implements Comparable<AvatarData> {
    private final Storage storage = Storage.getInstance();
    private final Model model = Model.getInstance();
    public static final int FLAG_ADMIN = 1;
    public static final int FLAG_CLAN_MASTER = 2;
    public static final int MAX_MESSAGES = 100;
    public static final int MAX_CHRONICLES = 10;
    public static final int MAX_NUM_UPGRADE = 5;
    public static final int NUM_UNITS_SLOTS = 3;
    public static final int AVAIL_NUM_ARTEFACT_SLOTS = 4;
    public static final String ARENA_ILLUSION_NAME = "Dark Illusion";
    public long id;
    public long playerId;
    public long created;
    public String name;
    public long experience;
    public int energy;
    public long clanId;
    public String clanTag;
    public long fractionId;
    public long planetId;
    public long zoneId;
    public long guildId;
    public long guildRankId;
    public int level;
    public int maxLevel;
    public int position;
    public int wins;
    public int defeats;
    public int draws;
    public int escape;
    public int winsStreak;
    public int treasureWinStreak;
    public int flags;
    public long treasureId;
    public int numUnits;
    public int availNumArtefact;
    public int upgradePoints;
    public long lastInvasionTime;
    public boolean pointReset;
    public long timeWarpTypeId;
    public long shield;
    public boolean needOpenChat;
    public ChatData chat;
    public boolean needShowFirstShield = true;
    public boolean needShowGuildTask = false;
    public int numBattlesInvasion;
    public BuildingStatusData buildingStatus = new BuildingStatusData();
    public WorldStatusData worldStatus = new WorldStatusData();
    public TreasureData treasureData;
    public TreasureStatusData treasureStatus;
    public Avatars.DailyBonusData dailyBonus;
    public Avatars.LevelUp levelUpReward;
    public FractionStatusData fractionStatus = new FractionStatusData();
    public Array<ArtefactData> artefacts = new Array(4);
    public Array<UnitData> units = new Array(3);
    public Array<TimeWarpData> timeWarp = new Array(1);
    public Array<UnitTechData> unitTechs = new Array(3);
    public Array<UnitUpgradeData> upgrades = new Array();
    public Array<BuildingInfoData> buildingInfos = new Array(2);
    public Array<HomePlanetStatusData> planetStatuses = new Array(2);
    public Array<AvatarTutorialData> tutorials = new Array(2);
    public Array<Fraction.FractionRewardDto> fractionRewards = new Array(2);
    public Array<Guild.AvatarTaskDto> tasks = new Array(8);
    public Array<AvatarQuest> quests = new Array(6);
    public Array<MessageData> messages = new Array();
    public Array<Battle.BattleChronicleDto> chronicles = new Array();
    public Array<Clan.ClanInvitationDto> invitationsClan = new Array(6);
    public Array<Clan.ClanApplicationDto> applicationsClan = new Array(6);
    public ObjectMap<Long, AvatarItem> items = new ObjectMap();
    public ShieldData shieldData;
    public int newMessageNum = 0;
    public long lastLogin;
    public long gateBlockTime;
    public long shownGateBlockTime;
    public String skin = "std";

    public void checkNewMessages() {
        for (MessageData msg : this.messages) {
            if (msg.timestamp <= this.lastLogin) continue;
            ++this.newMessageNum;
        }
    }

    public boolean isAdmin() {
        return (this.flags & 1) != 0;
    }

    public boolean isClanMaster() {
        return (this.flags & 2) != 0;
    }

    public boolean hasChat() {
        return this.chat != null;
    }

    public boolean hasShield() {
        return this.shieldData != null;
    }

    public boolean shieldIsActive() {
        if (this.shieldData != null) {
            Static.StaticShieldType shieldType = this.storage.shieldType.get(this.shieldData.typeId);
            return this.shieldData.isActive(this.model.getServerTime(), TimeUnit.HOURS.toMillis(shieldType.getTimeAction()));
        }
        return false;
    }

    public boolean treasureDig() {
        return this.treasureStatus != null && this.treasureStatus.status == 1;
    }

    public boolean inTutorial() {
        for (AvatarTutorialData atd : this.tutorials) {
            if (atd.completed) continue;
            return true;
        }
        return false;
    }

    public boolean hasNewUnits() {
        for (UnitData u : this.units) {
            if (!u.isNew) continue;
            u.isNew = false;
            return true;
        }
        return false;
    }

    public int getNumUnits() {
        int result = 0;
        for (UnitData u : this.units) {
            if (!u.isCreated) continue;
            ++result;
        }
        return result;
    }

    public String getFullName() {
        String result = this.name + " [" + this.level + "]";
        if (!StringUtil.isNullOrEmpty(this.clanTag)) {
            result = this.clanTag + "." + result;
        }
        return result;
    }

    public String getFullNameWithoutLevel() {
        Object result = this.name;
        if (!StringUtil.isNullOrEmpty(this.clanTag)) {
            result = this.clanTag + "." + (String)result;
        }
        return result;
    }

    public int getNumAliveUnits() {
        int result = 0;
        for (UnitData u : this.units) {
            if (u.health <= 0 && !u.isCreated || !u.isAlive) continue;
            ++result;
        }
        return result;
    }

    public int getNumCreatedWithHealthUnits() {
        int result = 0;
        for (UnitData u : this.units) {
            if (u.health <= 0 && !u.isCreated) continue;
            ++result;
        }
        return result;
    }

    public int getNumCreatedUnits() {
        int result = 0;
        for (UnitData u : this.units) {
            if (!u.isCreated) continue;
            ++result;
        }
        return result;
    }

    public UnitData getUnitById(long unitId) {
        for (UnitData unit : this.units) {
            if (unit.id != unitId) continue;
            return unit;
        }
        return null;
    }

    @Override
    public int compareTo(AvatarData avatarData) {
        if (this.id < avatarData.id) {
            return -1;
        }
        if (this.id > avatarData.id) {
            return 1;
        }
        return 0;
    }

    public AvatarQuest getQuestByTypeId(long questTypeId) {
        for (AvatarQuest q : this.quests) {
            if (q.questTypeId != questTypeId) continue;
            return q;
        }
        return null;
    }

    public AvatarQuest getQuest(long questId) {
        for (AvatarQuest q : this.quests) {
            if (q.id != questId) continue;
            return q;
        }
        return null;
    }

    public boolean hasQuestActiveGoal(String goalType) {
        for (AvatarQuest quest : this.quests) {
            if (!quest.isActive() || quest.completed) continue;
            for (AvatarQuestGoal goal : quest.goals) {
                if (!goal.getQuestGoalType().getCode().equals(goalType) || !goal.notCompleted()) continue;
                return true;
            }
        }
        return false;
    }

    public void decrementArtefacts(long artefactTypeId) {
        ArtefactData artefact = this.getArtefactByType(artefactTypeId);
        --artefact.count;
    }

    public ArtefactData getArtefactByType(long artefactTypeId) {
        for (ArtefactData artefact : this.artefacts) {
            if (artefact.artefactTypeId != artefactTypeId) continue;
            return artefact;
        }
        return null;
    }

    public TimeWarpData getActiveTimeWarp() {
        TimeWarpData activeTimeWarp = null;
        for (TimeWarpData atw : this.timeWarp) {
            Static.StaticTimeWarpType type = this.storage.timeWarp.get(atw.typeId);
            long activateTime = atw.activationTime;
            long timeAction = TimeUnit.HOURS.toMillis(type.getTimeAction());
            long currentTime = this.model.getServerTime();
            if (currentTime >= activateTime + timeAction) continue;
            if (activeTimeWarp != null) {
                if (activeTimeWarp.activationTime >= atw.activationTime) continue;
                activeTimeWarp = atw;
                continue;
            }
            activeTimeWarp = atw;
        }
        return activeTimeWarp;
    }

    public boolean isGateActive() {
        return this.gateBlockTime < this.model.getServerTime() - TimeUnit.HOURS.toMillis(1L);
    }

    public void checkTimeUnits() {
        Sort.instance().sort(this.units, new Comparator<UnitData>(){

            @Override
            public int compare(UnitData unitData, UnitData t1) {
                if (unitData.createTime < t1.createTime) {
                    return -1;
                }
                if (unitData.createTime > t1.createTime) {
                    return 1;
                }
                return 0;
            }
        });
        long serverTime = this.model.getServerTime();
        long lastTime = 0L;
        TimeWarpData timeWarp = this.getActiveTimeWarp();
        for (int i = 0; i < this.units.size; ++i) {
            UnitData unit = this.units.get(i);
            UnitTypeData type = this.storage.unitType.get(unit.unitTypeId);
            long timeout = 0L;
            if (timeWarp != null) {
                Static.StaticTimeWarpType timeWarpType = this.storage.timeWarp.get(timeWarp.typeId);
                timeout = type.getTimeoutWithScale(timeWarpType.getSacle()).intValue();
            } else {
                timeout = type.getTimeoutWithScale(0).intValue();
            }
            if (unit.isCreated) {
                lastTime = unit.startTime + timeout * 1000L;
                continue;
            }
            long startTime = Math.max(lastTime, unit.startTime);
            long timeEnd = startTime + timeout * 1000L;
            if (serverTime < timeEnd) continue;
            unit.isCreated = true;
            lastTime = unit.startTime + timeout * 1000L;
        }
    }

    public boolean canUseGate() {
        long timePassed;
        if (this.level < 7) {
            return false;
        }
        boolean result = false;
        Static.StaticFaction fraction = this.storage.faction.get(this.fractionId);
        for (HomePlanetStatusData hpsd : this.planetStatuses) {
            if (hpsd.planetId == fraction.getHomePlanetId()) continue;
            result = hpsd.gateOpen;
            break;
        }
        if (!result) {
            return false;
        }
        long timeout = this.getInvasionTimeout();
        return timeout <= (timePassed = this.model.getServerTime() - this.lastInvasionTime);
    }

    public long getInvasionTimeout() {
        TaskTypeData taskType;
        Static.StaticGuild guild = this.getGuild();
        if (guild != null && (taskType = this.storage.taskType.get(guild.getTaskTypeId())).isDevastation()) {
            Static.StaticGuildRank rank = this.getGuildRank();
            return TimeUnit.HOURS.toMillis(rank.getModifier());
        }
        return TimeUnit.DAYS.toMillis(1L);
    }

    public Static.StaticGuildRank getGuildRank() {
        return this.storage.guildRanks.get(this.guildRankId);
    }

    public Static.StaticGuild getGuild() {
        return this.storage.guild.getGuild(this.guildId);
    }

    public boolean checkBuildingAvail(long buildingId) {
        Calendar currentDate = Calendar.getInstance();
        currentDate.setTimeInMillis(this.model.getServerTime());
        int date = currentDate.get(6);
        int year = currentDate.get(1);
        for (BuildingInfoData bif : this.buildingInfos) {
            if (bif.buildingId != buildingId) continue;
            Calendar lastUsedDate = Calendar.getInstance();
            lastUsedDate.setTimeInMillis(bif.lastUsedTime);
            return lastUsedDate.get(6) != date || lastUsedDate.get(1) != year;
        }
        return true;
    }

    public boolean hasUnitTech(long techTypeId) {
        for (UnitTechData techData : this.unitTechs) {
            if (techData.unitTechTypeId != techTypeId) continue;
            return true;
        }
        return false;
    }

    public UnitTechData getTechByTypeId(long techTypeId) {
        for (UnitTechData techData : this.unitTechs) {
            if (techData.unitTechTypeId != techTypeId) continue;
            return techData;
        }
        return null;
    }

    public boolean hasUnitTechByParamType(long paramType) {
        for (UnitTechData techData : this.unitTechs) {
            if ((long)techData.getType().getParamType() != paramType) continue;
            return true;
        }
        return false;
    }

    public float getProgressLevel() {
        long needExp;
        Static.StaticLevel level = this.storage.level.getLevelByExp(this.experience);
        Static.StaticLevel nextLevel = this.storage.level.getLevel(level.getLevel() + 1);
        long l = needExp = nextLevel != null ? nextLevel.getExp() - level.getExp() : 0L;
        if (needExp == 0L) {
            return 0.0f;
        }
        long temp = this.experience - level.getExp();
        return (float)temp * 100.0f / (float)needExp;
    }

    public UnitUpgradeData getUpgradeByUnitType(long unitTypeId) {
        for (UnitUpgradeData upgrade : this.upgrades) {
            if (upgrade.unitTypeId != unitTypeId || upgrade.level != this.level) continue;
            return upgrade;
        }
        return null;
    }

    public Guild.AvatarTaskDto getTask(long taskTypeId) {
        for (Guild.AvatarTaskDto task : this.tasks) {
            if (task.getTaskTypeId() != taskTypeId) continue;
            return task;
        }
        return null;
    }

    public int getNumUnitsType(long typeId) {
        int res = 0;
        for (UnitData unit : this.units) {
            if (unit.unitTypeId != typeId) continue;
            ++res;
        }
        return res;
    }

    public boolean dumpingLevel() {
        return this.level < this.maxLevel;
    }

    public boolean canAttack(AvatarData opponent, PlanetData planet) {
        if (this.fractionId == opponent.fractionId) {
            return false;
        }
        PlanetStorage planetStorage = this.storage.planet;
        if (planetStorage.isHomePlanet(planet) && (!this.model.player.selectedAvatar.worldStatus.fractionIsOccupied(planet.factionId) ? this.maxLevel != opponent.maxLevel : planet.factionId != opponent.fractionId && opponent.numBattlesInvasion < this.needWinForGuild(opponent.maxLevel))) {
            return false;
        }
        if (!(planetStorage.isHomePlanet(planet) || planetStorage.isGatePlanet(planet) || opponent.playerId <= 0L || this.maxLevel >= 6 && opponent.maxLevel >= 6)) {
            return Math.abs(this.level - opponent.level) <= 2 && Math.abs(this.maxLevel - opponent.maxLevel) <= 1;
        }
        if (opponent.dumpingLevel()) {
            return Math.abs(this.level - opponent.level) <= 2 && Math.abs(this.maxLevel - opponent.maxLevel) <= 2;
        }
        return Math.abs(this.level - opponent.level) <= 2;
    }

    public int needWinForGuild(int level) {
        int needWins = 3;
        switch (level) {
            case 7: {
                needWins = 1;
                break;
            }
            case 8: {
                needWins = 2;
            }
        }
        return needWins;
    }

    public AvatarTutorialData getCurrentTutorial() {
        for (AvatarTutorialData tutorial : this.tutorials) {
            if (tutorial.completed) continue;
            return tutorial;
        }
        return null;
    }

    public String getImageName() {
        if ("std".equals(this.skin)) {
            return this.fractionId == 1L ? "std_oseon" : "std_wayland";
        }
        return this.skin;
    }

    public boolean hasGuild() {
        return this.guildId != 0L;
    }

    public boolean hasTreasure() {
        return this.treasureData != null;
    }

    public boolean hasTimeWarp() {
        return this.timeWarpTypeId > 0L;
    }

    public boolean firstShieldIsActive() {
        Calendar currentDate = Calendar.getInstance();
        currentDate.setTimeInMillis(this.model.getServerTime());
        Calendar createdDate = Calendar.getInstance();
        createdDate.setTimeInMillis(this.created);
        currentDate.add(5, -10);
        return currentDate.before(createdDate);
    }
}

