/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.domain.avatar;

import com.badlogic.gdx.utils.I18NBundle;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.utils.StringUtils;
import com.tpwar.storage.Storage;
import com.tpwar.storage.planet.PlanetData;
import packet.Static;

public class AvatarQuestGoal {
    public long id;
    public long goalTypeId;
    public long questId;
    public long planetId;
    public int count;
    public long point;
    public String name;
    private Static.StaticQuestGoalType questGoalType;
    private PlanetData planet;

    public Static.StaticQuestGoalType getQuestGoalType() {
        if (this.questGoalType == null) {
            this.questGoalType = Storage.getInstance().questGoalTypes.get(this.goalTypeId);
        }
        return this.questGoalType;
    }

    public PlanetData getPlanet() {
        if (this.planet == null) {
            this.planet = Storage.getInstance().planet.get(this.planetId);
        }
        return this.planet;
    }

    public boolean notCompleted() {
        return this.count < this.getQuestGoalType().getAmount();
    }

    public String description(I18NBundle lang) {
        int amount = this.getQuestGoalType().getAmount();
        switch (this.getQuestGoalType().getCode()) {
            case "kill_avatar": {
                Storage storage = Storage.getInstance();
                AvatarData avatar = Model.getInstance().player.selectedAvatar;
                Static.StaticFaction opposite = storage.faction.getOpposite(avatar.fractionId);
                String markedName = StringUtils.mark(this.name, storage.faction.getColor(opposite.getId()));
                PlanetData planet = this.getPlanet();
                String markedPlanetName = "";
                if (planet != null) {
                    markedPlanetName = this.getPlanet().name;
                    if (planet.hasFraction()) {
                        markedPlanetName = StringUtils.mark(markedPlanetName, storage.faction.getColor(planet.factionId));
                    }
                }
                return lang.format("window.quest.goal.kill_avatar", markedName, markedPlanetName, amount);
            }
            case "mine": {
                return lang.format("window.quest.goal.mine", amount);
            }
            case "defence": {
                return lang.format("window.quest.goal.defence", amount);
            }
            case "invide": {
                return lang.format("window.quest.goal.invade", amount);
            }
            case "treasure": {
                return lang.format("window.quest.goal.treasure", amount);
            }
            case "devastation": {
                return lang.format("window.quest.goal.devastation", amount);
            }
            case "treasure_map": {
                return lang.format("window.quest.goal.treasure_map", amount);
            }
        }
        return "";
    }

    public String pveInfo(I18NBundle lang) {
        PlanetData planet = this.getPlanet();
        Storage storage = Storage.getInstance();
        AvatarData avatar = Model.getInstance().player.selectedAvatar;
        Static.StaticFaction opposite = storage.faction.getOpposite(avatar.fractionId);
        switch (this.getQuestGoalType().getCode()) {
            case "kill_avatar": 
            case "mine": 
            case "treasure": 
            case "devastation": {
                return "";
            }
            case "defence": 
            case "invide": {
                if (planet == null) {
                    return "";
                }
                String markedName = StringUtils.mark(this.name, storage.faction.getColor(opposite.getId()));
                String markedPlanetName = planet.name;
                if (planet.hasFraction()) {
                    markedPlanetName = StringUtils.mark(markedPlanetName, storage.faction.getColor(planet.factionId));
                }
                return lang.format("window.quest.goal.defence.pve", markedName, markedPlanetName);
            }
            case "treasure_map": {
                if (planet == null) {
                    return "";
                }
                String markedPlanetName = planet.name;
                if (planet.hasFraction()) {
                    markedPlanetName = StringUtils.mark(markedPlanetName, storage.faction.getColor(planet.factionId));
                }
                String markedName = StringUtils.mark(this.name, storage.faction.getColor(opposite.getId()));
                return lang.format("window.quest.goal.treasure_map.pve", markedName, markedPlanetName);
            }
        }
        return "";
    }
}

