/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.domain.avatar;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Queue;
import com.tpwar.domain.avatar.EventData;
import com.tpwar.game.utils.ChatFilter;
import com.tpwar.game.utils.TimeUtils;
import com.tpwar.storage.Storage;
import packet.Chat;

public class ChatData {
    public static final int MESSAGE_FLAG_ADMIN = 1;
    private final Storage storage = Storage.getInstance();
    private final ChatFilter filter = new ChatFilter();
    public long typeId;
    public Queue<String> messages = new Queue();
    private String eventMessage = "";
    private long lastEventTime;

    public void addEvent(EventData event) {
        this.eventMessage = "\n[#" + Color.WHITE.toString() + "] " + event.getText();
        this.lastEventTime = System.currentTimeMillis();
    }

    public void addMessage(Chat.ChatMessageDto msg) {
        String color = this.storage.faction.getColor(msg.getFractionId());
        boolean isAdminMessage = (msg.getFlags() & 1L) != 0L;
        String timeStr = TimeUtils.shortTimeString(msg.getTimestamp());
        String message = "\n" + timeStr + " ";
        if (isAdminMessage) {
            message = message + String.format("[#%s][\u043c]", Color.YELLOW.toString());
        }
        message = message + String.format("[%s]%s[%s]:[#%s]%s", color, msg.getName(), msg.getLevel(), Color.WHITE.toString(), this.filter.filter(msg.getMessage()));
        this.add(message);
    }

    private void add(String message) {
        this.messages.addLast(message);
        if (this.messages.size > 30) {
            this.messages.removeFirst();
        }
    }

    public String getText() {
        StringBuilder res = new StringBuilder();
        for (String message : this.messages) {
            res.append(message);
        }
        if (this.lastEventTime + 7000L < System.currentTimeMillis()) {
            this.eventMessage = "";
        }
        return res.toString() + this.eventMessage;
    }
}

