/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.domain.avatar;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.I18NBundle;
import com.tpwar.domain.Model;
import com.tpwar.storage.Storage;
import com.tpwar.storage.planet.PlanetData;
import io.netty.util.internal.StringUtil;
import packet.Static;

public class EventData {
    public static final String MINE_CODE = "mine";
    public static final String GATE_CODE = "gate";
    public static final String TREASURE_CODE = "treasure";
    public static final String PLANET_CODE = "planet";
    public static final String FRACTION_CODE = "fraction";
    public static final String ZONE_CODE = "zone";
    public static final String WELCOME_CODE = "welcome";
    public static final int FRACTION_USURP_STATUS = 1;
    public static final int FRACTION_LIBERATE_STATUS = 2;
    public static final int PLANET_AVAIL_STATUS = 1;
    public static final int PLANET_UNAVAIL_STATUS = 2;
    private final Storage storage = Storage.getInstance();
    private final Model model = Model.getInstance();
    public String code;
    public int status;
    public String name;
    public int level;
    public long fractionId;
    public long value;

    public String getText() {
        StringBuilder text = new StringBuilder(String.format("[#%s]> ", Color.YELLOW.toString()));
        I18NBundle lang = this.model.lang;
        switch (this.code) {
            case "mine": {
                Static.StaticBuilding building = this.storage.building.get(this.value);
                Static.StaticZone zone = this.storage.zone.get(building.getZoneId());
                PlanetData planet = this.storage.planet.get(zone.getPlanetId());
                if (this.hasName()) {
                    text.append(lang.format("event.mine.capture", this.avatarName(), planet.name + "-" + zone.getPosition()));
                    break;
                }
                text.append(lang.format("event.mine.liberated", planet.name + "-" + zone.getPosition()));
                break;
            }
            case "gate": {
                Static.StaticBuilding building = this.storage.building.get(this.value);
                Static.StaticZone zone = this.storage.zone.get(building.getZoneId());
                PlanetData planet = this.storage.planet.get(zone.getPlanetId());
                if (this.hasName()) {
                    text.append(lang.format("event.gate.capture", this.avatarName(), this.location(planet, zone)));
                    break;
                }
                text.append(lang.format("event.gate.liberated", this.location(planet, zone)));
                break;
            }
            case "treasure": {
                Static.StaticZone zone = this.storage.zone.get(this.value);
                PlanetData planet = this.storage.planet.get(zone.getPlanetId());
                text.append(lang.format("event.treasure_map.info", this.avatarName(), planet.name + "-" + zone.getPosition()));
                break;
            }
            case "planet": {
                Static.StaticFaction fraction = this.storage.faction.get(this.value);
                if (this.status == 1) {
                    text.append(lang.format("event.planet.open", fraction.getName()));
                    break;
                }
                text.append(lang.format("event.planet.closed", fraction.getName()));
                break;
            }
            case "fraction": {
                Static.StaticFaction fraction = this.storage.faction.get(this.value);
                if (this.status == 1) {
                    text.append(lang.format("event.fraction.capture", this.avatarName(), this.storage.faction.getOpposite(this.fractionId).getName()));
                    break;
                }
                text.append(lang.format("event.fraction.liberated", fraction.getName()));
                break;
            }
            case "zone": {
                Static.StaticZone zone = this.storage.zone.get(this.value);
                PlanetData planet = this.storage.planet.get(zone.getPlanetId());
                text.append(planet.name + "-" + zone.getPosition());
                break;
            }
            case "welcome": {
                text.append(lang.get("event.welcome"));
            }
        }
        return text.toString();
    }

    private boolean hasName() {
        return !StringUtil.isNullOrEmpty(this.name);
    }

    private String location(PlanetData planet, Static.StaticZone zone) {
        String color = this.storage.faction.getColor(planet.factionId);
        return String.format("[%s]%s-%s[#%s]", color, planet.name, zone.getPosition(), Color.YELLOW.toString());
    }

    private String avatarName() {
        String color = this.storage.faction.getColor(this.fractionId);
        return this.hasName() ? String.format("[%s]%s[%s][#%s]", color, this.name, this.level, Color.YELLOW.toString()) : "";
    }
}

