/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.domain.avatar;

import packet.Message;

public class MessageData
implements Comparable<MessageData> {
    public static final String AVATAR_MASSAGE = "avatar_message";
    public static final String CLAN_MESSAGE = "clan_message";
    public static final String GUILD_INVADE_MESSAGE = "invade_message";
    public static final String GUILD_DEFENCE_MESSAGE = "defence_message";
    public static final String GUILD_DEVASTATION_MESSAGE = "devastation_message";
    public static final String ADMIN_MESSAGE = "admin_message";
    public long timestamp;
    public String sender;
    public String recipient;
    public String code;
    public long fractionId;
    public int level;
    public String text;

    public MessageData() {
    }

    public MessageData(Message.MessageDto md) {
        this.timestamp = md.getTime();
        this.sender = md.getSender();
        this.recipient = md.getRecipient();
        this.code = md.getCode();
        this.fractionId = md.getFractionId();
        this.level = md.getLevel();
        this.text = md.getText();
    }

    public String getFullName() {
        switch (this.code) {
            case "avatar_message": {
                return this.sender + "[" + this.level + "]";
            }
            case "clan_message": {
                return this.sender;
            }
            case "admin_message": {
                return "\u0421\u0435\u0440\u0432\u0438\u0441";
            }
        }
        return this.sender;
    }

    public boolean canAnswer() {
        return AVATAR_MASSAGE.equals(this.code);
    }

    @Override
    public int compareTo(MessageData o) {
        if (o.timestamp > this.timestamp) {
            return -1;
        }
        if (o.timestamp < this.timestamp) {
            return 1;
        }
        return 0;
    }
}

