/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.domain.avatar;

import com.tpwar.domain.Model;
import com.tpwar.storage.Storage;
import com.tpwar.storage.unit.UnitTypeData;

public class UnitData
implements Comparable<UnitData> {
    private static final Model model = Model.getInstance();
    private static final Storage storage = Storage.getInstance();
    public long id;
    public long unitTypeId;
    public long avatarId;
    public long createTime;
    public long startTime;
    public boolean isCreated = false;
    public int slot = 0;
    public boolean isAlive = false;
    public int damage;
    public int armor;
    public int health;
    public int defaultHealth;
    public boolean isNew;
    public int oldHealth;
    private UnitTypeData type;

    @Override
    public int compareTo(UnitData o) {
        if (this.slot < o.slot) {
            return -1;
        }
        if (this.slot > o.slot) {
            return 1;
        }
        return 0;
    }

    public void keepHealth() {
        this.oldHealth = this.health;
    }

    public int getDamageDone() {
        int damage = this.health - this.oldHealth;
        return Math.max(-this.oldHealth, damage);
    }

    public long getLeftTime(long timeout) {
        long serverTime = model.getServerTime();
        return this.startTime + timeout * 1000L - serverTime;
    }

    public UnitTypeData getType() {
        if (this.type == null) {
            this.type = UnitData.storage.unitType.get(this.unitTypeId);
        }
        return this.type;
    }
}

