/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.domain.avatar;

import com.badlogic.gdx.utils.Array;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.avatar.BattleMarkData;
import com.tpwar.domain.avatar.BuildingData;
import com.tpwar.net.DataConverter;
import packet.Avatars;
import packet.Building;
import packet.Zone;

public class ZoneData {
    public long zoneId;
    public Array<BuildingData> buildings = new Array();
    public Array<BattleMarkData> battles = new Array();
    public Array<AvatarData> avatars = new Array();

    public void joinZone(AvatarData selectedAvatar, Zone.ZoneDto msg) {
        this.zoneId = msg.getZoneId();
        this.battles.clear();
        this.buildings.clear();
        this.avatars.clear();
        if (selectedAvatar.zoneId != this.zoneId) {
            selectedAvatar.buildingStatus.reset();
        }
        selectedAvatar.zoneId = this.zoneId;
        for (Avatars.AvatarDto avatarDto : msg.getAvatarsList()) {
            AvatarData avatar = DataConverter.fromAvatarDto(avatarDto);
            if (avatar.id == selectedAvatar.id) continue;
            this.avatars.add(avatar);
        }
        for (Zone.BattleMarkDto bmd : msg.getBattlesList()) {
            this.battles.add(DataConverter.fromBattleMarkDto(bmd));
        }
        for (Building.BuildingDto buildingDto : msg.getBuildingsList()) {
            BuildingData building = new BuildingData();
            building.id = buildingDto.getId();
            building.avatar = buildingDto.hasAvatar() ? DataConverter.fromAvatarDto(buildingDto.getAvatar()) : null;
            this.buildings.add(building);
        }
    }

    public void zoneEventBattle(Zone.BattleMarkDto msg) {
        this.battles.add(DataConverter.fromBattleMarkDto(msg));
    }

    public void buildingUpdate(Building.BuildingDto buildingDto) {
        BuildingData buildingData = this.getBuildingData(buildingDto.getId());
        buildingData.id = buildingDto.getId();
        buildingData.avatar = buildingDto.hasAvatar() ? DataConverter.fromAvatarDto(buildingDto.getAvatar()) : null;
    }

    public BattleMarkData getBattleMarkData(long id) {
        for (BattleMarkData bmd : this.battles) {
            if (bmd.id != id) continue;
            return bmd;
        }
        return null;
    }

    public void zoneRemoveBattle(Zone.ZoneEventBattleRemove msg) {
        for (int i = 0; i < this.battles.size; ++i) {
            BattleMarkData bmd = this.battles.get(i);
            if (bmd.id != msg.getBattleId()) continue;
            this.battles.removeIndex(i);
            return;
        }
    }

    public BuildingData getBuildingData(long buildingId) {
        for (BuildingData b : this.buildings) {
            if (b.id != buildingId) continue;
            return b;
        }
        return null;
    }
}

