/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.domain.battle;

import com.badlogic.gdx.utils.Array;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.avatar.UnitData;
import com.tpwar.net.DataConverter;
import com.tpwar.storage.Storage;
import com.tpwar.storage.avatar.ArtefactType;
import java.util.List;
import packet.Battle;
import packet.Unit;

public class BattleData {
    public static final long TIME_ROUND_SECONDS = 100L;
    public static final int DEFAULT_TYPE = 0;
    public static final int ARENA_TYPE = 1;
    public long id;
    public long startTime;
    public long startRoundTime;
    public long roundTimeout;
    public int round;
    public int position;
    public long planetId;
    public long zoneId;
    public AvatarData avatar1;
    public AvatarData avatar2;
    public boolean battleIsOver = false;
    public long artefactTypeId1;
    public long artefactTypeId2;
    public boolean isReadyAvatar1;
    public boolean isReadyAvatar2;
    public boolean allUnitsLostAvatar1;
    public boolean allUnitsLostAvatar2;
    public int type;
    public List<Battle.UnitAttackDto> unitAttack1;
    public List<Battle.UnitAttackDto> unitAttack2;
    public List<Battle.UseArtefactDto> useArtefacts1;
    public List<Battle.UseArtefactDto> useArtefacts2;
    public Battle.BattleResultDto battleResult;

    public long getTimeEnd() {
        return this.startRoundTime + this.roundTimeout * 1000L;
    }

    public void onBattle(Battle.BattleDto battleDto) {
        this.id = battleDto.getId();
        this.startTime = battleDto.getTimeStart();
        this.startRoundTime = battleDto.getStartRoundTime();
        this.roundTimeout = battleDto.hasTimeout() ? (long)battleDto.getTimeout() : 100L;
        this.round = battleDto.getRound();
        this.position = battleDto.getPosition();
        this.avatar1 = DataConverter.fromAvatarDto(battleDto.getAvatar1());
        this.avatar2 = DataConverter.fromAvatarDto(battleDto.getAvatar2());
        this.addUnits(this.avatar1, battleDto.getUnits1List());
        this.addUnits(this.avatar2, battleDto.getUnits2List());
        this.artefactTypeId1 = battleDto.hasArtefactTypeId1() ? battleDto.getArtefactTypeId1() : 0L;
        this.artefactTypeId2 = battleDto.hasArtefactTypeId2() ? battleDto.getArtefactTypeId2() : 0L;
        this.isReadyAvatar1 = battleDto.getAvatar1Ready();
        this.isReadyAvatar2 = battleDto.getAvatar2Ready();
        this.planetId = battleDto.getPlanetId();
        this.zoneId = battleDto.getZoneId();
        this.type = battleDto.getType();
        this.battleResult = null;
    }

    public boolean canUseAnyArtefact() {
        return this.type == 1 || this.avatar1.playerId != 0L && this.avatar2.playerId != 0L && this.avatar1.level >= 7 && this.avatar2.level >= 7;
    }

    private void addUnits(AvatarData avatar, List<Unit.UnitDto> list) {
        avatar.units.clear();
        for (Unit.UnitDto u : list) {
            avatar.units.add(DataConverter.fromUnitDto(u));
        }
    }

    public boolean isObserver(long avatarId) {
        return avatarId != this.avatar1.id && avatarId != this.avatar2.id;
    }

    public void battleReady(Battle.BattleEventReady ready) {
        if (ready.getAvatarId() == this.avatar1.id) {
            this.isReadyAvatar1 = true;
        } else if (ready.getAvatarId() == this.avatar2.id) {
            this.isReadyAvatar2 = true;
        }
    }

    public void battleRound(Battle.BattleRoundDto roundData) {
        this.startRoundTime = roundData.getTime();
        this.round = roundData.getRound();
        this.unitAttack1 = roundData.getUnitsAttack1List();
        this.unitAttack2 = roundData.getUnitsAttack2List();
        this.useArtefacts1 = roundData.getUseArtefacts1List();
        this.useArtefacts2 = roundData.getUseArtefacts2List();
        this.artefactTypeId1 = roundData.hasArtefactTypeId1() ? roundData.getArtefactTypeId1() : 0L;
        this.artefactTypeId2 = roundData.hasArtefactTypeId2() ? roundData.getArtefactTypeId2() : 0L;
        this.isReadyAvatar1 = false;
        this.isReadyAvatar2 = false;
        this.keepHealth();
        BattleData.useDeadRayArtefact(this.useArtefacts1, this.avatar2);
        BattleData.useDeadRayArtefact(this.useArtefacts2, this.avatar1);
        this.useHealArtefacts(this.useArtefacts1, this.avatar1);
        this.useHealArtefacts(this.useArtefacts2, this.avatar2);
        this.calculateDamage(this.unitAttack1, this.useArtefacts1, this.unitAttack2, this.useArtefacts2, this.avatar1, this.avatar2);
        this.calculateDamage(this.unitAttack2, this.useArtefacts2, this.unitAttack1, this.useArtefacts1, this.avatar2, this.avatar1);
    }

    public AvatarData getAvatar(long id) {
        if (this.avatar1.id == id) {
            return this.avatar1;
        }
        if (this.avatar2.id == id) {
            return this.avatar2;
        }
        return null;
    }

    public AvatarData getOpponent(AvatarData avatar) {
        if (this.avatar1.id == avatar.id) {
            return this.avatar2;
        }
        if (this.avatar2.id == avatar.id) {
            return this.avatar1;
        }
        return null;
    }

    public void battleEnd(Battle.BattleResultDto result) {
        this.battleResult = result;
        AvatarData avatar = Model.getInstance().player.selectedAvatar;
        if (this.battleResult.getLoserId() == avatar.id && avatar.hasTreasure()) {
            avatar.treasureId = 0L;
            avatar.treasureStatus = null;
        }
    }

    private void keepHealth() {
        Array<UnitData> units1 = this.avatar1.units;
        Array<UnitData> units2 = this.avatar2.units;
        for (UnitData unit : units1) {
            unit.keepHealth();
        }
        for (UnitData unit : units2) {
            unit.keepHealth();
        }
    }

    private void useHealArtefacts(List<Battle.UseArtefactDto> useArtefacts, AvatarData avatar) {
        Storage storage = Storage.getInstance();
        for (Battle.UseArtefactDto useArtefact : useArtefacts) {
            UnitData unit = avatar.getUnitById(useArtefact.getUnitId());
            ArtefactType artefactType = storage.artefactType.get(useArtefact.getArtefactTypeId());
            if (!artefactType.code.equals("heal") || unit.health <= 0) continue;
            unit.health = (int)Math.min((float)unit.health + artefactType.value, (float)unit.defaultHealth);
        }
    }

    public static void useDeadRayArtefact(List<Battle.UseArtefactDto> useArtefacts, AvatarData avatar) {
        Storage storage = Storage.getInstance();
        for (Battle.UseArtefactDto useArtefact : useArtefacts) {
            UnitData unit = avatar.getUnitById(useArtefact.getUnitId());
            ArtefactType artefactType = storage.artefactType.get(useArtefact.getArtefactTypeId());
            if (!artefactType.code.equals("dead_ray")) continue;
            unit.health = (int)Math.ceil((float)unit.health - artefactType.value);
            if (unit.health > 0) continue;
            unit.isAlive = false;
        }
    }

    public void calculateDamage(List<Battle.UnitAttackDto> unitAttack1, List<Battle.UseArtefactDto> useArtefacts1, List<Battle.UnitAttackDto> unitAttack2, List<Battle.UseArtefactDto> useArtefacts2, AvatarData avatar1, AvatarData avatar2) {
        Storage storage = Storage.getInstance();
        for (Battle.UnitAttackDto attack : unitAttack1) {
            ArtefactType artefact2;
            UnitData unit1 = avatar1.getUnitById(attack.getUnitId());
            UnitData unit2 = avatar2.getUnitById(attack.getUnitTargetId());
            Battle.UseArtefactDto useArtefact1 = this.findArtefactForUnit(unit1.id, useArtefacts1);
            Battle.UseArtefactDto useArtefact2 = this.findArtefactForUnit(unit2.id, useArtefacts2);
            ArtefactType artefact1 = useArtefact1 != null ? storage.artefactType.get(useArtefact1.getArtefactTypeId()) : null;
            ArtefactType artefactType = artefact2 = useArtefact2 != null ? storage.artefactType.get(useArtefact2.getArtefactTypeId()) : null;
            if (artefact1 == null) {
                useArtefact1 = this.findArtefactForUnit(unit2.id, useArtefacts1);
                artefact1 = useArtefact1 != null ? storage.artefactType.get(useArtefact1.getArtefactTypeId()) : null;
            }
            int armor = this.hasActionUnit(unitAttack2, useArtefacts2, unit2.id) ? 0 : unit2.armor;
            int health = unit2.health;
            if (artefact2 != null) {
                switch (artefact2.code) {
                    case "dynamic_shield": {
                        armor = (int)Math.ceil((float)unit2.armor * artefact2.value);
                        break;
                    }
                    case "dead_ray": 
                    case "double_power": {
                        armor = 0;
                    }
                }
            }
            int damage = unit1.damage - armor;
            if (artefact1 != null) {
                switch (artefact1.code) {
                    case "double_power": {
                        damage = (int)((float)damage * artefact1.value);
                    }
                }
            }
            if (damage < 0) {
                damage = 0;
            }
            unit2.health = health - damage;
            if (unit2.health > 0) continue;
            unit2.isAlive = false;
        }
    }

    public boolean hasActionUnit(List<Battle.UnitAttackDto> attackUnit, List<Battle.UseArtefactDto> useArtefacts, long unitId) {
        for (Battle.UnitAttackDto unitAttack : attackUnit) {
            if (unitAttack.getUnitId() != unitId) continue;
            return true;
        }
        Storage storage = Storage.getInstance();
        for (Battle.UseArtefactDto useArtefact : useArtefacts) {
            ArtefactType artefactType = storage.artefactType.get(useArtefact.getArtefactTypeId());
            if (useArtefact.getUnitId() != unitId || artefactType.code.equals("heal")) continue;
            return true;
        }
        return false;
    }

    private Battle.UseArtefactDto findArtefactForUnit(long unitId, List<Battle.UseArtefactDto> useArtefacts) {
        if (useArtefacts == null) {
            return null;
        }
        for (Battle.UseArtefactDto useArtefact : useArtefacts) {
            if (useArtefact.getUnitId() != unitId) continue;
            return useArtefact;
        }
        return null;
    }

    public boolean hasResult() {
        return this.battleResult != null;
    }

    public boolean hasUnitData() {
        return this.avatar1 != null && this.avatar2 != null;
    }

    public int getNumAliveUnits() {
        Array<UnitData> units = this.avatar1.id == Model.getInstance().player.selectedAvatar.id ? this.avatar1.units : this.avatar2.units;
        return this.getNumAliveUnits(units);
    }

    public int getNumAliveUnits(Array<UnitData> units) {
        int result = 0;
        for (UnitData unit : units) {
            if (unit.health <= 0) continue;
            ++result;
        }
        return result;
    }
}

