/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.domain.player;

import com.badlogic.gdx.utils.Array;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.ArtefactData;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.avatar.AvatarItem;
import com.tpwar.domain.avatar.AvatarQuest;
import com.tpwar.domain.avatar.AvatarTutorialData;
import com.tpwar.domain.avatar.ChatData;
import com.tpwar.domain.avatar.MessageData;
import com.tpwar.domain.avatar.ShieldData;
import com.tpwar.domain.avatar.TimeWarpData;
import com.tpwar.domain.avatar.UnitTechData;
import com.tpwar.domain.battle.BattleData;
import com.tpwar.domain.player.PlayerGiftData;
import com.tpwar.net.DataConverter;
import com.tpwar.storage.Storage;
import com.tpwar.storage.guild.TaskTypeData;
import java.util.Comparator;
import packet.Artefact;
import packet.Avatars;
import packet.Battle;
import packet.Building;
import packet.Chat;
import packet.Clan;
import packet.Fraction;
import packet.Gifts;
import packet.Guild;
import packet.Items;
import packet.Message;
import packet.Player;
import packet.Punishment;
import packet.Quest;
import packet.Shield;
import packet.TimeWarp;
import packet.Treasure;
import packet.Tutorial;
import packet.Unit;

public class PlayerData {
    public long id;
    public int availNumAvatars;
    public int crystals;
    public String password;
    public Array<AvatarData> avatars = new Array(5);
    public Array<PlayerGiftData> gifts = new Array(4);
    public Array<PlayerGiftData> activatedGifts = new Array(4);
    public boolean avatarsReceived = false;
    public AvatarData selectedAvatar;
    public Punishment.PunishmentDto punishment;
    public String email;

    public void onLogin(Player.PlayerDto playerDto) {
        this.availNumAvatars = playerDto.getAvailNumAvatars();
        this.crystals = playerDto.getCrystals();
        this.id = playerDto.getId();
        this.password = playerDto.getPassword();
        this.email = playerDto.hasEmail() ? playerDto.getEmail() : "";
    }

    public void onCreateAvatar(Avatars.AvatarSlotDto avatarDto) {
        AvatarData avatar = new AvatarData();
        avatar.id = avatarDto.getId();
        avatar.name = avatarDto.getName();
        avatar.fractionId = avatarDto.getFractionId();
        avatar.experience = avatarDto.getExperience();
        avatar.level = avatarDto.getLevel();
        this.avatars.add(avatar);
    }

    public void onAvatarList(Avatars.AvatarList list) {
        this.avatars.clear();
        for (Avatars.AvatarSlotDto a : list.getAvatarList()) {
            AvatarData avatar = new AvatarData();
            avatar.id = a.getId();
            avatar.name = a.getName();
            avatar.fractionId = a.getFractionId();
            avatar.experience = a.getExperience();
            avatar.level = a.getLevel();
            this.avatars.add(avatar);
        }
        this.avatarsReceived = true;
    }

    public void onGiftList(Gifts.GiftList giftList) {
        this.gifts.clear();
        for (Gifts.PlayerGiftDto giftDto : giftList.getGiftsList()) {
            this.gifts.add(DataConverter.fromPlayerGiftDto(giftDto));
        }
    }

    public void onAvatarSelected(Avatars.AvatarDto avatarDto) {
        this.selectedAvatar = DataConverter.fromAvatarDto(avatarDto);
        this.selectedAvatar.needOpenChat = true;
        this.selectedAvatar.checkNewMessages();
    }

    public void onAvatarUpdate(Avatars.AvatarDto avatarDto) {
        this.selectedAvatar = DataConverter.fromAvatarDto(this.selectedAvatar, avatarDto);
    }

    public void onUnitsUpdate(Unit.UnitList unitList) {
        this.selectedAvatar.units.clear();
        for (Unit.UnitDto unitDto : unitList.getUnitsList()) {
            this.selectedAvatar.units.add(DataConverter.fromUnitDto(unitDto));
        }
        this.selectedAvatar.checkTimeUnits();
    }

    public void onFractionPlanetStatus(Fraction.PlanetStatus status) {
        this.selectedAvatar.planetStatuses.clear();
        for (Fraction.HomePlanetStatusDto statusDto : status.getPlanetsList()) {
            this.selectedAvatar.planetStatuses.add(DataConverter.fromHomePlanetStatusDto(statusDto));
        }
    }

    public void onTechUpdate(Unit.UnitTechList unitTechList) {
        this.selectedAvatar.unitTechs.clear();
        for (Unit.UnitTechDto unitTechDto : unitTechList.getUnitTechList()) {
            this.selectedAvatar.unitTechs.add(DataConverter.fromUnitTechDto(unitTechDto));
        }
    }

    public void onUnitUpgradeList(Unit.UnitUpgradeList unitUpgradeList) {
        this.selectedAvatar.upgrades.clear();
        for (Unit.UnitUpgradeDto unitUpgradeDto : unitUpgradeList.getUpgradesList()) {
            this.selectedAvatar.upgrades.add(DataConverter.formUpgradeDto(unitUpgradeDto));
        }
    }

    public void onBuildingStatus(Building.BuildingStatus buildingStatus) {
        this.selectedAvatar.buildingStatus = DataConverter.fromBuildingStatus(buildingStatus);
    }

    public void onBuildingInfo(Building.BuildingInfoList msgInfoList) {
        this.selectedAvatar.buildingInfos.clear();
        for (Building.BuildingInfoDto data : msgInfoList.getInfoList()) {
            this.selectedAvatar.buildingInfos.add(DataConverter.fromBuildingInfoDto(data));
        }
    }

    public boolean isAvatarsReceived() {
        return this.avatarsReceived;
    }

    public void onTreasure(Treasure.TreasureDto td) {
        this.selectedAvatar.treasureData = DataConverter.fromTreasureDto(td);
    }

    public void onTreasureStatus(Treasure.TreasureStatusDto tsd) {
        this.selectedAvatar.treasureStatus = DataConverter.fromTreasureStatusDto(tsd);
    }

    public void onTreasureReward() {
        this.selectedAvatar.treasureData = null;
        this.selectedAvatar.treasureId = 0L;
    }

    public void onWorldStatus(Fraction.WorldStatus worldStatus) {
        this.selectedAvatar.worldStatus.fractionStatus = worldStatus.getFractionsList();
    }

    public void onJoinedChat(Chat.ChatJoined chatJoined) {
        ChatData chat = new ChatData();
        chat.typeId = chatJoined.getTypeId();
        for (Chat.ChatMessageDto msgDto : chatJoined.getMessagesList()) {
            chat.addMessage(msgDto);
        }
        this.selectedAvatar.chat = chat;
    }

    public void onLeftChat() {
        this.selectedAvatar.chat = null;
    }

    public void onChatMessage(Chat.ChatMessageDto msgDto) {
        if (!this.selectedAvatar.hasChat()) {
            return;
        }
        this.selectedAvatar.chat.addMessage(msgDto);
    }

    public void onAvatarTutorial(Tutorial.AvatarTutorials tutorials) {
        this.selectedAvatar.tutorials.clear();
        for (Tutorial.AvatarTutorialDto atd : tutorials.getTutorialsList()) {
            AvatarTutorialData tutorialData = new AvatarTutorialData();
            tutorialData.id = atd.getId();
            tutorialData.avatarId = atd.getAvatarId();
            tutorialData.completed = atd.getCompleted();
            tutorialData.tutorialId = atd.getTutorialId();
            tutorialData.tutorialStepId = atd.getTutorialStepId();
            this.selectedAvatar.tutorials.add(tutorialData);
        }
        this.selectedAvatar.tutorials.sort();
    }

    public void onArtefactsUpdate(Artefact.ArtefactList list) {
        this.selectedAvatar.artefacts.clear();
        for (Artefact.ArtefactDto ad : list.getArtefactsList()) {
            this.selectedAvatar.artefacts.add(DataConverter.fromArtefactDto(ad));
        }
    }

    public void onFractionReward(Fraction.FractionRewardDto fractionRewardDto) {
        this.selectedAvatar.fractionRewards.add(fractionRewardDto);
    }

    public void onTimeWarpList(TimeWarp.TimeWarpList list) {
        this.selectedAvatar.timeWarp.clear();
        for (TimeWarp.TimeWarpDto twd : list.getTimeWarpList()) {
            TimeWarpData timeWarpData = new TimeWarpData();
            timeWarpData.id = twd.getId();
            timeWarpData.activationTime = twd.getActivationTime();
            timeWarpData.avatarId = twd.getAvatarId();
            timeWarpData.typeId = twd.getTypeId();
            this.selectedAvatar.timeWarp.add(timeWarpData);
        }
    }

    public void onArtefactPurchased(Artefact.ArtefactDto artefactDto) {
        int availNumArtefacts = this.selectedAvatar.availNumArtefact;
        ArtefactData artefact = DataConverter.fromArtefactDto(artefactDto);
        boolean artefactUpdated = false;
        for (int i = 0; i < this.selectedAvatar.artefacts.size; ++i) {
            if (this.selectedAvatar.artefacts.get((int)i).id != artefact.id) continue;
            this.selectedAvatar.artefacts.removeIndex(i);
            this.selectedAvatar.artefacts.insert(i, artefact);
            artefactUpdated = true;
            break;
        }
        if (!artefactUpdated) {
            if (availNumArtefacts < this.selectedAvatar.artefacts.size) {
                this.selectedAvatar.artefacts.removeIndex(this.selectedAvatar.artefacts.size - 1);
            }
            this.selectedAvatar.artefacts.add(artefact);
        }
    }

    public void onSessionClosed() {
        this.selectedAvatar = null;
        BattleData battle = Model.getInstance().battle;
        if (battle != null && battle.hasUnitData()) {
            battle.avatar1 = null;
            battle.avatar2 = null;
        }
    }

    public void onAvatarTaskList(Guild.AvatarTaskList list) {
        Storage storage = Storage.getInstance();
        TaskTypeData taskType = storage.taskType.getByCode("devastation");
        Guild.AvatarTaskDto prevAvatarTask = this.selectedAvatar.getTask(taskType.data.getId());
        this.selectedAvatar.tasks.clear();
        for (Guild.AvatarTaskDto t : list.getTasksList()) {
            if (prevAvatarTask != null && t.getTaskTypeId() == taskType.data.getId() && t.getScore() > prevAvatarTask.getScore()) {
                this.selectedAvatar.needShowGuildTask = true;
            }
            this.selectedAvatar.tasks.add(t);
        }
    }

    public void onQuestUpdate(Quest.QuestList questList) {
        for (Quest.AvatarQuestDto questDto : questList.getQuestsList()) {
            AvatarQuest quest = this.selectedAvatar.getQuest(questDto.getId());
            if (quest != null) {
                quest.goals.clear();
                for (Quest.AvatarQuestGoalDto qg : questDto.getGoalsList()) {
                    quest.goals.add(DataConverter.fromAvatarQuestGoalDto(qg));
                }
                quest.goalUpdated = true;
                quest.completed = questDto.getCompleted();
                quest.reward = questDto.getReward();
                continue;
            }
            boolean hasQuests = this.selectedAvatar.quests.size > 0;
            this.selectedAvatar.quests.clear();
            AvatarQuest newQuest = DataConverter.fromAvatarQuestDto(questDto);
            this.selectedAvatar.quests.add(newQuest);
            newQuest.goalUpdated = hasQuests;
        }
    }

    public void onMessageList(Message.MessageList messageList) {
        for (Message.MessageDto md : messageList.getMessagesList()) {
            this.selectedAvatar.messages.add(new MessageData(md));
        }
        this.selectedAvatar.checkNewMessages();
    }

    public void onBattleChronicles(Battle.BattleChronicles battleChronicles) {
        this.selectedAvatar.chronicles.clear();
        for (Battle.BattleChronicleDto bcd : battleChronicles.getChroniclesList()) {
            this.selectedAvatar.chronicles.add(bcd);
        }
        this.selectedAvatar.chronicles.sort(new Comparator<Battle.BattleChronicleDto>(){

            @Override
            public int compare(Battle.BattleChronicleDto o1, Battle.BattleChronicleDto o2) {
                if (o1.getStartTime() > o2.getStartTime()) {
                    return 1;
                }
                if (o1.getStartTime() < o2.getStartTime()) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public void onTechPurchased(Unit.UnitTechDto unitTechDto) {
        boolean updated = false;
        for (UnitTechData tech : this.selectedAvatar.unitTechs) {
            if (tech.unitTechTypeId != unitTechDto.getUnitTechTypeId()) continue;
            DataConverter.fromUnitTechDto(unitTechDto, tech);
            updated = true;
            break;
        }
        if (!updated) {
            this.selectedAvatar.unitTechs.add(DataConverter.fromUnitTechDto(unitTechDto));
        }
    }

    public void onMessage(Message.MessageDto md) {
        this.selectedAvatar.messages.add(new MessageData(md));
        ++this.selectedAvatar.newMessageNum;
    }

    public void onLevelUp(Avatars.LevelUp reward) {
        this.selectedAvatar.levelUpReward = reward;
    }

    public void onShieldData(Shield.ShieldDto shieldDto) {
        ShieldData shield = new ShieldData();
        shield.id = shieldDto.getId();
        shield.avatarId = shieldDto.getAvatarId();
        shield.battleId = shieldDto.getBattleId();
        shield.typeId = shieldDto.getTypeId();
        shield.activationTime = shieldDto.getActivationTime();
        this.selectedAvatar.shieldData = shield;
    }

    public void onItem(Items.ItemDto itemDto) {
        AvatarItem item = new AvatarItem();
        item.id = itemDto.getId();
        item.itemTypeId = itemDto.getTypeId();
        item.count = itemDto.getCount();
        item.effectEndTime = itemDto.getEffectEndTime();
        this.selectedAvatar.items.put(item.itemTypeId, item);
    }

    public void onItem(Items.ItemList itemListDto) {
        for (Items.ItemDto itemDto : itemListDto.getItemsList()) {
            this.onItem(itemDto);
        }
    }

    public void onClanInvitation(Clan.ClanInvitationDto inviteDto) {
        this.selectedAvatar.invitationsClan.add(inviteDto);
    }

    public void onClanApplication(Clan.ClanApplicationDto applicationDto) {
        this.selectedAvatar.applicationsClan.add(applicationDto);
    }

    public void onListActivatedGifts(Gifts.GiftList gifts) {
        this.activatedGifts.clear();
        for (Gifts.PlayerGiftDto giftDto : gifts.getGiftsList()) {
            this.activatedGifts.add(DataConverter.fromPlayerGiftDto(giftDto));
        }
    }

    public void onOccupationStatus(Fraction.OccupationStatusDto statusDto) {
        if (this.selectedAvatar.fractionId == statusDto.getFractionId()) {
            return;
        }
        this.selectedAvatar.fractionStatus.fractionId = statusDto.getFractionId();
        this.selectedAvatar.fractionStatus.numInvaders = statusDto.getNumInvaders();
    }
}

