/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.events;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntMap;
import com.tpwar.events.EventListener;

public class EventDispatcher<T> {
    private IntMap<Array<EventListener<T>>> hub = new IntMap();

    public void addListener(int type, EventListener<T> listener) {
        Array<EventListener<EventListener<T>>> listeners = this.hub.get(type);
        if (listeners == null) {
            listeners = new Array(false, 16);
            this.hub.put(type, listeners);
        }
        listeners.add(listener);
    }

    public void removeListener(int type, EventListener<T> listener) {
        Array<EventListener<EventListener<T>>> listeners = this.hub.get(type);
        if (listeners != null) {
            listeners.removeValue(listener, true);
        }
    }

    public void removeListener(EventListener<T> listener) {
        for (Array<EventListener<EventListener<T>>> array : this.hub.values()) {
            if (array == null || !array.contains(listener, true)) continue;
            array.removeValue(listener, true);
        }
    }

    public void clearListeners() {
        this.hub.clear();
    }

    public void clearListeners(int code) {
        this.hub.remove(code);
    }

    public void dispatch(int type, T data) {
        Array<EventListener<T>> listeners = this.hub.get(type);
        if (listeners != null) {
            for (int i = 0; i < listeners.size; ++i) {
                EventListener<T> l = listeners.get(i);
                l.onEvent(type, data);
            }
        }
    }
}

