/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.battle;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Queue;

public class AnimationQueue
extends Actor {
    private final Queue<Animation> queue = new Queue();
    private boolean started = false;
    private Animation currentAnimation;
    private ColmpleteListener colmpleteListener;

    public void add(Animation animation) {
        this.queue.addLast(animation);
    }

    public boolean hasAnumation() {
        return this.queue.size > 0;
    }

    public void start() {
        if (!this.started) {
            this.next();
        }
    }

    private void next() {
        if (this.hasAnumation()) {
            this.currentAnimation = this.queue.removeFirst();
            this.currentAnimation.start();
            this.started = true;
        } else {
            this.started = false;
            this.colmpleteListener.complete();
        }
    }

    @Override
    public void act(float delta) {
        if (this.currentAnimation != null && this.currentAnimation.isComplete()) {
            this.currentAnimation = null;
            this.next();
        }
    }

    public void setColmpleteListener(ColmpleteListener colmpleteListener) {
        this.colmpleteListener = colmpleteListener;
    }

    static interface Animation {
        public void start();

        public boolean isComplete();
    }

    static interface ColmpleteListener {
        public void complete();
    }
}

