/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.battle;

import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import com.tpwar.game.battle.units.Unit;
import com.tpwar.game.maps.entity.AnimatedObject;
import com.tpwar.game.utils.Assets;
import com.tpwar.storage.avatar.ArtefactType;

public class ArtefactAnimation
extends AnimatedObject {
    protected static final Assets assets = Assets.getInstance();
    protected static final TextureAtlas atlas = (TextureAtlas)assets.get("units/battle_elements.atlas");
    public ArtefactType artefact;
    public Unit unit;

    public ArtefactAnimation(Animation<TextureRegion> animation) {
        super(animation);
    }

    public String getSoundName(String code) {
        switch (code) {
            case "dead_ray": {
                return "sound/fx/17. Artifact - Beam_of_Death.mp3";
            }
            case "double_power": {
                return "sound/fx/15. Artifact - Double_Strength.mp3";
            }
            case "dynamic_shield": {
                return "sound/fx/14. Artifact - Dynamic_Shield.mp3";
            }
            case "heal": {
                return "sound/fx/16. Artifact - Healing.mp3";
            }
        }
        return "";
    }

    public static ArtefactAnimation getArtefactAnimation(String code) {
        String animationName = null;
        int offsetX = 0;
        int offsetY = 0;
        switch (code) {
            case "dead_ray": {
                animationName = "dead_ray_artefact";
                offsetX = -48;
                offsetY = -62;
                break;
            }
            case "double_power": {
                animationName = "double_power_artefact";
                offsetX = -56;
                offsetY = -26;
                break;
            }
            case "dynamic_shield": {
                animationName = "dynamic_chield_artefact";
                offsetX = -126;
                offsetY = -70;
                break;
            }
            case "heal": {
                animationName = "health_artefact";
                offsetX = -45;
                offsetY = 60;
            }
        }
        Array<TextureRegion> regions = assets.extractRegions(atlas, animationName);
        Animation<TextureRegion> animation = new Animation<TextureRegion>(0.048f, regions);
        ArtefactAnimation artefactAnimation = new ArtefactAnimation(animation);
        artefactAnimation.setPosition(offsetX, offsetY);
        return artefactAnimation;
    }
}

