/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.battle;

import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.utils.Queue;
import com.tpwar.events.EventDispatcher;
import com.tpwar.game.battle.ArtefactAnimation;
import com.tpwar.sound.SoundSystem;

public class ArtefactAnimationQueue
extends Group {
    private final SoundSystem soundSystem = SoundSystem.getInstance();
    private final Queue<ArtefactAnimation> queue = new Queue();
    private final EventDispatcher<Boolean> dispatcher = new EventDispatcher();
    private ArtefactAnimation current;
    private boolean started = false;

    public boolean hasAnumation() {
        return this.queue.size > 0;
    }

    public void addArtefactAnimation(ArtefactAnimation effect) {
        this.queue.addLast(effect);
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.next();
    }

    private void next() {
        if (!this.hasAnumation()) {
            this.getDispatcher().dispatch(11, true);
            this.started = false;
            return;
        }
        this.current = this.queue.removeFirst();
        this.soundSystem.fx.play(this.current.getSoundName(this.current.artefact.code));
    }

    @Override
    public void act(float delta) {
        if (this.current != null && this.current.isAnimationFinished()) {
            this.current.remove();
            this.current = null;
            this.next();
        }
    }

    public EventDispatcher<Boolean> getDispatcher() {
        return this.dispatcher;
    }
}

