/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.battle;

import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonRenderer;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.ArtefactData;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.avatar.UnitData;
import com.tpwar.events.EventDispatcher;
import com.tpwar.events.EventListener;
import com.tpwar.game.battle.AnimationQueue;
import com.tpwar.game.battle.ArtefactAnimation;
import com.tpwar.game.battle.ArtefactAnimationQueue;
import com.tpwar.game.battle.LineAttack;
import com.tpwar.game.battle.UnitAnimationQueue;
import com.tpwar.game.battle.units.Unit;
import com.tpwar.game.battle.units.UnitArtefactSlot;
import com.tpwar.game.battle.units.UnitFarn;
import com.tpwar.game.battle.units.UnitHamer;
import com.tpwar.game.battle.units.UnitHavy;
import com.tpwar.game.screens.shaker.ScreenShaker;
import com.tpwar.game.utils.Assets;
import com.tpwar.net.Commander;
import com.tpwar.storage.Storage;
import com.tpwar.storage.avatar.ArtefactType;
import com.tpwar.storage.unit.UnitTypeData;
import java.util.List;
import packet.Battle;

public class Battlefield
extends Group
implements InputProcessor,
EventListener<Boolean> {
    private static final String TAG = Battlefield.class.getSimpleName();
    private final Assets assets = Assets.getInstance();
    private final Storage storage = Storage.getInstance();
    private final Commander commander = Commander.getInstance();
    private final Model model = Model.getInstance();
    private final EventDispatcher<Boolean> dispatcher = new EventDispatcher();
    public final ScreenShaker screenShaker;
    private final SkeletonRenderer skeletonRenderer;
    private final Vector3 point = new Vector3();
    private Array<Unit> topUnits = new Array(3);
    private Array<Unit> bottomUnits = new Array(3);
    private Array<Vector2> topUnitPositions = new Array(3);
    private Array<Vector2> bottomUnitPositions = new Array(3);
    private Array<LineAttack> lineAttackList = new Array(2);
    private int currentLineAttackIndex;
    private int numSelected;
    private AvatarData avatar;
    private AvatarData opponent;
    private ArtefactAnimationQueue artefactsAnimationQueue;
    private ArtefactData artefact;
    private UnitAnimationQueue unitAnimationQueue;
    private boolean lockInteractive;
    private boolean artefactMode;
    private Unit unitArtefact;
    private AnimationQueue animationHPQueue;

    public Battlefield(OrthographicCamera camera, Viewport viewport) {
        this.screenShaker = new ScreenShaker(camera);
        this.skeletonRenderer = new SkeletonRenderer();
        this.skeletonRenderer.setPremultipliedAlpha(true);
        int offsetX = 184;
        int offsetY = 90;
        int stepX = 288;
        int stepY = 255;
        for (int i = 0; i < 3; ++i) {
            this.bottomUnitPositions.add(new Vector2(offsetX + stepX * i, offsetY));
            this.topUnitPositions.add(new Vector2(offsetX + stepX * i, offsetY + stepY));
        }
        this.setWidth(stepX * 3);
        this.setHeight(stepY * 2);
        this.artefactsAnimationQueue = new ArtefactAnimationQueue();
        this.artefactsAnimationQueue.getDispatcher().addListener(11, this);
        this.addActor(this.artefactsAnimationQueue);
        this.unitAnimationQueue = new UnitAnimationQueue();
        this.unitAnimationQueue.getDispatcher().addListener(12, this);
        this.addActor(this.unitAnimationQueue);
        this.animationHPQueue = new AnimationQueue();
        this.addActor(this.animationHPQueue);
    }

    public void init(AvatarData avatar, AvatarData opponent) {
        this.avatar = avatar;
        this.opponent = opponent;
        this.createLineAttack();
        this.topUnits = this.createUnits(opponent.units, Unit.UnitState.TOP, this.topUnitPositions, opponent.fractionId == 1L);
        this.bottomUnits = this.createUnits(avatar.units, Unit.UnitState.BOTTOM, this.bottomUnitPositions, avatar.fractionId == 1L);
    }

    public Unit getTopUnitBySlot(int slot) {
        for (Unit unit : this.topUnits) {
            if (unit.unitData.slot != slot) continue;
            return unit;
        }
        return null;
    }

    public Unit getBottomUnitBySlot(int slot) {
        for (Unit unit : this.bottomUnits) {
            if (unit.unitData.slot != slot) continue;
            return unit;
        }
        return null;
    }

    protected void removeArtefact(Unit unit) {
        if (this.artefactMode) {
            this.unitArtefact = unit;
            this.addUnitArtefact(unit, this.artefact);
            this.artefactMode = false;
            this.dispatcher.dispatch(14, true);
            return;
        }
        unit.removeArtefact();
        this.dispatcher.dispatch(14, false);
    }

    public void setArtefact(ArtefactData artefact, boolean active) {
        if (!active) {
            if (this.unitArtefact != null) {
                this.unitArtefact.removeArtefact();
            }
            this.artefact = null;
            this.artefactMode = false;
            this.hideAllArtefactSlots(false);
            return;
        }
        ArtefactType artefactType = this.storage.artefactType.get(artefact.artefactTypeId);
        switch (artefactType.code) {
            case "dynamic_shield": 
            case "double_power": 
            case "heal": {
                this.showArtefactSlots(this.bottomUnits);
                break;
            }
            case "dead_ray": {
                this.showArtefactSlots(this.topUnits);
            }
        }
        this.artefact = artefact;
        this.artefactMode = true;
    }

    private void addUnitArtefact(Unit unit, ArtefactData artefact) {
        unit.setArtefact(artefact);
        this.hideAllArtefactSlots(true);
    }

    private void hideAllArtefactSlots(boolean checkArtefact) {
        for (Unit unit : this.topUnits) {
            if (checkArtefact && unit.getArtefact() != null) continue;
            unit.hideArtefactSlot();
        }
        for (Unit unit : this.bottomUnits) {
            if (checkArtefact && unit.getArtefact() != null) continue;
            unit.hideArtefactSlot();
        }
        this.artefactMode = false;
    }

    private void showArtefactSlots(Array<Unit> units) {
        for (Unit unit : units) {
            if (!unit.unitData.isAlive) continue;
            unit.showArtefactSlot();
        }
    }

    private void createLineAttack() {
        this.currentLineAttackIndex = 0;
        for (int i = 0; i < 2; ++i) {
            LineAttack line = new LineAttack(this.skeletonRenderer);
            line.setVisible(false);
            this.lineAttackList.add(line);
            this.addActor(line);
        }
    }

    private Array<Unit> createUnits(Array<UnitData> data, Unit.UnitState state, Array<Vector2> positions, boolean isOseon) {
        data.sort();
        Array<Unit> units = new Array<Unit>(3);
        for (int i = 0; i < data.size; ++i) {
            UnitData unitData = data.get(i);
            UnitTypeData unitTypeData = this.storage.unitType.get(unitData.unitTypeId);
            if (!unitData.isAlive) continue;
            Unit unit = null;
            switch (unitTypeData.code) {
                case "farn": {
                    String unitSkin = isOseon ? (state.equals((Object)Unit.UnitState.TOP) ? "units/oseon/unit_FAR_ALL_f.json" : "units/oseon/unit_FAR_ALL_b.json") : (state.equals((Object)Unit.UnitState.TOP) ? "units/unit_FAR_ALL_f.json" : "units/unit_FAR_ALL_b.json");
                    SkeletonData skeletonData = (SkeletonData)this.assets.get(unitSkin);
                    unit = new UnitFarn(this.skeletonRenderer, skeletonData);
                    break;
                }
                case "hamer": {
                    String unitSkin = isOseon ? (state.equals((Object)Unit.UnitState.TOP) ? "units/oseon/unit_CLOSE_ALL_f.json" : "units/oseon/unit_CLOSE_ALL_b.json") : (state.equals((Object)Unit.UnitState.TOP) ? "units/unit_CLOSE_ALL_f.json" : "units/unit_CLOSE_ALL_b.json");
                    SkeletonData skeletonData = (SkeletonData)this.assets.get(unitSkin);
                    unit = new UnitHamer(this.skeletonRenderer, skeletonData);
                    break;
                }
                case "havy": {
                    String unitSkin = isOseon ? (state.equals((Object)Unit.UnitState.TOP) ? "units/oseon/unit_HEAVY_ALL_f.json" : "units/oseon/unit_HEAVY_ALL_b.json") : (state.equals((Object)Unit.UnitState.TOP) ? "units/unit_HEAVY_ALL_f.json" : "units/unit_HEAVY_ALL_b.json");
                    SkeletonData skeletonData = (SkeletonData)this.assets.get(unitSkin);
                    unit = new UnitHavy(this.skeletonRenderer, skeletonData);
                }
            }
            unit.setScreenShaker(this.screenShaker);
            unit.unitData = unitData;
            unit.unitState = state;
            unit.updateParameters();
            unit.index = unitData.slot - 1;
            unit.setPosition(positions.get((int)unit.index).x, positions.get((int)unit.index).y);
            unit.stand();
            this.addActor(unit);
            units.add(unit);
        }
        return units;
    }

    public boolean isAnimationFinished() {
        if (this.unitAnimationQueue.hasAnimation()) {
            return false;
        }
        for (Unit unit : this.bottomUnits) {
            if (unit.isAnimationFinished && unit.isDieAnimationFinished) continue;
            return false;
        }
        for (Unit unit : this.topUnits) {
            if (unit.isAnimationFinished && unit.isDieAnimationFinished) continue;
            return false;
        }
        return true;
    }

    private void deactivateUnits() {
        for (Unit unit : this.bottomUnits) {
            unit.deactivate();
        }
        for (Unit unit : this.topUnits) {
            unit.deactivate();
        }
    }

    public void activateUnits() {
        for (Unit unit : this.bottomUnits) {
            if (!unit.unitData.isAlive) continue;
            unit.activate();
        }
        for (Unit unit : this.topUnits) {
            if (!unit.unitData.isAlive) continue;
            unit.activate();
        }
    }

    public void parseAttackUnit(List<Battle.UnitAttackDto> attackUnit1, List<Battle.UnitAttackDto> attackUnit2, List<Battle.UseArtefactDto> useArtefacts1, List<Battle.UseArtefactDto> useArtefacts2) {
        Unit unitTarget;
        Unit unit;
        for (Battle.UnitAttackDto unitAttack : attackUnit1) {
            unit = this.getUnitById(this.bottomUnits, unitAttack.getUnitId());
            unitTarget = this.getUnitById(this.topUnits, unitAttack.getUnitTargetId());
            this.unitAnimationQueue.addUnitAnimation(unit, unitTarget, !this.hasActionUnit(attackUnit2, useArtefacts2, unitTarget.unitData.id));
        }
        for (Battle.UnitAttackDto unitAttack : attackUnit2) {
            unit = this.getUnitById(this.topUnits, unitAttack.getUnitId());
            unitTarget = this.getUnitById(this.bottomUnits, unitAttack.getUnitTargetId());
            this.unitAnimationQueue.addUnitAnimation(unit, unitTarget, !this.hasActionUnit(attackUnit1, useArtefacts1, unitTarget.unitData.id));
        }
        ArtefactType artefact = null;
        ArtefactAnimation effect = null;
        for (Battle.UseArtefactDto useArtefact : useArtefacts1) {
            unit = this.getUnitById(this.bottomUnits, useArtefact.getUnitId());
            if (unit == null) {
                unit = this.getUnitById(this.topUnits, useArtefact.getUnitId());
            }
            artefact = this.storage.artefactType.get(useArtefact.getArtefactTypeId());
            effect = ArtefactAnimation.getArtefactAnimation(artefact.code);
            effect.artefact = artefact;
            effect.unit = unit;
            effect.setX(effect.getX() + unit.getX());
            effect.setY(effect.getY() + unit.getY());
            this.addActor(effect);
            this.artefactsAnimationQueue.addArtefactAnimation(effect);
        }
        for (Battle.UseArtefactDto useArtefact : useArtefacts2) {
            unit = this.getUnitById(this.bottomUnits, useArtefact.getUnitId());
            if (unit == null) {
                unit = this.getUnitById(this.topUnits, useArtefact.getUnitId());
            }
            artefact = this.storage.artefactType.get(useArtefact.getArtefactTypeId());
            effect = ArtefactAnimation.getArtefactAnimation(artefact.code);
            effect.artefact = artefact;
            effect.unit = unit;
            effect.setX(effect.getX() + unit.getX());
            effect.setY(effect.getY() + unit.getY());
            this.addActor(effect);
            this.artefactsAnimationQueue.addArtefactAnimation(effect);
        }
        for (int i = 0; i < 2; ++i) {
            LineAttack line = this.lineAttackList.get(i);
            line.setVisible(false);
            line.clear();
        }
        this.numSelected = 0;
        this.deactivateUnits();
        if (this.artefactsAnimationQueue.hasAnumation()) {
            this.artefactsAnimationQueue.start();
        } else if (this.unitAnimationQueue.hasAnimation()) {
            this.unitAnimationQueue.start();
        }
    }

    public boolean hasActionUnit(List<Battle.UnitAttackDto> attackUnit, List<Battle.UseArtefactDto> useArtefacts, long unitId) {
        for (Battle.UnitAttackDto unitAttack : attackUnit) {
            if (unitAttack.getUnitId() != unitId) continue;
            return true;
        }
        for (Battle.UseArtefactDto useArtefact : useArtefacts) {
            ArtefactType artefactType = this.storage.artefactType.get(useArtefact.getArtefactTypeId());
            if (useArtefact.getUnitId() != unitId || artefactType.code.equals("heal")) continue;
            return true;
        }
        return false;
    }

    private Unit getUnitById(Array<Unit> units, long unitId) {
        for (Unit unit : units) {
            if (unit.unitData.id != unitId) continue;
            return unit;
        }
        return null;
    }

    @Override
    public boolean keyDown(int keycode) {
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        Unit unit;
        Vector2 temp = new Vector2(screenX, screenY);
        this.screenToLocalCoordinates(temp);
        this.point.set(temp.x, temp.y, 0.0f);
        Unit unit2 = this.getUnitByPoint(this.bottomUnits, this.point);
        if (unit2 != null) {
            if (unit2.lineIndex == -1) {
                int lineIndex = -1;
                lineIndex = this.lineAttackList.get(0).hasUnits() && this.lineAttackList.get((int)1).firstUnit == null ? 1 : 0;
                if (this.lineAttackList.get((int)lineIndex).firstUnit != null) {
                    return false;
                }
                this.currentLineAttackIndex = lineIndex;
                if (this.numSelected < this.availableSelectNum()) {
                    this.lineAttackList.get((int)this.currentLineAttackIndex).firstUnit = unit2;
                    unit2.lineIndex = this.currentLineAttackIndex;
                    unit2.select();
                }
            } else {
                LineAttack lastLineAttack = this.lineAttackList.get(this.currentLineAttackIndex);
                if (this.currentLineAttackIndex != unit2.lineIndex && lastLineAttack.firstUnit != null && lastLineAttack.secondUnit == null) {
                    this.clearLineAttack(this.lineAttackList.get(this.currentLineAttackIndex));
                }
                this.currentLineAttackIndex = unit2.lineIndex;
                if (this.numSelected < this.availableSelectNum() && this.lineAttackList.get((int)this.currentLineAttackIndex).firstUnit == null) {
                    return false;
                }
                this.clearLineAttack(this.lineAttackList.get(unit2.lineIndex));
                if (this.numSelected == 0) {
                    this.getDispatcher().dispatch(10, false);
                }
            }
        } else {
            unit2 = this.getUnitByPoint(this.topUnits, this.point);
            if (unit2 != null) {
                LineAttack lineAttack = this.lineAttackList.get(this.currentLineAttackIndex);
                if (this.numSelected < this.availableSelectNum() && lineAttack.firstUnit != null && lineAttack.secondUnit == null) {
                    unit2.select();
                    lineAttack.secondUnit = unit2;
                    lineAttack.setVisible(true);
                    lineAttack.setPosition(lineAttack.firstUnit.getX(), lineAttack.firstUnit.getY() + 130.0f);
                    lineAttack.setDirect(lineAttack.firstUnit.index - unit2.index);
                    ++this.numSelected;
                    this.getDispatcher().dispatch(10, true);
                }
            }
        }
        Actor actor = this.hit(temp.x, temp.y, true);
        if (actor instanceof UnitArtefactSlot && (unit = (Unit)actor.getParent()) != null) {
            this.removeArtefact(unit);
        }
        return false;
    }

    private void runDeathAnimation() {
        for (Unit unit : this.bottomUnits) {
            if (unit.unitData.isAlive || unit.isDead) continue;
            unit.die();
        }
        for (Unit unit : this.topUnits) {
            if (unit.unitData.isAlive || unit.isDead) continue;
            unit.die();
        }
    }

    public void sendAttackRequest() {
        if (this.lockInteractive) {
            return;
        }
        this.lockInteractive = true;
        this.deactivateUnits();
        Battle.BattleActionAttack.Builder battleActionAttack = Battle.BattleActionAttack.newBuilder();
        for (int i = 0; i < 2; ++i) {
            LineAttack line = this.lineAttackList.get(i);
            if (line.firstUnit == null || line.secondUnit == null) continue;
            Battle.UnitAttackDto.Builder unitAttack = Battle.UnitAttackDto.newBuilder();
            unitAttack.setUnitId(line.firstUnit.unitData.id);
            unitAttack.setUnitTargetId(line.secondUnit.unitData.id);
            battleActionAttack.addUnitsAttack(unitAttack);
        }
        if (this.artefact != null) {
            Battle.UseArtefactDto.Builder useArtefact = null;
            for (Unit unit : this.topUnits) {
                if (unit.getArtefact() == null) continue;
                useArtefact = Battle.UseArtefactDto.newBuilder();
                useArtefact.setUnitId(unit.unitData.id);
                useArtefact.setArtefactTypeId(unit.getArtefact().artefactTypeId);
                this.artefact = null;
                unit.removeArtefact();
                break;
            }
            if (this.artefact != null) {
                for (Unit unit : this.bottomUnits) {
                    if (unit.getArtefact() == null) continue;
                    useArtefact = Battle.UseArtefactDto.newBuilder();
                    useArtefact.setUnitId(unit.unitData.id);
                    useArtefact.setArtefactTypeId(unit.getArtefact().artefactTypeId);
                    this.artefact = null;
                    unit.removeArtefact();
                    break;
                }
            }
            if (useArtefact != null) {
                battleActionAttack.addUseArtefacts(useArtefact);
                this.model.player.selectedAvatar.decrementArtefacts(useArtefact.getArtefactTypeId());
                this.dispatcher.dispatch(15, true);
            }
        }
        this.commander.BattleActionAttack(battleActionAttack);
    }

    private void clearLineAttack(LineAttack lineAttack) {
        lineAttack.firstUnit.unselect();
        lineAttack.firstUnit.lineIndex = -1;
        if (lineAttack.secondUnit != null) {
            lineAttack.secondUnit.unselect();
            --this.numSelected;
        }
        lineAttack.clear();
        lineAttack.setVisible(false);
    }

    private int availableSelectNum() {
        int min = Math.min(this.avatar.getNumAliveUnits(), this.opponent.getNumAliveUnits()) - 1;
        if (min == 0) {
            min = 1;
        }
        return min;
    }

    private Unit getUnitByPoint(Array<Unit> units, Vector3 point) {
        for (Unit u : units) {
            if (u.isDead || !u.contains(point.x, point.y)) continue;
            return u;
        }
        return null;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchCancelled(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    @Override
    public boolean scrolled(float v, float v1) {
        return false;
    }

    public EventDispatcher<Boolean> getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void onEvent(int type, Boolean data) {
        switch (type) {
            case 11: {
                this.unitAnimationQueue.start();
                break;
            }
            case 12: {
                this.animationHPQueue.setColmpleteListener(new AnimationQueue.ColmpleteListener(){

                    @Override
                    public void complete() {
                        Battlefield.this.runDeathAnimation();
                        Battlefield.this.activateUnits();
                        Battlefield.this.lockInteractive = false;
                        Battlefield.this.dispatcher.dispatch(13, true);
                    }
                });
                this.animationHPQueue.add(new AnimationQueue.Animation(){

                    @Override
                    public void start() {
                        for (Unit unit : Battlefield.this.topUnits) {
                            if (unit.unitData.getDamageDone() >= 0) continue;
                            unit.showDamage(unit.unitData.getDamageDone());
                        }
                        for (Unit unit : Battlefield.this.bottomUnits) {
                            if (unit.unitData.getDamageDone() >= 0) continue;
                            unit.showDamage(unit.unitData.getDamageDone());
                        }
                    }

                    @Override
                    public boolean isComplete() {
                        return true;
                    }
                });
                this.animationHPQueue.start();
            }
        }
    }
}

