/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.battle;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.esotericsoftware.spine.AnimationState;
import com.esotericsoftware.spine.AnimationStateData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonRenderer;
import com.tpwar.game.battle.SkeletonDisplayObject;
import com.tpwar.game.battle.units.Unit;
import com.tpwar.game.utils.Assets;

public class LineAttack
extends SkeletonDisplayObject {
    private Assets assets = Assets.getInstance();
    public Unit firstUnit;
    public Unit secondUnit;
    private Skeleton cursorSkeleton;
    private AnimationStateData cursorStateData;
    private AnimationState cursorState;

    public LineAttack(SkeletonRenderer skeletonRenderer) {
        super(skeletonRenderer);
        SkeletonData cursorData = (SkeletonData)this.assets.get("units/cursors.json");
        this.cursorSkeleton = new Skeleton(cursorData);
        this.cursorStateData = new AnimationStateData(cursorData);
        this.cursorState = new AnimationState(this.cursorStateData);
        this.cursorState.setAnimation(0, "1", true);
    }

    public void setDirect(int direct) {
        switch (direct) {
            case -2: {
                this.cursorState.setAnimation(0, "5", true);
                break;
            }
            case -1: {
                this.cursorState.setAnimation(0, "4", true);
                break;
            }
            case 0: {
                this.cursorState.setAnimation(0, "3", true);
                break;
            }
            case 1: {
                this.cursorState.setAnimation(0, "2", true);
                break;
            }
            case 2: {
                this.cursorState.setAnimation(0, "1", true);
            }
        }
    }

    public boolean hasUnits() {
        return this.firstUnit != null && this.secondUnit != null;
    }

    @Override
    public void clear() {
        this.firstUnit = null;
        this.secondUnit = null;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.drawSekeleton(batch, this.cursorState, this.cursorSkeleton);
        super.draw(batch, parentAlpha);
    }
}

