/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.battle;

import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.utils.Queue;
import com.tpwar.events.EventDispatcher;
import com.tpwar.game.battle.UnitAnimationElement;
import com.tpwar.game.battle.units.Unit;

public class UnitAnimationQueue
extends Group {
    private final EventDispatcher<Boolean> dispatcher = new EventDispatcher();
    private final Queue<UnitAnimationElement> queue = new Queue();
    private final EndAnimationCallback callback = new EndAnimationCallback();
    private UnitAnimationElement currentAnimation;
    private boolean started = false;

    public void addUnitAnimation(Unit unit1, Unit unit2, boolean defence) {
        UnitAnimationElement unitAnimation = new UnitAnimationElement(unit1, unit2, defence);
        this.queue.addLast(unitAnimation);
    }

    public void start() {
        if (!this.started) {
            this.started = true;
            this.currentAnimation = this.queue.removeFirst();
            this.addActor(this.currentAnimation);
            this.currentAnimation.start(this.callback);
        }
    }

    public boolean hasAnimation() {
        return this.queue.size > 0;
    }

    private void complete() {
        this.started = false;
        this.getDispatcher().dispatch(12, true);
    }

    public EventDispatcher<Boolean> getDispatcher() {
        return this.dispatcher;
    }

    private final class EndAnimationCallback
    implements Runnable {
        private EndAnimationCallback() {
        }

        @Override
        public void run() {
            UnitAnimationQueue.this.currentAnimation.remove();
            if (UnitAnimationQueue.this.hasAnimation()) {
                UnitAnimationQueue.this.currentAnimation = UnitAnimationQueue.this.queue.removeFirst();
                UnitAnimationQueue.this.addActor(UnitAnimationQueue.this.currentAnimation);
                UnitAnimationQueue.this.currentAnimation.start(UnitAnimationQueue.this.callback);
            } else {
                UnitAnimationQueue.this.complete();
            }
        }
    }
}

