/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.battle.units;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.AnimationState;
import com.esotericsoftware.spine.AnimationStateData;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonRenderer;
import com.tpwar.domain.avatar.ArtefactData;
import com.tpwar.domain.avatar.UnitData;
import com.tpwar.game.battle.SkeletonDisplayObject;
import com.tpwar.game.battle.units.UnitArtefactSlot;
import com.tpwar.game.battle.units.UnitParameters;
import com.tpwar.game.display.DisplaySkeletonBounds;
import com.tpwar.game.maps.entity.AnimatedObject;
import com.tpwar.game.screens.shaker.ScreenShaker;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.LocalSettings;
import com.tpwar.sound.SoundSystem;

public abstract class Unit
extends SkeletonDisplayObject
implements AnimationState.AnimationStateListener {
    private static final String TAG = Unit.class.getSimpleName();
    protected final LocalSettings settings = LocalSettings.getInstance();
    protected final Assets assets = Assets.getInstance();
    protected final SoundSystem soundSystem = SoundSystem.getInstance();
    protected final TextureAtlas atlas = (TextureAtlas)this.assets.get("units/battle_elements.atlas");
    protected Skeleton skeleton;
    protected DisplaySkeletonBounds bounds;
    protected AnimationStateData stateData;
    protected AnimationState state;
    protected UnitParameters parametrs;
    protected AnimatedObject selectionCircle;
    protected ScreenShaker screenShaker;
    public int index;
    public UnitState unitState;
    public UnitData unitData;
    public UnitArtefactSlot artefactSlot;
    public boolean isDead = false;
    private ArtefactData artefact;
    private String animationName;
    public int lineIndex = -1;
    public boolean isAnimationFinished;
    public boolean isDieAnimationFinished;
    public boolean mouseEnabled = true;
    private int numSelected = 0;
    private Label damage;

    public Unit(SkeletonRenderer skeletonRenderer, SkeletonData skeletonData) {
        super(skeletonRenderer);
        this.skeleton = new Skeleton(skeletonData);
        this.bounds = new DisplaySkeletonBounds();
        this.stateData = new AnimationStateData(skeletonData);
        this.state = new AnimationState(this.stateData);
        this.state.setTimeScale(0.75f);
        this.parametrs = new UnitParameters();
        this.parametrs.pack();
        this.addActor(this.parametrs);
        Array<TextureRegion> circleRegions = this.assets.extractRegions(this.atlas, "unit_select");
        Animation<TextureRegion> selectionCircleAnimation = new Animation<TextureRegion>(0.041666668f, circleRegions);
        selectionCircleAnimation.setPlayMode(Animation.PlayMode.LOOP);
        this.selectionCircle = new AnimatedObject(selectionCircleAnimation);
        this.selectionCircle.setPosition(-50.0f, -30.0f);
        this.artefactSlot = new UnitArtefactSlot();
        this.artefactSlot.pack();
        this.artefactSlot.setTouchable(Touchable.enabled);
        this.artefactSlot.setPosition(50.0f, 86.0f);
        this.bounds.update(this.skeleton, this.getX(), this.getY());
        this.setSize(this.bounds.getWidth(), this.bounds.getHeight());
        this.state.addListener(this);
        this.isDieAnimationFinished = true;
        this.isAnimationFinished = true;
        Label.LabelStyle damageStyle = new Label.LabelStyle();
        damageStyle.font = this.assets.getFont().arialBold25Numbers;
        this.damage = new Label((CharSequence)"", damageStyle);
    }

    public void showDamage(int damageValue) {
        this.damage.setText(String.valueOf(damageValue));
        this.damage.setPosition(this.getWidth() - this.damage.getWidth() / 2.0f, 100.0f);
        this.damage.getColor().a = 1.0f;
        SequenceAction damageAction = Actions.sequence((Action)Actions.parallel((Action)Actions.moveBy(this.damage.getX(), this.damage.getY() + 8.0f, 2.0f, Interpolation.pow4Out), (Action)Actions.fadeOut(2.2f, Interpolation.pow4Out)), (Action)Actions.run(new Runnable(){

            @Override
            public void run() {
                Unit.this.damage.remove();
            }
        }));
        this.damage.addAction(damageAction);
        this.addActor(this.damage);
    }

    public void select() {
        ++this.numSelected;
        this.addActor(this.selectionCircle);
        this.selectionCircle.stop();
        this.selectionCircle.play();
        this.soundSystem.fx.play("sound/fx/13. Select_Unit (train_unit).mp3");
    }

    public void unselect() {
        --this.numSelected;
        if (this.numSelected == 0) {
            this.selectionCircle.remove();
            this.selectionCircle.stop();
        }
    }

    public void stand() {
        this.state.setAnimation(0, "stand", true);
    }

    public void die() {
        this.state.setAnimation(0, "die", false);
        this.soundSystem.fx.play("sound/fx/12. Unit_death.mp3");
        this.isAnimationFinished = true;
        this.isDead = true;
    }

    public void damage() {
        this.state.setAnimation(0, "damage", false);
        this.state.addAnimation(0, "stand", true, 0.0f);
        this.isAnimationFinished = false;
    }

    public void defence() {
        String name = this.stateData.getSkeletonData().findAnimation("defence") != null ? "defence" : "deffence";
        this.state.setAnimation(0, name, false);
        this.state.addAnimation(0, "stand", true, 0.0f);
        this.isAnimationFinished = false;
        this.soundSystem.fx.play("sound/fx/11. Hit_into_shield.mp3");
    }

    public void attack(int index, Unit target, boolean defence) {
        this.state.setAnimation(0, "attack_" + index, false);
        this.state.addAnimation(0, "stand", true, 0.0f);
        if (defence) {
            target.defence();
        } else {
            target.damage();
        }
        this.isAnimationFinished = false;
    }

    public void updateParameters() {
        if (this.unitData != null) {
            this.parametrs.setArmor(this.unitData.armor);
            this.parametrs.setDamage(this.unitData.damage);
            this.parametrs.setHealth(this.unitData.health);
        }
    }

    public void deactivate() {
        this.reset();
        this.parametrs.setVisible(false);
        this.mouseEnabled = false;
    }

    public void activate() {
        this.updateParameters();
        this.parametrs.setVisible(true);
        this.mouseEnabled = true;
    }

    public void reset() {
        this.numSelected = 0;
        this.lineIndex = -1;
        this.selectionCircle.remove();
        this.selectionCircle.stop();
    }

    public ArtefactData getArtefact() {
        return this.artefact;
    }

    public void showArtefactSlot() {
        this.addActor(this.artefactSlot);
    }

    public void hideArtefactSlot() {
        this.artefactSlot.remove();
    }

    public void removeArtefact() {
        this.hideArtefactSlot();
        this.artefact = null;
        this.artefactSlot.setArtefact(null);
    }

    public void setArtefact(ArtefactData artefact) {
        this.artefactSlot.setArtefact(artefact.getType());
        this.artefact = artefact;
    }

    @Override
    public void act(float delta) {
        this.state.update(delta);
        super.act(delta);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        this.drawSekeleton(batch, this.state, this.skeleton);
        batch.setBlendFunction(770, 771);
    }

    public boolean contains(float x, float y) {
        this.bounds.update(this.skeleton, this.getX(), this.getY());
        return this.bounds.contains(x, y);
    }

    public DisplaySkeletonBounds getSize() {
        this.bounds.update(this.skeleton, this.getX(), this.getY());
        return this.bounds;
    }

    public void setScreenShaker(ScreenShaker screenShaker) {
        this.screenShaker = screenShaker;
    }

    @Override
    public void start(AnimationState.TrackEntry entry) {
        this.animationName = entry.getAnimation().getName();
    }

    @Override
    public void interrupt(AnimationState.TrackEntry entry) {
    }

    @Override
    public void end(AnimationState.TrackEntry entry) {
        if (this.animationName.equals("stand")) {
            this.isAnimationFinished = true;
        } else if (this.animationName.equals("die")) {
            this.isDieAnimationFinished = true;
        }
    }

    @Override
    public void dispose(AnimationState.TrackEntry entry) {
    }

    @Override
    public void complete(AnimationState.TrackEntry entry) {
    }

    @Override
    public void event(AnimationState.TrackEntry entry, Event event) {
        Gdx.app.log(TAG, entry.toString() + " \n " + event.getString() + "  \n " + event.getData().getString());
    }

    @Override
    public String toString() {
        return "Unit [index=" + this.index + ", positionState=" + this.unitState + "]";
    }

    public static enum UnitState {
        TOP,
        BOTTOM;

    }
}

