/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.battle.units;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;
import com.tpwar.game.utils.Assets;
import com.tpwar.storage.avatar.ArtefactType;

public class UnitArtefactSlot
extends Table {
    private final Assets assets = Assets.getInstance();
    private final TextureAtlas atlas = (TextureAtlas)this.assets.get("units/battle_elements.atlas");
    private Array<Drawable> icons = new Array();
    private Image currentIcon;

    public UnitArtefactSlot() {
        this.setBackground(new TextureRegionDrawable(this.atlas.findRegion("unit_artefact_slot0001")));
        Array<TextureRegion> regions = this.assets.extractRegions(this.atlas, "icon_artefact");
        for (TextureRegion r : regions) {
            this.icons.add(new TextureRegionDrawable(r));
        }
        this.currentIcon = new Image();
        this.currentIcon.setTouchable(Touchable.disabled);
        this.add(this.currentIcon);
    }

    public void setArtefact(ArtefactType artefact) {
        if (artefact == null) {
            this.currentIcon.setDrawable(null);
            return;
        }
        switch (artefact.code) {
            case "dynamic_shield": {
                this.currentIcon.setDrawable(this.icons.get(0));
                break;
            }
            case "double_power": {
                this.currentIcon.setDrawable(this.icons.get(1));
                break;
            }
            case "heal": {
                this.currentIcon.setDrawable(this.icons.get(2));
                break;
            }
            case "dead_ray": {
                this.currentIcon.setDrawable(this.icons.get(3));
            }
        }
    }
}

