/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.battle.units;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.AnimationState;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonRenderer;
import com.tpwar.game.battle.units.Unit;
import com.tpwar.game.screens.shaker.ShakeAction;
import com.tpwar.game.screens.shaker.ShakeHit;

public class UnitHamer
extends Unit {
    private static final Array<Vector2> attackAnimationOffset = new Array(5);
    private static final String TAG = UnitHamer.class.getSimpleName();
    private Vector2 originalPosition;
    private int attackIndex;
    private Unit unitTarget;
    private boolean targetDefence;
    private ShakeAction attackShaker;

    public UnitHamer(SkeletonRenderer skeletonRenderer, SkeletonData skeletonData) {
        super(skeletonRenderer, skeletonData);
        attackAnimationOffset.add(new Vector2(-576.0f, 0.0f));
        attackAnimationOffset.add(new Vector2(-288.0f, 0.0f));
        attackAnimationOffset.add(new Vector2(0.0f, 0.0f));
        attackAnimationOffset.add(new Vector2(288.0f, 0.0f));
        attackAnimationOffset.add(new Vector2(576.0f, 0.0f));
        this.originalPosition = new Vector2();
        this.attackShaker = new ShakeHit(new Vector2(0.2f, 1.0f), 3.0f, 0.9f);
        this.parametrs.setPosition(-100.0f, 20.0f);
    }

    @Override
    public void attack(int index, Unit target, boolean defence) {
        this.soundSystem.fx.play("sound/fx/8. Striker_Hit.mp3");
        this.unitTarget = target;
        this.targetDefence = defence;
        this.attackIndex = index;
        this.state.setAnimation(0, "up", false);
        this.state.addAnimation(0, "fly_f_" + index, false, 0.0f);
        this.state.addAnimation(0, "attack", false, 0.0f);
        this.state.addAnimation(0, "fly_b_" + index, false, 0.0f);
        this.state.addAnimation(0, "down", false, 0.0f);
        this.state.addAnimation(0, "stand", true, 0.0f);
        this.isAnimationFinished = false;
    }

    @Override
    public void start(AnimationState.TrackEntry entry) {
        if (entry.getAnimation().getName().equals("attack")) {
            this.originalPosition.set(this.getX(), this.getY());
            this.setX(this.getX() + UnitHamer.attackAnimationOffset.get((int)(this.attackIndex - 1)).x);
            this.setY(this.getY() + UnitHamer.attackAnimationOffset.get((int)(this.attackIndex - 1)).y);
            if (this.targetDefence) {
                this.unitTarget.defence();
            } else {
                this.unitTarget.damage();
            }
            this.attackShaker.reset();
            this.screenShaker.shake(this.attackShaker);
            if (this.settings.vibrationInBattle()) {
                Gdx.input.vibrate(100);
            }
        }
    }

    @Override
    public void interrupt(AnimationState.TrackEntry entry) {
        if (entry.getAnimation().getName().equals("attack")) {
            this.setPosition(this.originalPosition.x, this.originalPosition.y);
        }
    }

    @Override
    public void end(AnimationState.TrackEntry entry) {
    }

    @Override
    public void dispose(AnimationState.TrackEntry entry) {
    }

    @Override
    public void complete(AnimationState.TrackEntry entry) {
        if (entry.getAnimation().getName().equals("stand")) {
            this.isAnimationFinished = true;
        }
    }

    @Override
    public void event(AnimationState.TrackEntry entry, Event event) {
        Gdx.app.log(TAG, entry.toString() + " \n " + event.getString() + "  \n " + event.getData().getString());
    }
}

