/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.battle.units;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.tpwar.game.utils.Assets;

public class UnitParameters
extends Table {
    private final Assets assets = Assets.getInstance();
    private final TextureAtlas atlas = (TextureAtlas)this.assets.get("units/battle_elements.atlas");
    private Label damage;
    private Label armor;
    private Label health;

    public UnitParameters() {
        NinePatch ninePatch = new NinePatch((TextureRegion)this.atlas.findRegion("parameters_bg"), 3, 3, 3, 3);
        this.setBackground(new NinePatchDrawable(ninePatch));
        BitmapFont font = this.assets.get("Verdana-Bold_14.ttf", BitmapFont.class);
        Color color = Color.WHITE;
        Label.LabelStyle style = new Label.LabelStyle(font, color);
        this.damage = new Label((CharSequence)"00", style);
        this.add(this.damage).pad(4.0f);
        this.add(new Image(new TextureRegionDrawable(this.atlas.findRegion("damage_icon")))).row();
        this.armor = new Label((CharSequence)"00", style);
        this.add(this.armor).pad(4.0f);
        this.add(new Image(new TextureRegionDrawable(this.atlas.findRegion("armor_icon")))).row();
        this.health = new Label((CharSequence)"00", style);
        this.add(this.health).pad(4.0f);
        this.add(new Image(new TextureRegionDrawable(this.atlas.findRegion("health_icon"))));
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        batch.setBlendFunction(770, 771);
        super.draw(batch, parentAlpha);
    }

    public void setDamage(int damage) {
        this.damage.setText(String.valueOf(damage));
    }

    public void setArmor(int armor) {
        this.armor.setText(String.valueOf(armor));
    }

    public void setHealth(int health) {
        this.health.setText(String.valueOf(health));
    }
}

