/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.display;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.FloatArray;
import com.esotericsoftware.spine.Skeleton;

public class DisplaySkeletonBounds {
    private Vector2 offset = new Vector2();
    private Vector2 size = new Vector2();
    private FloatArray temp = new FloatArray();
    private float minX = 0.0f;
    private float minY = 0.0f;
    private float maxX = 0.0f;
    private float maxY = 0.0f;

    public void update(Skeleton skeleton, float offsetX, float offsetY) {
        skeleton.setPosition(offsetX, offsetY);
        skeleton.getBounds(this.offset, this.size, this.temp);
        this.minX = this.offset.x;
        this.minY = this.offset.y;
        this.maxX = this.minX + this.size.x;
        this.maxY = this.minY + this.size.y;
    }

    public boolean contains(float x, float y) {
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY;
    }

    public float getX() {
        return this.minX;
    }

    public float getWidth() {
        return this.maxX - this.minX;
    }

    public float getY() {
        return this.minY;
    }

    public float getHeight() {
        return this.maxY - this.minY;
    }
}

