/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.display;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.tpwar.game.utils.ScaleScreen;
import com.tpwar.platform.SizeChangeListener;

public class VirtualKeyboardFocus
implements SizeChangeListener {
    public static final float KEYBOARD_MIN_HEIGHT_RATIO = 0.15f;
    private static final int INDENT = 10;
    private Stage stage;
    private float heightDiff = 0.0f;
    private int originalViewportY = 0;
    private Vector2 vector = new Vector2();

    public VirtualKeyboardFocus(Stage stage) {
        this.stage = stage;
        this.originalViewportY = stage.getViewport().getScreenY();
        if (!ScaleScreen.isDesktop()) {
            stage.addListener(new FocusListener(){

                @Override
                public void keyboardFocusChanged(FocusListener.FocusEvent event, Actor actor, boolean focused) {
                    super.keyboardFocusChanged(event, actor, focused);
                    if (actor instanceof TextField && focused) {
                        VirtualKeyboardFocus.this.focus();
                    }
                }
            });
        }
    }

    @Override
    public void onSizeChange(float width, float height) {
        boolean isOpen;
        int screenHeight = Gdx.graphics.getBackBufferHeight();
        this.heightDiff = (float)screenHeight - height;
        boolean bl = isOpen = this.heightDiff > (float)screenHeight * 0.15f;
        if (isOpen) {
            this.focus();
        } else {
            this.unfocus();
        }
    }

    private void unfocus() {
        Actor actor = this.stage.getKeyboardFocus();
        if (actor instanceof TextField) {
            this.stage.setKeyboardFocus(null);
        }
        this.stage.getViewport().setScreenY(this.originalViewportY);
        this.heightDiff = 0.0f;
    }

    private void focus() {
        Actor actor = this.stage.getKeyboardFocus();
        if (actor instanceof TextField && this.heightDiff > 0.0f) {
            Group root = this.stage.getRoot();
            actor.getParent().localToStageCoordinates(this.vector.set(actor.getX(), actor.getY()));
            Vector2 screen = new Vector2(0.0f, this.heightDiff);
            this.stage.screenToStageCoordinates(screen);
            if (screen.y > this.vector.y - root.getY()) {
                screen.y = (int)(screen.y + this.vector.y + root.getY());
                this.stage.stageToScreenCoordinates(screen);
                this.stage.getViewport().setScreenY((int)screen.y);
            }
        }
    }
}

