/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.hud;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.Component;
import com.tpwar.game.utils.GroupUtil;

public class AvatarIcon
extends Group {
    private final Assets assets = Assets.getInstance();
    private final TextureAtlas atlas = (TextureAtlas)this.assets.get("ui/hud.atlas");
    private Label level;
    private Image levelBg;
    private Image bg;
    private Image icon = new Image();

    public AvatarIcon() {
        this.icon.setPosition(14.0f, 11.0f);
        this.addActor(this.icon);
        this.bg = Component.getImage(this.atlas, "avatar_bg");
        this.addActor(this.bg);
        this.levelBg = Component.getImage(this.atlas, "avatar_level_bg");
        this.levelBg.setX(this.bg.getWidth() - this.levelBg.getWidth());
        this.addActor(this.levelBg);
        Label.LabelStyle style = new Label.LabelStyle();
        style.font = this.assets.getFont().centryGothicBold20;
        style.fontColor = Color.WHITE;
        this.level = new Label((CharSequence)"00", style);
        this.level.setAlignment(1);
        this.level.setWidth(20.0f);
        this.level.setX(this.levelBg.getX() + (this.levelBg.getWidth() - this.level.getWidth()) / 2.0f);
        this.level.setY(this.levelBg.getY() + (this.levelBg.getHeight() - this.level.getHeight()) / 2.0f + 2.0f);
        this.addActor(this.level);
        this.setSize(GroupUtil.getWidth(this), GroupUtil.getHeight(this));
    }

    public AvatarIcon(int align) {
        this();
        switch (align) {
            case 8: {
                this.levelBg.setX(this.bg.getWidth() - this.levelBg.getWidth());
                break;
            }
            case 16: {
                this.levelBg.setX(0.0f);
            }
        }
        this.level.setX(this.levelBg.getX() + (this.levelBg.getWidth() - this.level.getWidth()) / 2.0f);
    }

    public void updateIcon(AvatarData avatarData) {
        String imageName = avatarData.getImageName() + "_round_icon_small";
        this.icon.setDrawable(Assets.getInstance().getDrawable(this.atlas, imageName));
        this.icon.setSize(62.0f, 62.0f);
    }

    public void update(int level) {
        this.level.setText(String.valueOf(level));
    }
}

