/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.hud;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.hud.AvatarIcon;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.Component;
import com.tpwar.game.utils.GroupUtil;
import com.tpwar.storage.Storage;
import io.netty.util.internal.StringUtil;

public class AvatarProfile
extends Group {
    private static final Model model = Model.getInstance();
    private static final Storage storage = Storage.getInstance();
    private static final Assets assets = Assets.getInstance();
    private static final TextureAtlas atlas = (TextureAtlas)assets.get("ui/hud.atlas");
    private AvatarIcon avatarIcon;
    private Image expLine;
    private Label avatarName;
    private Image clanBg;
    private Label clanTag;

    public AvatarProfile() {
        AvatarData avatar = AvatarProfile.model.player.selectedAvatar;
        this.avatarIcon = new AvatarIcon();
        this.avatarIcon.updateIcon(avatar);
        this.avatarIcon.setY(3.0f);
        this.avatarIcon.setX(4.0f);
        this.addActor(this.avatarIcon);
        this.clanBg = Component.getImage(atlas, "clan_tag_bg");
        this.clanBg.setX(100.0f);
        this.clanBg.setY(65.0f);
        this.addActor(this.clanBg);
        Image expBg = Component.getImage(atlas, "exp_bg");
        expBg.setX(106.0f);
        expBg.setY(44.0f);
        this.addActor(expBg);
        this.expLine = new Image(Component.getNinePatchDrawable(atlas, "exp_line", 0, 5, 0, 0));
        this.expLine.setX(111.0f);
        this.expLine.setY(47.0f);
        this.addActor(this.expLine);
        Image expBorder = Component.getImage(atlas, "exp_border");
        expBorder.setX(105.0f);
        expBorder.setY(44.0f);
        this.addActor(expBorder);
        Label.LabelStyle style = new Label.LabelStyle();
        style.font = AvatarProfile.assets.getFont().centryGothicBold20;
        style.fontColor = Color.valueOf(AvatarProfile.storage.faction.getColor(avatar.fractionId));
        this.avatarName = new Label((CharSequence)avatar.name, style);
        this.avatarName.setX(168.0f);
        this.avatarName.setY(65.0f);
        this.addActor(this.avatarName);
        style = new Label.LabelStyle(AvatarProfile.assets.getFont().centryGothicBold20, Color.WHITE);
        this.clanTag = new Label((CharSequence)"WWW", style);
        this.clanTag.setAlignment(1);
        this.clanTag.setWidth(48.0f);
        this.clanTag.setX(108.0f);
        this.clanTag.setY(65.0f);
        this.setSize(GroupUtil.getWidth(this), GroupUtil.getHeight(this));
    }

    public void updateClanTag() {
        AvatarData avatar = AvatarProfile.model.player.selectedAvatar;
        if (!StringUtil.isNullOrEmpty(avatar.clanTag)) {
            this.clanTag.setText(avatar.clanTag);
            this.addActor(this.clanBg);
            this.addActor(this.clanTag);
            this.avatarName.setX(168.0f);
        } else {
            this.clanBg.remove();
            this.clanTag.remove();
            this.avatarName.setX(109.0f);
        }
    }

    public void setLevel(int level) {
        this.avatarIcon.update(level);
    }

    public void setExp(float value) {
        this.expLine.setWidth(Math.max(value * 1.25f, 0.0f));
    }

    public void setAvatarName(String name) {
        this.avatarName.setText(name);
    }

    public Label getAvatarName() {
        return this.avatarName;
    }
}

