/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.hud;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;
import com.tpwar.domain.avatar.ArtefactData;
import com.tpwar.game.utils.Assets;

public class BattleArtefactSlot
extends Table
implements Disableable {
    private static final Assets assets = Assets.getInstance();
    private static final TextureAtlas atlas = (TextureAtlas)assets.get("units/battle_elements.atlas");
    private ArtefactData artefactData;
    private Array<TextureRegionDrawable> icons = new Array(8);
    private Image icon;
    private Label num;
    private boolean isDisabled;

    public BattleArtefactSlot() {
        Table iconTable = new Table();
        NinePatchDrawable background = assets.getNinePatchDrawable(atlas, "artefact_slot", 3, 3, 3, 3);
        iconTable.setBackground(background);
        Array<TextureRegion> regions = assets.extractRegions(atlas, "icon_artefact");
        for (TextureRegion tr : regions) {
            this.icons.add(new TextureRegionDrawable(tr));
        }
        this.icon = new Image();
        this.icon.setVisible(false);
        iconTable.add(this.icon);
        this.add(iconTable).expand().padTop(2.0f).row();
        Label.LabelStyle labelStyle = new Label.LabelStyle(BattleArtefactSlot.assets.getFont().arialBold14, Color.WHITE);
        this.num = new Label((CharSequence)"x0", labelStyle);
        this.num.setEllipsis(true);
        this.add(this.num).expandX().padBottom(2.0f);
    }

    public void setArtefact(ArtefactData artefactData) {
        this.artefactData = artefactData;
        switch (artefactData.getType().code) {
            case "dynamic_shield": {
                this.icon.setDrawable(this.icons.get(0));
                break;
            }
            case "double_power": {
                this.icon.setDrawable(this.icons.get(1));
                break;
            }
            case "heal": {
                this.icon.setDrawable(this.icons.get(2));
                break;
            }
            case "dead_ray": {
                this.icon.setDrawable(this.icons.get(3));
            }
        }
        this.icon.setVisible(true);
    }

    public void updateNum() {
        this.num.setText("x" + this.artefactData.count);
    }

    public ArtefactData getArtefact() {
        return this.artefactData;
    }

    @Override
    public void setDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
        if (isDisabled) {
            this.icon.setColor(Color.GRAY);
            this.num.setColor(Color.GRAY);
        } else {
            this.icon.setColor(Color.WHITE);
            this.num.setColor(Color.WHITE);
        }
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabled;
    }
}

