/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.hud;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.hud.AvatarIcon;
import com.tpwar.game.hud.ReadinessIcon;
import com.tpwar.game.utils.Assets;
import com.tpwar.storage.Storage;

public class BattleAvatarProfile
extends Table {
    private final Storage storage = Storage.getInstance();
    private final Assets assets = Assets.getInstance();
    private AvatarIcon avatarIcon;
    private Label name;
    private Label readiness;
    private ReadinessIcon readinessIcon;
    public final Vector2 originPosition = Vector2.Zero.cpy();
    public final Vector2 hidePosition = Vector2.Zero.cpy();

    public BattleAvatarProfile(int align) {
        this.setTransform(true);
        this.avatarIcon = new AvatarIcon(align);
        Label.LabelStyle nameStyle = new Label.LabelStyle();
        nameStyle.font = this.assets.getFont().centryGothicBold20;
        this.name = new Label((CharSequence)"", nameStyle);
        this.name.setAlignment(align);
        Label.LabelStyle readinessStyle = new Label.LabelStyle();
        readinessStyle.font = this.assets.getFont().arial14;
        this.readiness = new Label((CharSequence)"\u0413\u043e\u0442\u043e\u0432\u043d\u043e\u0441\u0442\u044c:", readinessStyle);
        this.readinessIcon = new ReadinessIcon();
        Table state = new Table();
        state.add(this.readiness).expand();
        state.add(this.readinessIcon).expand().padTop(2.0f).padLeft(2.0f);
        Table info = new Table();
        info.add(this.name).expand().align(align).row();
        info.add(state).expand().align(align);
        switch (align) {
            case 8: {
                this.add(this.avatarIcon);
                this.add(info).expand().top().padLeft(4.0f);
                break;
            }
            case 16: {
                this.add(info).expand().top().padRight(4.0f);
                this.add(this.avatarIcon);
            }
        }
    }

    public void setReady(boolean value) {
        this.readinessIcon.setReady(value);
    }

    public void setAvatar(AvatarData avatar) {
        this.avatarIcon.update(avatar.level);
        this.avatarIcon.updateIcon(avatar);
        this.name.setText(avatar.name);
        this.name.getStyle().fontColor = avatar.name.equals("Dark Illusion") ? Color.LIGHT_GRAY : Color.valueOf(this.storage.faction.getColor(avatar.fractionId));
    }
}

