/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.hud;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.ArtefactData;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.hud.BattleArtefactSlot;
import com.tpwar.game.hud.SelectArtefactListener;
import com.tpwar.game.utils.Assets;

public class BattleControlPanel
extends Table {
    private static final Assets assets = Assets.getInstance();
    private static final Model model = Model.getInstance();
    public ImageButton startRoundBtn;
    public ImageButton escapeBtn;
    public Array<BattleArtefactSlot> artefactSlots = new Array();
    private long artefactTypeId;
    private boolean selected = false;
    private SelectArtefactListener selectArtefactListener;
    public final Vector2 originPosition = Vector2.Zero.cpy();
    public final Vector2 hidePosition = Vector2.Zero.cpy();

    public BattleControlPanel() {
        TextureAtlas atlas = (TextureAtlas)assets.get("ui/hud.atlas");
        this.defaults().space(4.0f);
        ImageButton.ImageButtonStyle btnStyle = new ImageButton.ImageButtonStyle();
        btnStyle.up = assets.getDrawable(atlas, "start_round_btn_up");
        btnStyle.down = assets.getDrawable(atlas, "start_round_btn_down");
        this.startRoundBtn = new ImageButton(btnStyle);
        this.startRoundBtn.setDisabled(true);
        this.startRoundBtn.setColor(Color.GRAY);
        this.add(this.startRoundBtn).padRight(5.0f).top();
        for (int i = 0; i < 4; ++i) {
            final BattleArtefactSlot artefactSlot = new BattleArtefactSlot();
            artefactSlot.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    if (artefactSlot.isDisabled()) {
                        return;
                    }
                    boolean bl = BattleControlPanel.this.selected = !BattleControlPanel.this.selected;
                    if (BattleControlPanel.this.selectArtefactListener != null) {
                        BattleControlPanel.this.selectArtefactListener.clickArtefact(artefactSlot.getArtefact(), BattleControlPanel.this.selected);
                    }
                }
            });
            this.add(artefactSlot).bottom();
            this.artefactSlots.add(artefactSlot);
        }
        AvatarData avatarData = BattleControlPanel.model.player.selectedAvatar;
        for (int i = 0; i < Math.min(avatarData.artefacts.size, 4); ++i) {
            BattleArtefactSlot artefactSlot = this.artefactSlots.get(i);
            artefactSlot.setArtefact(avatarData.artefacts.get(i));
        }
        btnStyle = new ImageButton.ImageButtonStyle();
        btnStyle.up = assets.getDrawable(atlas, "escape_battle_btn_up");
        btnStyle.down = assets.getDrawable(atlas, "escape_battle_btn_down");
        this.escapeBtn = new ImageButton(btnStyle);
        this.add(this.escapeBtn).padLeft(5.0f).top();
        Array<ArtefactData> artefacts = BattleControlPanel.model.player.selectedAvatar.artefacts;
        for (int i = 0; i < Math.min(4, artefacts.size); ++i) {
            BattleArtefactSlot artefactSlot = this.artefactSlots.get(i);
            artefactSlot.setArtefact(artefacts.get(i));
        }
    }

    public SelectArtefactListener getSelectArtefactListener() {
        return this.selectArtefactListener;
    }

    public void setSelectArtefactListener(SelectArtefactListener selectArtefactListener) {
        this.selectArtefactListener = selectArtefactListener;
    }

    public void lockButtons() {
        this.lockStartRoundButton(true);
        this.escapeBtn.setDisabled(true);
        this.escapeBtn.setColor(Color.GRAY);
    }

    public void lockStartRoundButton(boolean value) {
        this.startRoundBtn.setDisabled(value);
        this.startRoundBtn.setColor(value ? Color.GRAY : Color.WHITE);
    }

    public void unlockButtons() {
        this.lockStartRoundButton(false);
        this.escapeBtn.setDisabled(false);
        this.escapeBtn.setColor(Color.WHITE);
        this.updateArtefacts();
    }

    public void setArtefactId(long artefactTypeId) {
        this.artefactTypeId = artefactTypeId;
    }

    public void updateArtefacts() {
        for (BattleArtefactSlot battleArtefactSlot : this.artefactSlots) {
            if (battleArtefactSlot.getArtefact() == null) {
                battleArtefactSlot.setDisabled(true);
                continue;
            }
            if (this.artefactTypeId > 0L) {
                battleArtefactSlot.setDisabled(battleArtefactSlot.getArtefact().artefactTypeId != this.artefactTypeId || battleArtefactSlot.getArtefact().count <= 0);
            } else {
                battleArtefactSlot.setDisabled(false);
            }
            battleArtefactSlot.updateNum();
        }
    }

    public void lockArtefacts() {
        this.selected = false;
        for (BattleArtefactSlot battleArtefactSlot : this.artefactSlots) {
            battleArtefactSlot.setDisabled(true);
        }
    }
}

