/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.hud;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.display.Resizeble;
import com.tpwar.game.hud.BattleAvatarProfile;
import com.tpwar.game.hud.BattleControlPanel;
import com.tpwar.game.hud.TextTimer;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.ScaleScreen;
import com.tpwar.sound.SoundSystem;

public class BattleHud
extends Group
implements Resizeble {
    private final Assets assets = Assets.getInstance();
    private final Model model = Model.getInstance();
    public BattleControlPanel bottomPanel = new BattleControlPanel();
    private BattleAvatarProfile profile1;
    private BattleAvatarProfile profile2;
    private TextTimer timer;
    private float timerDelta = 0.0f;
    private long timeEnd;
    private Table observationMode;

    public BattleHud() {
        this.bottomPanel.setTransform(true);
        this.bottomPanel.pack();
        this.addActor(this.bottomPanel);
        this.profile1 = new BattleAvatarProfile(8);
        this.profile1.pack();
        this.addActor(this.profile1);
        this.profile2 = new BattleAvatarProfile(16);
        this.profile2.pack();
        this.addActor(this.profile2);
        this.timer = new TextTimer(this.assets.getFont().centryGothicBold25, Color.WHITE);
        this.addActor(this.timer);
    }

    public void showObservationMode() {
        this.observationMode = new Table();
        this.observationMode.setTransform(true);
        this.observationMode.setBackground(this.assets.getNinePatchDrawable(this.assets.getCommonAtlas(), "blurred_background", 52, 52, 2, 4));
        Label.LabelStyle style = new Label.LabelStyle(this.assets.getFont().arialBold16, Color.WHITE);
        Label mode = new Label((CharSequence)"\u0420\u0435\u0436\u0438\u043c \u043d\u0430\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f", style);
        this.observationMode.add(mode).expand();
        this.observationMode.pack();
        this.addActor(this.observationMode);
    }

    public void hideAll() {
        if (this.observationMode != null) {
            this.observationMode.addAction(Actions.fadeOut(0.5f, Interpolation.sineOut));
        }
        this.timer.addAction(Actions.fadeOut(0.5f, Interpolation.sineOut));
        this.profile1.addAction(Actions.moveTo(this.profile1.hidePosition.x, this.profile1.hidePosition.y, 0.3f, Interpolation.sineOut));
        this.profile2.addAction(Actions.moveTo(this.profile2.hidePosition.x, this.profile2.hidePosition.y, 0.3f, Interpolation.sineOut));
        this.bottomPanel.addAction(Actions.moveTo(this.bottomPanel.hidePosition.x, this.bottomPanel.hidePosition.y, 0.3f, Interpolation.sineOut));
    }

    public void showAll() {
        if (this.observationMode != null) {
            this.observationMode.addAction(Actions.fadeIn(0.5f, Interpolation.sineOut));
        }
        this.timer.addAction(Actions.fadeIn(0.5f, Interpolation.sineIn));
        this.profile1.addAction(Actions.moveTo(this.profile1.originPosition.x, this.profile1.originPosition.y, 0.3f, Interpolation.sineIn));
        this.profile2.addAction(Actions.moveTo(this.profile2.originPosition.x, this.profile2.originPosition.y, 0.3f, Interpolation.sineIn));
        this.bottomPanel.addAction(Actions.moveTo(this.bottomPanel.originPosition.x, this.bottomPanel.originPosition.y, 0.3f, Interpolation.sineIn));
    }

    public void setTimeEnd(long timeEnd) {
        this.timeEnd = timeEnd;
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        this.timerDelta += delta;
        if (this.timerDelta > 1.0f) {
            this.timerDelta -= 1.0f;
            this.updateTimer();
        }
    }

    private void updateTimer() {
        long currentTime = this.model.getServerTime();
        long timeLeft = this.timeEnd - currentTime;
        this.timer.update(timeLeft < 0L ? 0L : timeLeft);
        if (timeLeft / 1000L == 10L && !this.model.battle.hasResult()) {
            SoundSystem soundSystem = SoundSystem.getInstance();
            soundSystem.music.pause();
            soundSystem.fx.play("sound/fx/30. Timer_10 sec.mp3");
        }
    }

    public void setAvatars(AvatarData avatar1, AvatarData avatar2) {
        this.profile1.setAvatar(avatar1);
        this.profile2.setAvatar(avatar2);
        this.profile1.pack();
        this.profile2.pack();
        this.resize(Gdx.graphics.getBackBufferWidth(), Gdx.graphics.getBackBufferHeight());
    }

    public void setReady(boolean ready1, boolean ready2) {
        this.profile1.setReady(ready1);
        this.profile2.setReady(ready2);
    }

    @Override
    public void resize(int width, int height) {
        float scale = ScaleScreen.getScale();
        this.bottomPanel.setScale(scale);
        this.bottomPanel.originPosition.x = ((float)width - this.bottomPanel.getWidth() * scale) / 2.0f;
        this.bottomPanel.originPosition.y = 10.0f;
        this.bottomPanel.hidePosition.x = this.bottomPanel.originPosition.x;
        this.bottomPanel.hidePosition.y = -this.bottomPanel.getHeight() * scale;
        this.bottomPanel.setPosition(this.bottomPanel.originPosition.x, this.bottomPanel.originPosition.y);
        this.profile1.setScale(scale);
        this.profile1.originPosition.x = 10.0f;
        this.profile1.originPosition.y = (float)height - this.profile1.getHeight() * scale - 10.0f;
        this.profile1.hidePosition.set(this.profile1.originPosition);
        this.profile1.hidePosition.x = -this.profile1.getWidth() * scale;
        this.profile2.setScale(scale);
        this.profile2.originPosition.x = (float)width - this.profile2.getWidth() * scale - 10.0f;
        this.profile2.originPosition.y = (float)height - this.profile2.getHeight() * scale - 10.0f;
        this.profile2.hidePosition.set(this.profile1.originPosition);
        this.profile2.hidePosition.x = width;
        this.profile1.setPosition(this.profile1.originPosition.x, this.profile1.originPosition.y);
        this.profile2.setPosition(this.profile2.originPosition.x, this.profile2.originPosition.y);
        this.timer.setScale(scale);
        this.timer.setX(((float)width - this.timer.getWidth() * scale) / 2.0f);
        this.timer.setY((float)height - this.timer.getHeight() * scale - 20.0f * scale);
        if (this.observationMode != null) {
            this.observationMode.setScale(scale);
            this.observationMode.setX(((float)width - this.observationMode.getWidth() * scale) / 2.0f);
            this.observationMode.setY(this.timer.getY() - this.observationMode.getHeight() * scale - 20.0f * scale);
        }
    }
}

