/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.hud;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.tpwar.domain.avatar.ChatData;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.Component;
import com.tpwar.net.Commander;

public class ChatPanel
extends Group {
    private final Assets assets = Assets.getInstance();
    private final Commander commander = Commander.getInstance();
    private final TextureAtlas atlas = this.assets.get("ui/hud.atlas", TextureAtlas.class);
    private final TextureAtlas uiAtlas = this.assets.get("ui/common.atlas", TextureAtlas.class);
    private final int CHAT_WIDTH = 352;
    private TextField chatInput;
    private Label chat;
    private ScrollPane scrollPane;
    private ImageButton closeBtn;
    private String defaultText = "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0442\u0435\u043a\u0441\u0442";
    private ChatData chatData;

    public ChatPanel() {
        Image chatBg = Component.getImage(this.atlas, "chat_bg", 0, 0, 0, 0);
        chatBg.setX(0.0f);
        chatBg.setY(40.0f);
        chatBg.setWidth(352.0f);
        chatBg.setHeight(308.0f);
        this.addActor(chatBg);
        Table input = new Table();
        input.setBackground(this.assets.getNinePatchDrawable(this.atlas, "chat_input_bg", 4, 4, 1, 1));
        input.defaults().space(4.0f);
        input.setPosition(1.0f, 1.0f);
        input.setTransform(true);
        input.pack();
        input.setWidth(350.0f);
        this.addActor(input);
        Table table = new Table();
        table.align(12);
        table.setWidth(346.0f);
        this.addActor(table);
        Label.LabelStyle chatStyle = new Label.LabelStyle();
        chatStyle.font = this.assets.getFont().arialBold16;
        chatStyle.font.getData().markupEnabled = true;
        this.chat = new Label((CharSequence)"", chatStyle);
        this.chat.setWrap(true);
        table.add(this.chat).width(346.0f);
        this.scrollPane = new ScrollPane((Actor)table);
        this.scrollPane.setSize(348.0f, 300.0f);
        this.scrollPane.setY(46.0f);
        this.scrollPane.setX(4.0f);
        this.scrollPane.layout();
        this.scrollPane.setFillParent(false);
        this.scrollPane.setTouchable(Touchable.disabled);
        this.addActor(this.scrollPane);
        TextField.TextFieldStyle style = new TextField.TextFieldStyle();
        style.font = this.assets.getFont().arialBold16;
        style.fontColor = Color.WHITE;
        style.cursor = this.assets.getNinePatchDrawable(this.uiAtlas, "cursor", 1, 1, 1, 1).tint(Color.WHITE);
        style.selection = this.assets.getNinePatchDrawable(this.uiAtlas, "text-field-selection", 1, 1, 1, 1).tint(Color.GOLDENROD);
        final ImageButton sendBtn = Component.getImageButton(this.atlas, "send_btn_up");
        sendBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ChatPanel.this.sendMessage();
            }
        });
        input.add(sendBtn).left();
        this.chatInput = new TextField("", style);
        this.chatInput.setMessageText(this.defaultText);
        input.add(this.chatInput).expandX().fill();
        this.closeBtn = Component.getImageButton(this.atlas, "chat_close_btn");
        input.add(this.closeBtn).right();
        this.closeBtn.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                ChatPanel.this.commander.ChatActionLeave();
            }
        });
        this.chatInput.setTextFieldListener(new TextField.TextFieldListener(){

            @Override
            public void keyTyped(TextField textField, char c) {
                if (c == '\r' || c == '\n') {
                    ChatPanel.this.sendMessage();
                    Gdx.input.setOnscreenKeyboardVisible(false);
                }
                sendBtn.setDisabled(!ChatPanel.this.canSend());
            }
        });
        this.chatInput.addListener(new FocusListener(){

            @Override
            public void keyboardFocusChanged(FocusListener.FocusEvent event, Actor actor, boolean focused) {
                super.keyboardFocusChanged(event, actor, focused);
                if (focused) {
                    ChatPanel.this.scrollPane.setTouchable(Touchable.enabled);
                } else {
                    ChatPanel.this.scrollPane.setTouchable(Touchable.disabled);
                }
                sendBtn.setDisabled(!ChatPanel.this.canSend());
            }
        });
    }

    private void sendMessage() {
        if (this.canSend()) {
            this.commander.ChatAvatarMessage(this.chatInput.getText());
            this.chatInput.setText("");
            this.chatInput.getStage().setKeyboardFocus(null);
        }
    }

    private boolean canSend() {
        return !this.chatInput.getText().isEmpty();
    }

    public void clearText() {
        this.chat.setText("");
    }

    public void updateMessages() {
        if (this.chatData == null) {
            Gdx.app.log(this.getClass().getSimpleName(), "Error chat update");
            return;
        }
        this.chat.setText(this.chatData.getText());
        this.scrollPane.layout();
        this.scrollPane.setScrollY(this.chat.getHeight());
    }

    public void setChatData(ChatData chatData) {
        this.chatData = chatData;
    }
}

