/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.hud;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.Component;
import com.tpwar.game.utils.GroupUtil;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.exchanger.ExchangerWindow;

public class EnergyPanel
extends Group {
    private final Assets assets = Assets.getInstance();
    private final TextureAtlas atlas = (TextureAtlas)this.assets.get("ui/hud.atlas");
    private Image bg = Component.getImage(this.atlas, "energy_add_bg");
    private Label label;
    private ImageButton addBtn;

    public EnergyPanel() {
        this.addActor(this.bg);
        Label.LabelStyle style = new Label.LabelStyle();
        style.font = this.assets.getFont().arialBold16;
        style.fontColor = Color.WHITE;
        this.label = new Label((CharSequence)"", style);
        this.label.setX(29.0f);
        this.label.setY((this.bg.getHeight() - this.label.getHeight()) / 2.0f - 1.0f);
        this.addActor(this.label);
        this.addBtn = Component.getImageButton(this.atlas, "add_btn");
        this.addBtn.setX(this.bg.getWidth() - this.addBtn.getWidth() - 3.0f);
        this.addBtn.setY(3.0f);
        this.addActor(this.addBtn);
        this.setSize(GroupUtil.getWidth(this), GroupUtil.getHeight(this));
        this.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                WindowManager.getInstance().open(new ExchangerWindow());
            }
        });
    }

    public void setEnergy(int energy) {
        if (energy >= 100000) {
            this.label.setText(energy / 1000 + "k");
        } else {
            this.label.setText(String.valueOf(energy));
        }
    }
}

