/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.hud;

import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.Timer;
import com.tpwar.domain.Model;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.gift.GiftSelectWindow;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import com.tpwar.net.Commander;
import net.dermetfan.gdx.graphics.g2d.AnimatedSprite;
import packet.Transport;

public class GiftButton
extends Actor
implements Disposable {
    private final Assets assets = Assets.getInstance();
    private AnimatedSprite animatedSprite;
    private Timer.Task animationTimer;

    public GiftButton() {
        TextureAtlas atlas = (TextureAtlas)this.assets.get("ui/hud.atlas");
        Animation<TextureRegion> animation = new Animation<TextureRegion>(0.045454547f, this.assets.extractRegions(atlas, "gift_icon"));
        animation.setPlayMode(Animation.PlayMode.NORMAL);
        this.animatedSprite = new AnimatedSprite(animation);
        this.animatedSprite.setCenterFrames(true);
        this.animatedSprite.setOrigin(0.0f, 0.0f);
        this.animatedSprite.stop();
        this.animationTimer = Timer.schedule(new Timer.Task(){

            @Override
            public void run() {
                GiftButton.this.animatedSprite.setTime(0.0f);
                GiftButton.this.animatedSprite.play();
            }
        }, 3.0f, 8.0f);
        this.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                MessageListener messageListener = new MessageListener(){

                    @Override
                    public void handleMessage(int code, Object data, Transport.Packet msg) {
                        WindowManager.getInstance().open(new GiftSelectWindow());
                        Model.getInstance().removeListeners(this);
                    }
                };
                Model.getInstance().addListener(messageListener, Cmd.GiftList.getCode());
                Commander.getInstance().GetGiftList();
            }
        });
        this.setSize(this.animatedSprite.getWidth(), this.animatedSprite.getHeight());
    }

    @Override
    public void setScale(float scaleXY) {
        this.animatedSprite.setScale(scaleXY);
        super.setScale(scaleXY);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.animatedSprite.draw(batch, parentAlpha);
    }

    @Override
    public void dispose() {
        this.animationTimer.cancel();
    }

    @Override
    public void setX(float x) {
        this.animatedSprite.setX(x);
        super.setX(x);
    }

    @Override
    public void setY(float y) {
        this.animatedSprite.setY(y);
        super.setY(y);
    }
}

