/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.hud;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.tpwar.domain.Model;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.StringUtils;
import com.tpwar.storage.Storage;
import com.tpwar.storage.planet.PlanetData;
import packet.Static;

public class Location
extends Table {
    private final Assets assets = Assets.getInstance();
    private final Model model = Model.getInstance();
    private final Storage storage = Storage.getInstance();
    private Label location;

    public Location() {
        this.setBackground(this.assets.getNinePatchDrawable(this.assets.getCommonAtlas(), "blurred_background", 51, 51, 0, 0));
        Label.LabelStyle style = new Label.LabelStyle(this.assets.getFont().arialBold16, Color.WHITE);
        style.font.getData().markupEnabled = true;
        this.location = new Label((CharSequence)"", style);
        this.location.setAlignment(1);
        this.add(this.location);
        this.setTransform(true);
    }

    public void showLocation(long planetId, long zoneId) {
        PlanetData planet = this.storage.planet.get(planetId);
        Static.StaticZone zone = this.storage.zone.get(zoneId);
        String locationName = planet.name + " - " + zone.getPosition();
        this.location.setText(StringUtils.mark(locationName, this.storage.faction.getColor(planet.factionId)));
        this.clearActions();
        this.getColor().a = 0.0f;
        this.pack();
        SequenceAction action = Actions.sequence((Action)Actions.alpha(1.0f, 0.8f), (Action)Actions.delay(0.8f), (Action)Actions.alpha(0.0f, 0.8f), (Action)Actions.removeActor());
        this.addAction(action);
    }
}

