/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.hud;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Disposable;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.events.EventListener;
import com.tpwar.game.display.Resizeble;
import com.tpwar.game.hud.AvatarProfile;
import com.tpwar.game.hud.ButtonWithMark;
import com.tpwar.game.hud.ChatPanel;
import com.tpwar.game.hud.CrystalPanel;
import com.tpwar.game.hud.EnergyPanel;
import com.tpwar.game.hud.ExpandAction;
import com.tpwar.game.hud.GiftButton;
import com.tpwar.game.hud.Location;
import com.tpwar.game.hud.RollUpAction;
import com.tpwar.game.hud.TimerWithBackground;
import com.tpwar.game.hud.UnitsPanel;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.Component;
import com.tpwar.game.utils.ScaleScreen;
import com.tpwar.game.windows.GameWindow;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.arena.ArenaWindow;
import com.tpwar.game.windows.chat.SelectChatWindow;
import com.tpwar.game.windows.clan.ClanTopWindow;
import com.tpwar.game.windows.clan.ClanWindow;
import com.tpwar.game.windows.massage.MessageWindow;
import com.tpwar.game.windows.profile.AvatarWindow;
import com.tpwar.game.windows.quest.QuestWindow;
import com.tpwar.game.windows.rating.RatingWindow;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import com.tpwar.net.Commander;
import com.tpwar.platform.SizeChangeListener;
import com.tpwar.sound.SoundSystem;
import com.tpwar.storage.Storage;
import com.tpwar.storage.planet.PlanetData;
import packet.Clan;
import packet.Rating;
import packet.Static;
import packet.Transport;

public class MapHud
extends Group
implements Resizeble,
SizeChangeListener,
MessageListener,
Disposable {
    private static final double KEYBOARD_MIN_HEIGHT_RATIO = 0.15;
    private final Assets assets = Assets.getInstance();
    private final TextureAtlas atlas = (TextureAtlas)this.assets.get("ui/hud.atlas");
    private final Model model = Model.getInstance();
    private final Storage storage = Storage.getInstance();
    private final WindowManager windowManager = WindowManager.getInstance();
    private final SoundSystem soundSystem = SoundSystem.getInstance();
    private final Commander commander = Commander.getInstance();
    public AvatarProfile profile;
    public CrystalPanel crystalPanel;
    public EnergyPanel energyPanel;
    public UnitsPanel unitsPanel;
    public ChatPanel chatPanel;
    public Button profileBtn;
    public ButtonWithMark msgBtn;
    public ButtonWithMark clanBtn;
    public Button ratingBtn;
    public Button chatBtn;
    public TimerWithBackground timer;
    private long timeEnd = 0L;
    private boolean needUpdateTimer = false;
    private float timerDelta = 0.0f;
    private Button arrowBtn;
    private boolean buttonsHide;
    private float profileX;
    private RollUpAction rollUpAction;
    private ExpandAction expandAction;
    private ImageButton questButton;
    private ImageButton arenaButton;
    private GiftButton giftButton;
    private Location location;
    private EventListener<GameWindow> closeWindowListener;

    public MapHud() {
        final AvatarData avatar = this.model.player.selectedAvatar;
        this.profile = new AvatarProfile();
        this.profile.setX(2.0f);
        this.profile.getAvatarName().setColor(Color.WHITE);
        this.profile.updateClanTag();
        this.addActor(this.profile);
        this.crystalPanel = new CrystalPanel();
        this.addActor(this.crystalPanel);
        this.energyPanel = new EnergyPanel();
        this.addActor(this.energyPanel);
        this.unitsPanel = new UnitsPanel();
        this.addActor(this.unitsPanel);
        Static.StaticFaction faction = this.storage.faction.get(avatar.fractionId);
        this.questButton = Component.getImageButton(this.atlas, this.storage.faction.isOseon(faction.getCode()) ? "mission_oseon_btn" : "mission_wayland_btn");
        this.questButton.setTransform(true);
        this.questButton.addCaptureListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (avatar.quests.notEmpty()) {
                    MapHud.this.windowManager.open(new QuestWindow(avatar.quests.first()));
                }
            }
        });
        this.addActor(this.questButton);
        ImageButton.ImageButtonStyle arenaBtnStyle = new ImageButton.ImageButtonStyle();
        arenaBtnStyle.up = this.assets.getDrawable(this.atlas, "arena_btn_up");
        arenaBtnStyle.down = this.assets.getDrawable(this.atlas, "arena_btn_down");
        this.arenaButton = new ImageButton(arenaBtnStyle);
        this.arenaButton.setTransform(true);
        this.arenaButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                MapHud.this.windowManager.open(new ArenaWindow());
            }
        });
        this.giftButton = new GiftButton();
        this.updateGift();
        this.chatPanel = new ChatPanel();
        this.chatPanel.setX(Gdx.graphics.getSafeInsetLeft());
        ButtonWithMark.ButtonWithMarkStyle msgBtnStyle = new ButtonWithMark.ButtonWithMarkStyle();
        msgBtnStyle.up = this.assets.getDrawable(this.atlas, "msg_btn0001");
        msgBtnStyle.down = this.assets.getDrawable(this.atlas, "msg_btn0003");
        msgBtnStyle.mark = this.assets.getDrawable(this.atlas, "new_mark");
        this.msgBtn = new ButtonWithMark(msgBtnStyle);
        this.msgBtn.setTransform(true);
        this.msgBtn.setY(16.0f);
        this.addActor(this.msgBtn);
        this.msgBtn.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                MapHud.this.windowManager.open(new MessageWindow());
            }
        });
        if (avatar.newMessageNum > 0) {
            this.msgBtn.mark();
        }
        ButtonWithMark.ButtonWithMarkStyle clanBtnStyle = new ButtonWithMark.ButtonWithMarkStyle();
        clanBtnStyle.up = this.assets.getDrawable(this.atlas, "clan_btn0001");
        clanBtnStyle.down = this.assets.getDrawable(this.atlas, "clan_btn0003");
        clanBtnStyle.mark = this.assets.getDrawable(this.atlas, "new_mark");
        this.clanBtn = new ButtonWithMark(clanBtnStyle);
        this.clanBtn.setTransform(true);
        this.clanBtn.setY(16.0f);
        this.addActor(this.clanBtn);
        this.clanBtn.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (avatar.clanId > 0L) {
                    MapHud.this.commander.GetClanData(avatar.clanId);
                } else {
                    MapHud.this.commander.GetClanList();
                }
            }
        });
        this.closeWindowListener = new EventListener<GameWindow>(){

            @Override
            public void onEvent(int type, GameWindow data) {
                if (data instanceof MessageWindow) {
                    MapHud.this.msgBtn.unmark();
                } else if (data instanceof ClanTopWindow) {
                    MapHud.this.clanBtn.unmark();
                }
            }
        };
        this.windowManager.addListener(2, this.closeWindowListener);
        this.ratingBtn = Component.getImageButton(this.atlas, "rating_btn");
        this.ratingBtn.setTransform(true);
        this.ratingBtn.setY(16.0f);
        this.addActor(this.ratingBtn);
        this.ratingBtn.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                MapHud.this.commander.GetGameRating();
            }
        });
        this.chatBtn = Component.getImageButton(this.atlas, "chat_btn");
        this.chatBtn.setTransform(true);
        this.chatBtn.setX(Gdx.graphics.getSafeInsetLeft());
        this.chatBtn.setY(16.0f);
        this.addActor(this.chatBtn);
        this.chatBtn.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                SelectChatWindow wnd = new SelectChatWindow();
                MapHud.this.windowManager.open(wnd, true);
            }
        });
        this.profileBtn = Component.getImageButton(this.atlas, "profile_btn");
        this.profileBtn.setTransform(true);
        this.profileBtn.setY(5.0f);
        this.addActor(this.profileBtn);
        this.profileBtn.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                MapHud.this.windowManager.open(new AvatarWindow());
            }
        });
        this.arrowBtn = Component.getImageButton(this.atlas, "arrow_btn");
        this.arrowBtn.setTransform(true);
        this.addActor(this.arrowBtn);
        this.arrowBtn.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                MapHud.this.touchArrowMenu();
            }
        });
        this.buttonsHide = false;
        this.rollUpAction = new RollUpAction();
        this.rollUpAction.add(this.msgBtn, this.clanBtn, this.chatBtn, this.ratingBtn);
        this.rollUpAction.setInterpolation(Interpolation.sineOut);
        this.rollUpAction.setDuration(0.5f);
        this.expandAction = new ExpandAction();
        this.expandAction.add(this.ratingBtn, this.chatBtn, this.clanBtn, this.msgBtn);
        this.expandAction.setInterpolation(Interpolation.sineOut);
        this.expandAction.setDuration(0.5f);
        BitmapFont font = (BitmapFont)this.assets.get("fonts/centry_gothic_bold_25.fnt");
        this.timer = new TimerWithBackground(font, Color.GOLD);
        this.timer.setTouchable(Touchable.disabled);
        this.location = new Location();
        this.location.setTouchable(Touchable.disabled);
        this.model.addListener(this, Cmd.GameRating.getCode());
        this.model.addListener(this, Cmd.GiftList.getCode());
        this.model.addListener(this, Cmd.AvatarMessage.getCode());
        this.model.addListener(this, Cmd.AvatarUpdate.getCode());
        this.model.addListener(this, Cmd.ClanList.getCode());
        this.model.addListener(this, Cmd.ClanData.getCode());
    }

    public void showLocation(long planetId, long zoneId) {
        boolean arenaIsAvail;
        this.addActor(this.location);
        this.location.showLocation(planetId, zoneId);
        float scale = ScaleScreen.getScale();
        this.location.setX(((float)Gdx.graphics.getBackBufferWidth() - this.location.getWidth() * scale) / 2.0f);
        PlanetData planetData = this.storage.planet.get(planetId);
        AvatarData avatarData = this.model.player.selectedAvatar;
        boolean bl = arenaIsAvail = this.storage.planet.isHomePlanet(planetData) && planetData.factionId == avatarData.fractionId && avatarData.level >= 3;
        if (!this.arenaButton.hasParent() && arenaIsAvail) {
            this.addActor(this.arenaButton);
        } else if (this.arenaButton.hasParent() && !arenaIsAvail) {
            this.arenaButton.remove();
        }
    }

    public void touchArrowMenu() {
        if (this.profileBtn.hasActions()) {
            return;
        }
        SequenceAction action = Actions.sequence();
        this.arrowBtn.getColor().a = 0.0f;
        final float scale = ScaleScreen.getScale();
        if (this.buttonsHide) {
            this.expandAction.setPosition(this.profileX, this.profileBtn.getY());
            action.addAction(this.expandAction);
            action.addAction(Actions.run(new Runnable(){

                @Override
                public void run() {
                    MapHud.this.arrowBtn.setX((float)Gdx.graphics.getWidth() / 2.0f + (MapHud.this.profileBtn.getWidth() - 40.0f) * scale);
                    MapHud.this.arrowBtn.setScale(scale);
                    MapHud.this.arrowBtn.addAction(Actions.fadeIn(0.1f));
                    MapHud.this.addActor(MapHud.this.arrowBtn);
                }
            }));
        } else {
            this.rollUpAction.setPosition(this.ratingBtn.getX() + (this.profileBtn.getWidth() - this.ratingBtn.getWidth()) / 2.0f * scale, this.profileBtn.getY());
            action.addAction(this.rollUpAction);
            action.addAction(Actions.run(new Runnable(){

                @Override
                public void run() {
                    MapHud.this.arrowBtn.setX(MapHud.this.profileBtn.getX() - (MapHud.this.arrowBtn.getWidth() / 2.0f - 14.0f) * scale);
                    MapHud.this.arrowBtn.setScaleY(scale);
                    MapHud.this.arrowBtn.setScaleX(scale * -1.0f);
                    MapHud.this.arrowBtn.addAction(Actions.fadeIn(0.1f));
                    MapHud.this.addActor(MapHud.this.arrowBtn);
                }
            }));
        }
        this.buttonsHide = !this.buttonsHide;
        this.profileBtn.addAction(action);
    }

    @Override
    public void handleMessage(int code, Object data, Transport.Packet msg) throws InvalidProtocolBufferException {
        Cmd cmd = Cmd.Enums.byInt(code);
        switch (cmd) {
            case GameRating: {
                RatingWindow wnd = new RatingWindow(Rating.GameRating.parseFrom(msg.getData()));
                this.windowManager.open(wnd);
                break;
            }
            case GiftList: {
                this.updateGift();
                break;
            }
            case AvatarMessage: {
                this.msgBtn.mark();
                this.soundSystem.fx.play("sound/fx/6. Mail_Incoming.mp3");
                break;
            }
            case AvatarUpdate: {
                this.profile.updateClanTag();
                break;
            }
            case ClanList: {
                ClanTopWindow clanTopWnd = new ClanTopWindow(Clan.ClanList.parseFrom(msg.getData()));
                this.windowManager.open(clanTopWnd);
                break;
            }
            case ClanData: {
                ClanWindow clanWnd = new ClanWindow(Clan.ClanDto.parseFrom(msg.getData()));
                this.windowManager.open(clanWnd);
                break;
            }
        }
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (this.needUpdateTimer) {
            this.timerDelta += delta;
            if (this.timerDelta > 1.0f) {
                this.timerDelta -= 1.0f;
                this.updateTimer();
            }
        }
    }

    public void setTimer(long timeEnd, long totalTime) {
        if (totalTime <= 0L) {
            if (this.timer.hasParent()) {
                this.timer.remove();
            }
            this.needUpdateTimer = false;
        } else {
            this.addActor(this.timer);
            this.timeEnd = timeEnd;
            this.needUpdateTimer = true;
            this.updateTimer();
        }
    }

    private void updateTimer() {
        long currentTime = this.model.getServerTime();
        long timeLeft = this.timeEnd - currentTime;
        this.timer.update(timeLeft);
        if (timeLeft <= 0L) {
            this.setTimer(0L, 0L);
        }
    }

    public void updateGift() {
        if (this.model.player.gifts.size > 0) {
            this.addActor(this.giftButton);
        } else {
            this.giftButton.remove();
        }
    }

    public void leftChat() {
        this.chatPanel.clearText();
        this.removeActor(this.chatPanel);
        this.getStage().setKeyboardFocus(null);
        Gdx.input.setOnscreenKeyboardVisible(false);
    }

    public void joinChat() {
        this.chatPanel.updateMessages();
        this.addActor(this.chatPanel);
    }

    public boolean chatVisible() {
        return this.chatPanel.hasParent();
    }

    public void unfocusChat() {
        this.getStage().setKeyboardFocus(null);
    }

    public void chatMessage() {
        this.chatPanel.updateMessages();
    }

    @Override
    public void onSizeChange(float width, float height) {
        boolean isOpen;
        int screenHeight = Gdx.graphics.getBackBufferHeight();
        float heightDiff = (float)screenHeight - height;
        boolean bl = isOpen = (double)heightDiff > (double)screenHeight * 0.15;
        if (isOpen && this.windowManager.hasOpenedWindow()) {
            return;
        }
        if (isOpen || (float)screenHeight == height) {
            this.chatPanel.setY((float)Gdx.graphics.getBackBufferHeight() - height);
        }
    }

    @Override
    public void resize(int width, int height) {
        float scale = ScaleScreen.getScale();
        this.profile.setScale(scale);
        this.profile.setY((float)height - this.profile.getHeight() * scale - 1.0f);
        this.unitsPanel.setScale(scale);
        this.unitsPanel.setY((float)height - 48.0f * scale);
        this.unitsPanel.setX((float)width * 0.68f);
        this.energyPanel.setScale(scale);
        this.energyPanel.setY(this.unitsPanel.getY());
        this.energyPanel.setX((float)width * 0.53f);
        this.crystalPanel.setScale(scale);
        this.crystalPanel.setY(this.unitsPanel.getY());
        this.crystalPanel.setX((float)width * 0.36f);
        float offsetY = (float)height - this.questButton.getHeight() * scale - 54.0f * scale;
        if (this.giftButton.hasParent()) {
            this.giftButton.setScale(scale);
            this.giftButton.setX((float)width - this.giftButton.getWidth() * scale - 11.0f * scale);
            offsetY = (float)height - this.giftButton.getHeight() * scale - 54.0f * scale;
            this.giftButton.setY(offsetY);
            offsetY = this.giftButton.getY() - this.questButton.getHeight() * scale - 10.0f * scale;
        }
        this.questButton.setScale(scale);
        this.questButton.setX((float)width - this.questButton.getWidth() * scale - 15.0f * scale);
        this.questButton.setY(offsetY);
        this.arenaButton.setScale(scale);
        this.arenaButton.setX((float)width - this.arenaButton.getWidth() * scale - 12.0f * scale);
        this.arenaButton.setY(this.questButton.getY() - this.arenaButton.getHeight() * scale - 10.0f * scale);
        this.ratingBtn.setX((float)width * 0.92f);
        this.profileX = ((float)width - this.profileBtn.getWidth() * scale) / 2.0f;
        this.msgBtn.setScale(scale);
        this.msgBtn.setX((float)width * 0.63f);
        this.clanBtn.setScale(scale);
        this.clanBtn.setX((float)width * 0.72f);
        this.chatBtn.setScale(scale);
        this.chatBtn.setX((float)width * 0.81f);
        this.ratingBtn.setScale(scale);
        this.ratingBtn.setX((float)width * 0.9f);
        this.profileBtn.setScale(scale);
        if (this.buttonsHide) {
            this.profileBtn.setX(this.ratingBtn.getX() + (this.profileBtn.getWidth() - this.ratingBtn.getWidth()) / 2.0f * scale);
            this.arrowBtn.setX(this.profileBtn.getX() - (this.arrowBtn.getWidth() / 2.0f - 14.0f) * scale);
            this.arrowBtn.setScaleY(scale);
            this.arrowBtn.setScaleX(scale * -1.0f);
        } else {
            this.profileBtn.setX(this.profileX);
            this.arrowBtn.setX((float)width / 2.0f + (this.profileBtn.getWidth() - 40.0f) * scale);
            this.arrowBtn.setScale(scale);
        }
        this.arrowBtn.setY(16.0f * scale);
        this.timer.setScale(scale);
        this.timer.setX(((float)width - this.timer.getWidth() * scale) / 2.0f);
        this.timer.setY(this.profileBtn.getY() + (this.profileBtn.getHeight() + 4.0f) * scale);
        this.location.setScale(scale);
        this.location.setX(((float)width - this.timer.getWidth() * scale) / 2.0f);
        this.location.setY((float)height - this.profile.getHeight() * scale);
        this.chatPanel.setScale(scale);
    }

    public void eventMessage() {
        this.chatPanel.updateMessages();
    }

    @Override
    public void dispose() {
        this.giftButton.dispose();
        this.windowManager.removeListener(this.closeWindowListener);
        this.model.removeListeners(this);
    }

    public boolean isButtonsHide() {
        return this.buttonsHide;
    }
}

