/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.hud;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.utils.LongMap;
import com.tpwar.game.maps.entity.Avatar;
import com.tpwar.game.utils.ScaleScreen;

public class TargetIndicator
extends Actor {
    private final Stage ui;
    private final Camera camera;
    private final Avatar avatar;
    private float viewportWidth;
    private float viewportHeight;
    private final LongMap<TargetData> targets = new LongMap();
    private final Group labelGroup;
    private final Label label;
    private final Vector3 avatarPos = new Vector3();
    private final Vector3 target = new Vector3();

    public TargetIndicator(Stage ui, Camera camera, Avatar avatar) {
        this.ui = ui;
        this.camera = camera;
        this.avatar = avatar;
        BitmapFont font = new BitmapFont();
        Label.LabelStyle labelStyle = new Label.LabelStyle(font, Color.WHITE);
        this.label = new Label((CharSequence)"", labelStyle);
        this.label.setTouchable(Touchable.disabled);
        this.label.setAlignment(1);
        this.labelGroup = new Group();
        this.labelGroup.addActor(this.label);
        this.setTouchable(Touchable.disabled);
    }

    @Override
    public void clear() {
        this.targets.clear();
    }

    public void addTarget(long id, Vector2 position, String text) {
        this.targets.put(id, new TargetData(position.cpy(), text));
    }

    public void removeTarget(long id) {
        this.targets.remove(id);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.avatarPos.set(this.avatar.getX(), this.avatar.getY(), 0.0f);
        this.camera.project(this.avatarPos);
        this.ui.getCamera().unproject(this.avatarPos);
        this.avatarPos.y = this.viewportHeight - this.avatarPos.y;
        for (LongMap.Entry<TargetData> entry : this.targets) {
            float ay;
            float ax;
            boolean targetIsVisible;
            TargetData targetData = (TargetData)entry.value;
            this.target.set(targetData.position.x, targetData.position.y, 0.0f);
            this.camera.project(this.target);
            this.ui.getCamera().unproject(this.target);
            this.target.y = this.viewportHeight - this.target.y;
            boolean bl = targetIsVisible = this.target.x > 0.0f && this.target.x < this.viewportWidth && this.target.y > 0.0f && this.target.y < this.viewportHeight;
            if (targetIsVisible) continue;
            Vector2 direction = new Vector2(this.target.x - this.avatarPos.x, this.target.y - this.avatarPos.y).nor();
            float scale = ScaleScreen.getScale();
            float padding = 80.0f * scale;
            if (direction.x == 0.0f) {
                ax = this.avatarPos.x;
                ay = direction.y > 0.0f ? this.viewportHeight - padding : padding;
            } else if (direction.y == 0.0f) {
                ax = direction.x > 0.0f ? this.viewportWidth - padding : padding;
                ay = this.avatarPos.y;
            } else {
                float intercept;
                float slope = direction.y / direction.x;
                ax = direction.x > 0.0f ? this.viewportWidth - padding : padding;
                ay = slope * ax + (intercept = this.avatarPos.y - slope * this.avatarPos.x);
                if (ay < padding || ay > this.viewportHeight - padding) {
                    ay = direction.y > 0.0f ? this.viewportHeight - padding : padding;
                    ax = (ay - intercept) / slope;
                }
            }
            ax = Math.max(padding, Math.min(ax, this.viewportWidth - padding));
            ay = Math.max(padding, Math.min(ay, this.viewportHeight - padding));
            this.label.setText(targetData.text);
            this.labelGroup.setPosition(ax, ay);
            this.labelGroup.setScale(scale);
            this.label.setColor(1.0f, 1.0f, 1.0f, 0.7f);
            this.labelGroup.draw(batch, parentAlpha);
        }
    }

    public void resize() {
        this.viewportWidth = this.ui.getCamera().viewportWidth;
        this.viewportHeight = this.ui.getCamera().viewportHeight;
    }

    static class TargetData {
        public final Vector2 position;
        public final String text;

        public TargetData(Vector2 position, String text) {
            this.position = position;
            this.text = text;
        }
    }
}

