/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.hud;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.tpwar.domain.Model;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.unit.UnitsWindow;

public class UnitsPanel
extends Button {
    private final Model model = Model.getInstance();
    private final Assets assets = Assets.getInstance();
    private final TextureAtlas atlas = (TextureAtlas)this.assets.get("ui/hud.atlas");
    private Label label;

    public UnitsPanel() {
        this.setTransform(true);
        this.setStyle(new Button.ButtonStyle());
        this.getStyle().up = this.assets.getNinePatchDrawable(this.atlas, "army_add_bg", 15, 0, 0, 2);
        Label.LabelStyle style = new Label.LabelStyle();
        style.font = this.assets.getFont().arialBold16;
        style.fontColor = Color.WHITE;
        this.label = new Label((CharSequence)"", style);
        this.label.setAlignment(1);
        this.add(this.label).expandX().width(80.0f).right().padRight(4.0f);
        this.pack();
        this.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                WindowManager.getInstance().open(new UnitsWindow());
            }
        });
    }

    public void setNumUnit(int num) {
        this.label.setText(this.model.lang.format("unit", num));
    }
}

