/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.managers;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.ObjectMap;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.avatar.AvatarQuestGoal;
import com.tpwar.game.maps.Tpmap;
import com.tpwar.game.maps.entity.AvatarSkin;
import com.tpwar.game.maps.entity.ModifiedSkin20;
import com.tpwar.game.maps.entity.OtherAvatar;
import com.tpwar.game.maps.entity.Skin;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.net.Commander;
import com.tpwar.storage.Storage;
import com.tpwar.storage.planet.PlanetData;
import packet.Static;

public class AvatarManager
implements Disposable {
    private final Assets assets = Assets.getInstance();
    private final Storage storage = Storage.getInstance();
    private Tpmap map;
    private ObjectMap<Long, OtherAvatar> avatarMap;

    public AvatarManager() {
    }

    public AvatarManager(Tpmap map) {
        this();
        this.map = map;
        this.avatarMap = new ObjectMap();
    }

    public static void attack(final AvatarData target) {
        Storage storage = Storage.getInstance();
        Model model = Model.getInstance();
        final Commander commander = Commander.getInstance();
        WindowManager windowManager = WindowManager.getInstance();
        AvatarData avatar = model.player.selectedAvatar;
        PlanetData planetData = storage.planet.get(avatar.planetId);
        if (!storage.planet.isGatePlanet(planetData) && !storage.planet.isHomePlanet(planetData)) {
            if (target.shield > model.getServerTime()) {
                String text = model.lang.format("window.shield.description", target.name);
                WarningWindow wnd = new WarningWindow(WarningWindow.Type.INFO, model.lang.get("window.shield"), text, model.lang.get("window.confirm.ok"));
                windowManager.open(wnd, true);
                return;
            }
            if (target.playerId > 0L && avatar.shield > model.getServerTime()) {
                String text = "\u0412\u0430\u0448 \u0449\u0438\u0442 \u043f\u0435\u0440\u0435\u0441\u0442\u0430\u043d\u0435\u0442 \u0434\u0435\u0439\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0435\u0441\u043b\u0438 \u0432\u044b \u0430\u0442\u0430\u043a\u0443\u0435\u0442\u0435 \u0438\u0433\u0440\u043e\u043a\u0430 \u043d\u0430 \u044d\u0442\u043e\u0439 \u043f\u043b\u0430\u043d\u0435\u0442\u0435, \u0430\u0442\u0430\u043a\u043e\u0432\u0430\u0442\u044c?";
                WarningWindow wnd = new WarningWindow(WarningWindow.Type.INFO, model.lang.get("window.shield"), text, "\u0414\u0430", new ClickListener(){

                    @Override
                    public void clicked(InputEvent event, float x, float y) {
                        commander.AvatarActionAttack(target.id);
                    }
                });
                windowManager.open(wnd, true);
                return;
            }
        }
        commander.AvatarActionAttack(target.id);
    }

    public OtherAvatar updateQuestGoal(AvatarQuestGoal goal) {
        OtherAvatar otherAvatar = this.avatarMap.get(goal.point);
        if (otherAvatar != null) {
            otherAvatar.avatar.treasureId = Integer.MAX_VALUE;
            otherAvatar.updateTreasureMap();
            return otherAvatar;
        }
        return null;
    }

    public void create(Array<AvatarData> avatars, long selectedAvatarId) {
        for (AvatarData a : avatars) {
            this.create(a, selectedAvatarId);
        }
    }

    public void create(AvatarData avatar, long selectedAvatarId) {
        if (avatar.id == selectedAvatarId) {
            return;
        }
        OtherAvatar player = this.avatarMap.get(avatar.id);
        if (player != null) {
            avatar.position = player.avatar.position;
            player.avatar = avatar;
            player.updateData();
            return;
        }
        player = new OtherAvatar(avatar, this.map, this.getAvatarSkin(avatar));
        this.avatarMap.put(avatar.id, player);
        this.map.addEntity(player);
        this.map.sortObjects();
    }

    public void move(long avatarId, int position) {
        OtherAvatar player = this.avatarMap.get(avatarId);
        if (player != null) {
            player.addPosition(position);
        }
    }

    public void removeAvatar(AvatarData avatar) {
        this.removeAvatar(avatar.id);
    }

    public void removeAvatar(long id) {
        OtherAvatar player = this.avatarMap.remove(id);
        if (player != null) {
            this.map.removeEntity(player);
            player.dispose();
        }
    }

    public void removeAllAvatars() {
        for (OtherAvatar p : this.avatarMap.values()) {
            this.map.removeEntity(p);
            p.dispose();
        }
        this.avatarMap.clear();
    }

    public Skin getAvatarSkin(AvatarData avatar) {
        Static.StaticFaction fraction = this.storage.faction.get(avatar.fractionId);
        if (Model.getInstance().isItAprilFoolsDay()) {
            int random = MathUtils.random(1, 25);
            String resourceName = "entity/" + random + ".png";
            if (!this.assets.isLoaded(resourceName)) {
                this.assets.loadExtraSkin();
            }
            return new ModifiedSkin20(this.split((Texture)this.assets.get(resourceName)));
        }
        return new AvatarSkin((TextureAtlas)this.assets.get("entity/" + avatar.getImageName() + ".atlas"), avatar.skin);
    }

    private Array<TextureRegion> split(Texture texture) {
        TextureRegion[][] tmp = TextureRegion.split(texture, 48, 64);
        Array<TextureRegion> frames = new Array<TextureRegion>();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                frames.add(tmp[i][j]);
            }
        }
        return frames;
    }

    public Array<AvatarData> getAvatarsByPosition(int position) {
        Array<AvatarData> result = new Array<AvatarData>();
        for (OtherAvatar p : this.avatarMap.values()) {
            if (p.avatar.position != position) continue;
            result.add(p.avatar);
        }
        return result;
    }

    public ObjectMap<Long, OtherAvatar> getAvatarMap() {
        return this.avatarMap;
    }

    @Override
    public void dispose() {
        this.removeAllAvatars();
    }
}

