/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.managers;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.ObjectMap;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.avatar.BattleMarkData;
import com.tpwar.game.maps.Tpmap;
import com.tpwar.game.maps.entity.BattleFlag;
import com.tpwar.game.utils.Assets;
import java.util.Calendar;

public class BattleFlagManager
implements Disposable {
    private final Assets assets = Assets.getInstance();
    private final TextureAtlas atlas;
    private final Tpmap map;
    private ObjectMap<Long, BattleFlag> battleFlagsMap = new ObjectMap();

    public BattleFlagManager(Tpmap map) {
        this.map = map;
        this.atlas = (TextureAtlas)this.assets.get("entity/entity_elements.atlas");
    }

    public void create(Array<BattleMarkData> flags) {
        for (BattleMarkData fmd : flags) {
            this.create(fmd);
        }
    }

    public void create(BattleMarkData battle) {
        AvatarData avatar;
        if (battle == null) {
            return;
        }
        BattleFlag flag = this.battleFlagsMap.get(battle.id);
        if (flag != null) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(10, -1);
        if (battle.timeStart.before(calendar.getTime()) && !(avatar = Model.getInstance().player.selectedAvatar).isAdmin()) {
            return;
        }
        flag = new BattleFlag(battle, this.atlas.findRegion("battle_flag"));
        this.map.addEntity(flag);
        this.battleFlagsMap.put(battle.id, flag);
    }

    public Array<BattleMarkData> getFlags(int position) {
        Array<BattleMarkData> flags = new Array<BattleMarkData>();
        for (BattleFlag f : this.battleFlagsMap.values()) {
            if (f.battle.position != position) continue;
            flags.add(f.battle);
        }
        return flags;
    }

    public void remove(long id) {
        if (this.battleFlagsMap.containsKey(id)) {
            BattleFlag flag = this.battleFlagsMap.remove(id);
            this.map.removeEntity(flag);
        }
    }

    public void removeAll() {
        for (BattleFlag f : this.battleFlagsMap.values()) {
            this.map.removeEntity(f);
            this.battleFlagsMap.remove(f.battle.id);
        }
    }

    @Override
    public void dispose() {
        this.removeAll();
    }
}

