/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.managers;

import com.badlogic.gdx.utils.Array;
import com.tpwar.domain.avatar.BuildingData;
import com.tpwar.game.maps.Tpmap;
import com.tpwar.game.maps.buildings.Barrack;
import com.tpwar.game.maps.buildings.Building;
import com.tpwar.game.maps.buildings.Citadel;
import com.tpwar.game.maps.buildings.Gate;
import com.tpwar.game.maps.buildings.Mine;
import com.tpwar.game.maps.buildings.Portal;
import com.tpwar.game.maps.buildings.Workshop;
import com.tpwar.game.maps.pathfinding.TiledNode;
import com.tpwar.storage.Storage;
import packet.Static;

public class BuildingManager {
    private Storage storage = Storage.getInstance();
    private Array<Building> buildings = new Array();
    private Tpmap map;

    public BuildingManager(Tpmap map) {
        this.map = map;
    }

    public Building create(long id) {
        Static.StaticBuilding sb = this.storage.building.get(id);
        Static.StaticBuildingType sbt = this.storage.buildingType.get(sb.getBuildingTypeId());
        switch (sbt.getCode()) {
            case "barrack": {
                return new Barrack(sb);
            }
            case "citadel": {
                return new Citadel(sb);
            }
            case "gate": {
                return new Gate(sb);
            }
            case "mine": {
                return new Mine(sb);
            }
            case "portal": {
                return new Portal(sb);
            }
            case "workshop": {
                return new Workshop(sb);
            }
        }
        return null;
    }

    public void create(Array<BuildingData> buildings) {
        for (BuildingData b : buildings) {
            this.add(this.create(b.id));
        }
    }

    public Building getBuilding(TiledNode node) {
        for (Building b : this.buildings) {
            if (!b.inNode(node)) continue;
            return b;
        }
        return null;
    }

    public Building getBuildingByType(String code) {
        for (Building b : this.buildings) {
            Static.StaticBuilding data = b.getData();
            Static.StaticBuildingType type = this.storage.buildingType.get(data.getBuildingTypeId());
            if (!type.getCode().equals(code)) continue;
            return b;
        }
        return null;
    }

    public void add(Building building) {
        this.buildings.add(building);
        this.map.addEntity(building);
        building.applyBorder(this.map);
    }

    public void remove(Building building) {
        this.buildings.removeValue(building, true);
        this.map.removeEntity(building);
    }

    public void removeAll() {
        for (Building b : this.getBuildings()) {
            this.map.removeEntity(b);
        }
        this.buildings.clear();
    }

    public Array<Building> getBuildings() {
        return this.buildings;
    }

    public void updateBuildingStatus(int buildingStatusUsurp) {
        for (Building building : this.buildings) {
            building.updateStatus(buildingStatusUsurp);
        }
    }
}

