/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.managers;

import com.badlogic.gdx.utils.ObjectSet;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.clan.ClanApplicationsWindow;
import com.tpwar.game.windows.clan.ClanInvitationsWindow;
import packet.Clan;

public class ClanManager {
    private final WindowManager windowManager = WindowManager.getInstance();
    private final Model model = Model.getInstance();
    private final ObjectSet<String> invitations = new ObjectSet();
    private final ObjectSet<String> applications = new ObjectSet();

    public void eventInvitationsClan() {
        AvatarData avatarData = this.model.player.selectedAvatar;
        if (avatarData.invitationsClan.notEmpty() && !avatarData.inTutorial()) {
            for (Clan.ClanInvitationDto ic : avatarData.invitationsClan) {
                if (this.invitations.contains(ic.getTag())) {
                    avatarData.invitationsClan.removeValue(ic, true);
                    continue;
                }
                this.invitations.add(ic.getTag());
            }
            if (avatarData.invitationsClan.notEmpty()) {
                this.windowManager.open(new ClanInvitationsWindow(avatarData.invitationsClan), true);
                avatarData.invitationsClan.clear();
            }
        }
    }

    public void eventApplicationsClan() {
        AvatarData avatarData = this.model.player.selectedAvatar;
        if (avatarData.applicationsClan.notEmpty() && !avatarData.inTutorial()) {
            for (Clan.ClanApplicationDto ac : avatarData.applicationsClan) {
                if (this.applications.contains(ac.getName())) {
                    avatarData.applicationsClan.removeValue(ac, true);
                    continue;
                }
                this.applications.add(ac.getName());
            }
            if (avatarData.applicationsClan.notEmpty()) {
                this.windowManager.open(new ClanApplicationsWindow(avatarData.applicationsClan), true);
                avatarData.applicationsClan.clear();
            }
        }
    }
}

