/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.managers;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.player.PlayerData;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.bank.BankWindow;
import com.tpwar.game.windows.warning.WarningWindow;

public class FinanceManager {
    public static final int PRICE_UNITS = 20;
    public static final int PRICE_AVATAR_SLOT_STEP = 25;
    public static final int PRICE_RESET_UPGRADE_POINTS = 125;
    public static final int PRICE_TIME_WARP = 20;
    public static final int PRICE_CREATE_CLAN = 100;
    public static final float CLAN_LEAVE_ENERGY_PERCENT = 0.7f;
    public static final int PRICE_ARTEFACT_SLOT_2_PRICE = 50;
    public static final int PRICE_ARTEFACT_SLOT_3_PRICE = 75;
    public static final int PRICE_CHANGE_AVATAR_NAME = 100;
    public static final Integer PRICE_SKIP_QUEST = 5;
    public static final int PRICE_REMOVE_AVATAR_NAME = 50;
    public static final int PRICE_CHANGE_FRACTION = 200;

    public static boolean checkEnergy(AvatarData avatar, int needEnergy) {
        if (avatar.energy < needEnergy) {
            String text = String.format("\u041d\u0443\u0436\u043d\u043e \u0431\u043e\u043b\u044c\u0448\u0435 \u044d\u043d\u0435\u0440\u0433\u0438\u0438!\n%d/%d", avatar.energy, needEnergy);
            WarningWindow window = new WarningWindow(WarningWindow.Type.INFO, "\u042d\u043d\u0435\u0440\u0433\u0438\u044f", text, "\u0412 \u043e\u0431\u043c\u0435\u043d\u043d\u0438\u043a");
            window.setActionlistener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    WindowManager.getInstance().closeAll();
                }
            });
            WindowManager.getInstance().open(window, true);
            return false;
        }
        return true;
    }

    public static boolean checkCrystals(PlayerData player, int needCrystals) {
        final WindowManager windowManager = WindowManager.getInstance();
        if (player.crystals < needCrystals) {
            String text = String.format("\u041d\u0443\u0436\u043d\u043e \u0431\u043e\u043b\u044c\u0448\u0435 \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043e\u0432!\n%d/%d", player.crystals, needCrystals);
            final WarningWindow window = new WarningWindow(WarningWindow.Type.INFO, "\u0411\u0430\u043d\u043a", text, "\u0412 \u0431\u0430\u043d\u043a");
            window.setActionlistener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    windowManager.close(window);
                    windowManager.closeAll();
                    windowManager.open(new BankWindow());
                }
            });
            windowManager.open(window, true);
            return false;
        }
        return true;
    }

    public static void showConfirmWindow(int price, ClickListener clickListener) {
        String text = String.format("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u043e\u043a\u0443\u043f\u043a\u0438 %d \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u043e\u0432, \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c?", price);
        FinanceManager.showConfirmWindow(text, clickListener);
    }

    public static void showConfirmWindow(String name, int price, ClickListener clickListener) {
        String text = String.format("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u043e\u043a\u0443\u043f\u043a\u0438 %s %d \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u043e\u0432, \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c?", name, price);
        FinanceManager.showConfirmWindow(text, clickListener);
    }

    public static void showConfirmWindow(String text, ClickListener clickListener) {
        WarningWindow window = new WarningWindow(WarningWindow.Type.INFO, "\u0411\u0430\u043d\u043a", text, "\u0414\u0430");
        window.setActionlistener(clickListener);
        WindowManager.getInstance().open(window, true);
    }
}

