/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.managers;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarTutorialData;
import com.tpwar.game.managers.FinanceManager;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.net.Commander;
import com.tpwar.sound.SoundSystem;
import com.tpwar.storage.Storage;
import com.tpwar.storage.tutorial.TutorialData;

public class UnitManager {
    public static void buyUnits() {
        Model model = Model.getInstance();
        Storage storage = Storage.getInstance();
        final Commander commander = Commander.getInstance();
        final SoundSystem soundSystem = SoundSystem.getInstance();
        AvatarTutorialData tutorial = model.player.selectedAvatar.getCurrentTutorial();
        if (tutorial != null) {
            TutorialData tutorialData = storage.tutorial.get(tutorial.tutorialId);
            if (tutorialData.isArmyTutorial()) {
                String text = model.lang.format("window.barrack.tutorial_message", 20);
                FinanceManager.showConfirmWindow(text, new ClickListener(){

                    @Override
                    public void clicked(InputEvent event, float x, float y) {
                        WindowManager.getInstance().closeCurrentWindow();
                        commander.BuyUnits();
                    }
                });
            }
        } else if (FinanceManager.checkCrystals(model.player, 20)) {
            FinanceManager.showConfirmWindow(20, new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    WindowManager.getInstance().closeCurrentWindow();
                    commander.BuyUnits();
                    soundSystem.fx.play("sound/fx/28. Buy_crystal.mp3");
                }
            });
        }
    }
}

