/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.maps;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.avatar.BattleMarkData;
import com.tpwar.domain.avatar.TreasureData;
import com.tpwar.game.managers.AvatarManager;
import com.tpwar.game.maps.pathfinding.TiledNode;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.Component;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.action.ActionWindow;
import com.tpwar.game.windows.massage.MessageWindow;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.net.Commander;
import com.tpwar.sound.SoundSystem;
import com.tpwar.storage.Storage;
import com.tpwar.storage.planet.PlanetData;
import packet.Static;

public class ActionMenu
extends Group {
    private static final Model model = Model.getInstance();
    private static final Assets assets = Assets.getInstance();
    private static final Commander commander = Commander.getInstance();
    private static final WindowManager windowManager = WindowManager.getInstance();
    private static final TextureAtlas atlas = assets.get("maps/map_artefacts.atlas", TextureAtlas.class);
    private Button moveBtn;
    private Button openBtn;
    private Button digBtn;
    private Button msgBtn;
    private Button attackBtn;
    private AvatarData avatar;
    private AvatarData firstAvailOpponent;
    private Array<AvatarData> avatars;
    private Array<BattleMarkData> battles;
    private TiledNode start;
    private TiledNode end;

    public ActionMenu(ClickListener moveListener) {
        this.avatar = ActionMenu.model.player.selectedAvatar;
        Image bg = new Image(atlas.findRegion("menu_action_bg"));
        bg.setPosition(4.0f, 4.0f);
        this.addActor(bg);
        this.moveBtn = Component.getImageButton(atlas, "menu_action_move");
        this.moveBtn.setPosition(46.35f, 46.35f);
        this.moveBtn.addListener(moveListener);
        this.addActor(this.moveBtn);
        this.openBtn = Component.getImageButton(atlas, "menu_action_av");
        this.openBtn.setPosition(0.0f, 36.75f);
        this.openBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ActionMenu.this.openActionWindow();
                ActionMenu.this.remove();
            }
        });
        this.addActor(this.openBtn);
        this.digBtn = Component.getImageButton(atlas, "menu_action_dig");
        this.digBtn.setPosition(36.8f, 0.0f);
        this.digBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (ActionMenu.this.avatar.treasureData.planetId == ActionMenu.this.avatar.planetId && ActionMenu.this.avatar.zoneId == ActionMenu.this.avatar.treasureData.zoneId && ActionMenu.this.avatar.treasureData.position == ActionMenu.this.avatar.position) {
                    commander.TreasureActionDig(ActionMenu.this.avatar.treasureId);
                    SoundSystem.getInstance().fx.play("sound/fx/22. Start_treasure_digging.mp3");
                } else {
                    Storage storage = Storage.getInstance();
                    Static.StaticZone zone = storage.zone.get(ActionMenu.this.avatar.treasureData.zoneId);
                    Object message = "\u041a\u043b\u0430\u0434 \u0437\u0430\u0440\u044b\u0442 \u043d\u0430 " + zone.getPosition() + " \u0437\u043e\u043d\u0435 \u043f\u043b\u0430\u043d\u0435\u0442\u044b \u041c\u0430\u0443\u0440\u043e";
                    if (ActionMenu.this.avatar.zoneId == ActionMenu.this.avatar.treasureData.zoneId) {
                        message = "\u0414\u043b\u044f \u043d\u0430\u0447\u0430\u043b\u0430 \u0440\u0430\u0441\u043a\u043e\u043f\u043e\u043a \u0432\u0441\u0442\u0430\u043d\u044c\u0442\u0435 \u043d\u0430 \u043f\u043e\u043c\u0435\u0447\u0435\u043d\u043d\u0443\u044e \u043a\u043b\u0435\u0442\u043a\u0443";
                    }
                    WarningWindow wnd = new WarningWindow(WarningWindow.Type.INFO, "\u0420\u0430\u0441\u043a\u043e\u043f\u043a\u0438", (String)message, "\u041e\u043a");
                    WindowManager.getInstance().open(wnd, true);
                }
                ActionMenu.this.remove();
            }
        });
        this.addActor(this.digBtn);
        this.msgBtn = Component.getImageButton(atlas, "menu_action_msg");
        this.msgBtn.setPosition(126.65f, 36.75f);
        this.msgBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                MessageWindow wnd = new MessageWindow(ActionMenu.this.avatars.first().name);
                windowManager.open(wnd);
            }
        });
        this.addActor(this.msgBtn);
        this.attackBtn = Component.getImageButton(atlas, "menu_action_attack");
        this.attackBtn.setPosition(36.8f, 126.65f);
        this.attackBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                AvatarManager.attack(ActionMenu.this.firstAvailOpponent);
            }
        });
        this.addActor(this.attackBtn);
    }

    private void openActionWindow() {
        ActionWindow wnd = new ActionWindow(this.avatars, this.battles);
        windowManager.open(wnd);
    }

    public void show(TiledNode start, TiledNode end, Array<AvatarData> avatars, Array<BattleMarkData> battles, TreasureData treasure) {
        this.start = start;
        this.end = end;
        this.avatars = avatars;
        this.battles = battles;
        this.setX(end.x * 64 + 10);
        this.setY((end.y + 1) * 64 - 60);
        this.updateEnableButtons();
    }

    public void updateEnableButtons() {
        this.firstAvailOpponent = null;
        PlanetData planetData = Storage.getInstance().planet.get(this.avatar.planetId);
        for (AvatarData a : this.avatars) {
            if (!this.avatar.canAttack(a, planetData)) continue;
            this.firstAvailOpponent = a;
            break;
        }
        this.attackBtn.setDisabled(this.firstAvailOpponent == null);
        this.msgBtn.setDisabled(this.avatars.size == 0);
        this.openBtn.setDisabled(this.avatars.size == 0 && this.battles.size == 0);
        this.digBtn.setDisabled(this.avatar.treasureId == 0L);
    }

    public TiledNode getStart() {
        return this.start;
    }

    public TiledNode getEnd() {
        return this.end;
    }
}

