/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.maps;

import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.tpwar.game.maps.entity.AnimatedObject;
import com.tpwar.game.maps.entity.Entity;
import com.tpwar.game.utils.Assets;
import com.tpwar.sound.SoundSystem;

public class StepPoint
extends AnimatedObject
implements Entity {
    private int priority;

    public StepPoint(Animation<TextureRegion> animation) {
        super(animation);
        this.setPriority(0);
    }

    public void show(int x, int y) {
        super.setPosition(x + 50, y - 18);
        this.setTime(0.0f);
        this.play();
        SoundSystem.getInstance().fx.play("sound/fx/7. Click_Usual.mp3", false);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    public static StepPoint create() {
        Assets assets = Assets.getInstance();
        TextureAtlas atlas = assets.get("maps/map_artefacts.atlas", TextureAtlas.class);
        Animation<TextureRegion> animation = new Animation<TextureRegion>(0.03f, assets.extractRegions(atlas, "step_point"));
        animation.setPlayMode(Animation.PlayMode.NORMAL);
        return new StepPoint(animation);
    }
}

