/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.maps;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.TiledMapTileSet;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.utils.Array;
import com.tpwar.game.maps.TpmapTile;
import com.tpwar.game.maps.data.AdobeAtlas;
import com.tpwar.game.maps.data.TpmapData;
import com.tpwar.game.maps.entity.Entity;
import com.tpwar.game.maps.entity.TpmapObject;
import com.tpwar.game.maps.pathfinding.TiledNode;
import com.tpwar.game.utils.Assets;
import com.tpwar.storage.Storage;
import java.util.Comparator;
import java.util.Map;
import packet.Static;

public class Tpmap
extends TiledMap {
    public static final String FIRST_LAYER_NAME = "SubstrateTiles";
    public static final String SECOND_LAYER_NAME = "SubstrateDecoration";
    public static final String THIRD_LAYER_NAME = "SubstrateObjects";
    public static final String FOURTH_LAYER_NAME = "MapObjects";
    public static final int TILE_WIDTH = 64;
    public static final int TILE_HEIGHT = 64;
    public static final int COLUMNS = 20;
    public static final int ROWS = 15;
    public static final int FOG_OF_WAR = 1;
    public static final int TOP_BORDER = 1;
    public static final int BOTTOM_BORDER = 1;
    public static final int TOTAL_ROWS = 17;
    public static final int TOTAL_COLUMNS = 22;
    private Assets assets = Assets.getInstance();
    private Storage storage = Storage.getInstance();
    private int width = 1408;
    private int height = 1088;
    private TiledNode[][] moveMap;
    private boolean canChangeZone = false;
    private Array<TpmapObject> mapObjects;
    private Group objectsLayer;
    private SortObjects sortRunnable;

    public Tpmap() {
        AdobeAtlas grass = this.assets.get("maps/grass.json", AdobeAtlas.class);
        this.getTileSets().addTileSet(this.createTileSet(FIRST_LAYER_NAME, grass));
        AdobeAtlas aqua = this.assets.get("maps/aqua.json", AdobeAtlas.class);
        this.getTileSets().addTileSet(this.createTileSet(SECOND_LAYER_NAME, aqua));
        AdobeAtlas stones = this.assets.get("maps/stones.json", AdobeAtlas.class);
        this.getTileSets().addTileSet(this.createTileSet(THIRD_LAYER_NAME, stones));
        AdobeAtlas trees = this.assets.get("maps/trees.json", AdobeAtlas.class);
        this.getTileSets().addTileSet(this.createTileSet(FOURTH_LAYER_NAME, trees));
        this.getLayers().add(this.createTileLayer(FIRST_LAYER_NAME));
        this.getLayers().add(this.createTileLayer(SECOND_LAYER_NAME));
        this.getLayers().add(this.createTileLayer(THIRD_LAYER_NAME));
        this.mapObjects = new Array();
        this.objectsLayer = new Group();
        int sizeMap = 300;
        this.moveMap = new TiledNode[17][22];
        for (int y = -1; y < 16; ++y) {
            int position = sizeMap - 20 - y * 20;
            for (int x = -1; x < 21; ++x) {
                TiledNode node = new TiledNode(x, y, 20);
                node.position = x >= 0 && x < 20 && y >= 0 && y < 15 ? position++ : -1;
                node.walkable = false;
                this.moveMap[y + 1][x + 1] = node;
            }
        }
        this.sortRunnable = new SortObjects(this);
    }

    public void addEntity(Actor entity) {
        this.objectsLayer.addActor(entity);
    }

    public void removeEntity(Actor entity) {
        entity.remove();
    }

    private TiledMapTileSet createTileSet(String name, AdobeAtlas atlas) {
        TiledMapTileSet tilesSet = new TiledMapTileSet();
        tilesSet.setName(name);
        for (Map.Entry<String, AdobeAtlas.FrameData> entry : atlas.frames.entrySet()) {
            String k = entry.getKey();
            AdobeAtlas.FrameData f = entry.getValue();
            TpmapTile tile = new TpmapTile(atlas.atlas.findRegion(k));
            tile.setOriginalOffsetX(f.regPoint.x);
            tile.setOriginalOffsetY(f.regPoint.y);
            int id = Integer.parseInt(k.substring(k.length() - 4)) + 1;
            tilesSet.putTile(id, tile);
        }
        return tilesSet;
    }

    private TiledMapTileLayer createTileLayer(String name) {
        TiledMapTileLayer layer = new TiledMapTileLayer(22, 17, 64, 64);
        layer.setName(name);
        layer.setOpacity(1.0f);
        layer.setVisible(true);
        layer.setOffsetX(0.0f);
        layer.setOffsetY(0.0f);
        for (int y = 0; y < layer.getHeight(); ++y) {
            for (int x = 0; x < layer.getWidth(); ++x) {
                TiledMapTileLayer.Cell cell = new TiledMapTileLayer.Cell();
                cell.setFlipHorizontally(false);
                cell.setFlipVertically(false);
                layer.setCell(x, y, cell);
            }
        }
        return layer;
    }

    private void uodateFogOfWar() {
    }

    public void load(Static.StaticZone currentZone, Static.StaticZone leftZone, Static.StaticZone rightZone) {
        this.load(currentZone, leftZone, rightZone, true);
    }

    /*
     * WARNING - void declaration
     */
    public void load(Static.StaticZone currentZone, Static.StaticZone leftZone, Static.StaticZone rightZone, boolean needObjects) {
        void var10_20;
        void var10_18;
        TpmapData currentZoneData = this.assets.get(this.storage.zone.getPath(currentZone), TpmapData.class);
        boolean bl = this.canChangeZone = leftZone != null && rightZone != null && leftZone.getId() != currentZone.getId();
        if (!this.canChangeZone) {
            leftZone = currentZone;
            rightZone = currentZone;
        }
        for (TpmapData.LayerData layerData : currentZoneData.layers) {
            MapLayer layer = this.getLayers().get(layerData.className);
            if (layer == null) {
                if (!needObjects) break;
                this.loadObjects(this.objectsLayer, layerData);
                break;
            }
            boolean isFirstLayer = FIRST_LAYER_NAME.equals(layer.getName());
            TiledMapTileSet tiledMapTileSet = this.getTileSets().getTileSet(layerData.className);
            for (TpmapData.TileData t : layerData.tiles.values()) {
                GridPoint2 position = Tpmap.getPosition(t.pos);
                TiledMapTileLayer.Cell cell = ((TiledMapTileLayer)layer).getCell(position.x, position.y);
                TpmapTile tile = new TpmapTile((TpmapTile)tiledMapTileSet.getTile(t.frame));
                tile.setOffsetX(-tile.getOriginalOffsetX() + (float)t.oX);
                cell.setTile(tile);
                if (isFirstLayer) {
                    if (position.y == 1) {
                        cell = ((TiledMapTileLayer)layer).getCell(position.x, 0);
                        cell.setTile(tile);
                    } else if (position.y == 15) {
                        cell = ((TiledMapTileLayer)layer).getCell(position.x, 16);
                        cell.setTile(tile);
                    }
                    tile.setOffsetY(64 - tile.getTextureRegion().getRegionHeight() - t.oY);
                    continue;
                }
                tile.setOffsetY((float)(64 - tile.getTextureRegion().getRegionHeight()) + tile.getOriginalOffsetY() - (float)t.oY);
            }
        }
        this.uodateFogOfWar();
        int startPosition = 19;
        int sizeMap = 300;
        TpmapData leftZoneData = this.assets.get(this.storage.zone.getPath(leftZone), TpmapData.class);
        for (TpmapData.LayerData layerData : leftZoneData.layers) {
            MapLayer layer = this.getLayers().get(layerData.className);
            if (layer == null) break;
            boolean isFirstLayer = FIRST_LAYER_NAME.equals(layer.getName());
            TiledMapTileSet tileSet = this.getTileSets().getTileSet(layerData.className);
            for (int y = startPosition; y < sizeMap; y += 20) {
                TpmapData.TileData t = layerData.getTileByPos(y);
                if (t == null) continue;
                GridPoint2 position = Tpmap.getPosition(t.pos);
                TiledMapTileLayer.Cell cell = ((TiledMapTileLayer)layer).getCell(0, position.y);
                TpmapTile tile = new TpmapTile((TpmapTile)tileSet.getTile(t.frame));
                tile.setOffsetX(-tile.getOriginalOffsetX() + (float)t.oX);
                cell.setTile(tile);
                if (isFirstLayer) {
                    if (position.y == 1) {
                        cell = ((TiledMapTileLayer)layer).getCell(0, 0);
                        cell.setTile(tile);
                    } else if (position.y == 15) {
                        cell = ((TiledMapTileLayer)layer).getCell(0, 16);
                        cell.setTile(tile);
                    }
                    tile.setOffsetY(64 - tile.getTextureRegion().getRegionHeight() - t.oY);
                    continue;
                }
                tile.setOffsetY((float)(64 - tile.getTextureRegion().getRegionHeight()) + tile.getOriginalOffsetY() - (float)t.oY);
            }
        }
        startPosition = 0;
        TpmapData rightZoneData = this.assets.get(this.storage.zone.getPath(rightZone), TpmapData.class);
        for (TpmapData.LayerData layerData : rightZoneData.layers) {
            MapLayer layer = this.getLayers().get(layerData.className);
            if (layer == null) break;
            boolean isFirstLayer = FIRST_LAYER_NAME.equals(layer.getName());
            TiledMapTileSet tileSet = this.getTileSets().getTileSet(layerData.className);
            for (int y = startPosition; y < sizeMap; y += 20) {
                TpmapData.TileData t = layerData.getTileByPos(y);
                if (t == null) continue;
                GridPoint2 position = Tpmap.getPosition(t.pos);
                TiledMapTileLayer.Cell cell = ((TiledMapTileLayer)layer).getCell(21, position.y);
                TpmapTile tile = new TpmapTile((TpmapTile)tileSet.getTile(t.frame));
                tile.setOffsetX(-tile.getOriginalOffsetX() + (float)t.oX);
                cell.setTile(tile);
                if (isFirstLayer) {
                    if (position.y == 1) {
                        cell = ((TiledMapTileLayer)layer).getCell(21, 0);
                        cell.setTile(tile);
                    } else if (position.y == 15) {
                        cell = ((TiledMapTileLayer)layer).getCell(21, 16);
                        cell.setTile(tile);
                    }
                    tile.setOffsetY(64 - tile.getTextureRegion().getRegionHeight() - t.oY);
                    continue;
                }
                tile.setOffsetY((float)(64 - tile.getTextureRegion().getRegionHeight()) + tile.getOriginalOffsetY() - (float)t.oY);
            }
        }
        boolean bl2 = false;
        while (var10_18 < currentZoneData.moveMap.length) {
            for (int y = 0; y < currentZoneData.moveMap[var10_18].length; ++y) {
                TiledNode node = this.moveMap[15 - var10_18][y + 1];
                node.walkable = currentZoneData.moveMap[var10_18][y] == 0;
            }
            ++var10_18;
        }
        boolean bl3 = false;
        while (var10_20 < 15) {
            TiledNode node = this.getNode(0, (int)(var10_20 + true));
            node.leftZoneId = this.canChangeZone ? leftZone.getId() : 0L;
            node = this.getNode(21, (int)(var10_20 + true));
            node.rightZoneId = this.canChangeZone ? rightZone.getId() : 0L;
            ++var10_20;
        }
    }

    public void sortObjects() {
        Gdx.app.postRunnable(this.sortRunnable);
    }

    private void loadObjects(Group layer, TpmapData.LayerData layerData) {
        TiledMapTileSet tileSet = this.getTileSets().getTileSet(layerData.className);
        for (TpmapData.TileData t : layerData.tiles.values()) {
            GridPoint2 position = Tpmap.getPosition(t.pos);
            TpmapTile tile = new TpmapTile((TpmapTile)tileSet.getTile(t.frame));
            TpmapObject tree = new TpmapObject(tile.getTextureRegion());
            tree.setPosition(t.pos);
            float offsetX = -tile.getOriginalOffsetX() + (float)t.oX;
            float offsetY = (float)(64 - tile.getTextureRegion().getRegionHeight()) + tile.getOriginalOffsetY() - (float)t.oY;
            tree.setX((float)(position.x * 64) + offsetX);
            tree.setY((float)(position.y * 64) + offsetY);
            layer.addActor(tree);
            this.mapObjects.add(tree);
        }
    }

    public TpmapObject getMapObject(int position) {
        for (TpmapObject object : this.mapObjects) {
            if (object.getPosition() != position) continue;
            return object;
        }
        return null;
    }

    public boolean walkable(int x, int y) {
        if (this.canChangeZone && (x == -1 || x == 22)) {
            return true;
        }
        if (x < 0 || y < 0 || x >= 22 || y >= 17) {
            return false;
        }
        return this.moveMap[y][x].walkable;
    }

    public TiledNode getNode(int x, int y) {
        if (x < 0 || y < 0 || x >= 22 || y >= 17) {
            return null;
        }
        return this.moveMap[y][x];
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void clearObjects() {
        for (MapLayer layer : this.getLayers()) {
            for (int y = 0; y < 17; ++y) {
                for (int x = 0; x < 22; ++x) {
                    TiledMapTileLayer.Cell cell = ((TiledMapTileLayer)layer).getCell(x, y);
                    cell.setTile(null);
                }
            }
        }
        this.objectsLayer.clear();
    }

    public static GridPoint2 getPosition(int position) {
        int x = position % 20;
        int y = position / 20;
        return new GridPoint2(x + 1, 15 - y - 1 + 1);
    }

    public boolean canChangeZone() {
        return this.canChangeZone;
    }

    public Group getObjectsLayer() {
        return this.objectsLayer;
    }

    public static class SortObjects
    implements Runnable {
        private final Tpmap map;

        public SortObjects(Tpmap map) {
            this.map = map;
        }

        @Override
        public void run() {
            this.map.getObjectsLayer().getChildren().sort(new Comparator<Actor>(){

                @Override
                public int compare(Actor o1, Actor o2) {
                    if (o1.getY() > o2.getY()) {
                        return -1;
                    }
                    if (o1.getY() < o2.getY()) {
                        return 1;
                    }
                    if (o1 instanceof Entity && o2 instanceof Entity) {
                        Entity e1 = (Entity)((Object)o1);
                        Entity e2 = (Entity)((Object)o2);
                        if (e1.getPriority() < e2.getPriority()) {
                            return -1;
                        }
                        if (e1.getPriority() > e2.getPriority()) {
                            return 1;
                        }
                    }
                    return 0;
                }
            });
        }
    }
}

