/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.maps;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.utils.Timer;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.ScaleScreen;

public class TutorialPoint
extends Container<Image> {
    private Assets assets = Assets.getInstance();
    private Timer.Task repeatTimer;
    private Image tutorialPoint;

    public TutorialPoint() {
        TextureAtlas atlas = this.assets.get("ui/common.atlas", TextureAtlas.class);
        this.tutorialPoint = new Image(this.assets.getDrawable(atlas, "tutorial_point"));
        this.tutorialPoint.setTouchable(Touchable.disabled);
        this.tutorialPoint.setOrigin(1);
        this.setActor(this.tutorialPoint);
        this.pack();
        this.repeatTimer = new Timer.Task(){

            @Override
            public void run() {
                float scale = TutorialPoint.this.tutorialPoint.getStage() != null && TutorialPoint.this.tutorialPoint.getStage().getViewport() instanceof ScreenViewport ? ScaleScreen.getScale() : 1.0f;
                TutorialPoint.this.tutorialPoint.setScale(scale * 0.92f);
                TutorialPoint.this.tutorialPoint.getColor().a = 0.0f;
                TutorialPoint.this.tutorialPoint.addAction(Actions.sequence((Action)Actions.parallel((Action)Actions.scaleTo(scale, scale, 0.25f, Interpolation.linear), (Action)Actions.alpha(1.0f, 0.25f, Interpolation.linear)), (Action)Actions.scaleTo(scale * 0.92f, scale * 0.92f, 0.25f, Interpolation.linear), (Action)Actions.scaleTo(scale, scale, 0.25f, Interpolation.linear), (Action)Actions.alpha(0.0f, 1.0f, Interpolation.linear)));
            }
        };
    }

    public void play() {
        if (!this.repeatTimer.isScheduled()) {
            Timer.schedule(this.repeatTimer, 0.0f, 2.5f);
        }
    }

    public void stop() {
        this.repeatTimer.cancel();
    }
}

